/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.message;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.sql.engine.message.QueryStartRequest;
import org.apache.ignite3.internal.sql.engine.message.QueryStartRequestBuilder;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesFactory;

class QueryStartRequestDeserializer
implements MessageDeserializer<QueryStartRequest> {
    private final QueryStartRequestBuilder msg;

    QueryStartRequestDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryStartRequest();
    }

    @Override
    public Class<QueryStartRequest> klass() {
        return QueryStartRequest.class;
    }

    @Override
    public QueryStartRequest getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("catalogVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.catalogVersion(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 2: {
                byte[] tmp = reader.readByteArray("fragmentDescriptionByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fragmentDescriptionByteArray(tmp);
                reader.incrementState();
            }
            case 3: {
                long tmp = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fragmentId(tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readHybridTimestamp("operationTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.operationTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readByteArray("parametersByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.parametersByteArray((byte[])tmp);
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.queryId((UUID)tmp);
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readString("root");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.root((String)tmp);
                reader.incrementState();
            }
            case 8: {
                Object tmp = reader.readString("timeZoneId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timeZoneId((String)tmp);
                reader.incrementState();
            }
            case 9: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 10: {
                Object tmp = reader.readByteArray("txAttributesByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txAttributesByteArray((byte[])tmp);
                reader.incrementState();
            }
            case 11: {
                Object tmp = reader.readString("username");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.username((String)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryStartRequest.class);
    }
}

