/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.mapping;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ExecutionTargetFactory;
import org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster.LargeClusterFactory;
import org.apache.ignite3.internal.sql.engine.exec.mapping.smallcluster.SmallClusterFactory;

class MappingContext {
    private final String localNode;
    private final List<String> nodes;
    private final RelOptCluster cluster;
    private final ExecutionTargetFactory targetFactory;

    MappingContext(String localNode, List<String> nodes, RelOptCluster cluster) {
        this.localNode = localNode;
        this.nodes = nodes;
        this.cluster = cluster;
        this.targetFactory = nodes.size() > 64 ? new LargeClusterFactory(nodes) : new SmallClusterFactory(nodes);
    }

    public RelOptCluster cluster() {
        return this.cluster;
    }

    public String localNode() {
        return this.localNode;
    }

    public List<String> nodes() {
        return this.nodes;
    }

    public ExecutionTargetFactory targetFactory() {
        return this.targetFactory;
    }
}

