/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.metric;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.api.metric.MetricSet;
import org.apache.ignite3.internal.rest.api.metric.MetricSource;

@Controller(value="/management/v1/metric/node")
@Tag(name="nodeMetric")
public interface NodeMetricApi {
    @Operation(operationId="enableNodeMetric", summary="Enable metric source", description="Enables the specified metric source.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Metric source enabled."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Metric source not found.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"text/plain"})
    @Produces(value={"application/problem+json"})
    @Post(value="enable")
    public void enable(@Body String var1);

    @Operation(operationId="disableNodeMetric", summary="Disable metric source", description="Disables the specified metric source.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Metric source disabled."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Metric source not found.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"text/plain"})
    @Produces(value={"application/problem+json"})
    @Post(value="disable")
    public void disable(@Body String var1);

    @Operation(operationId="listNodeMetricSources", summary="List metric sources", description="Gets a list of all available metric sources.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned a list of metric sources.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MetricSource.class)))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="source")
    public Collection<MetricSource> listMetricSources();

    @Operation(operationId="listNodeMetricSets", summary="List metric sets", description="Gets a list of all enabled metric sets.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned a list of metric sets.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MetricSet.class)))}), @ApiResponse(responseCode="500", description="Internal error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="set")
    public Collection<MetricSet> listMetricSets();
}

