/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.server.impl;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.ignite3.internal.raft.RaftNodeId;
import org.apache.ignite3.internal.raft.storage.LogStorageFactory;
import org.apache.ignite3.internal.raft.storage.impl.StorageDestructionIntent;
import org.apache.ignite3.internal.raft.storage.impl.StoragesDestructionContext;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;

public class GroupStoragesContextResolver {
    private final Function<ReplicationGroupId, String> groupNameResolver;
    private final Map<String, Path> serverDataPathByGroupName;
    private final Map<String, LogStorageFactory> logStorageFactoryByGroupName;

    public GroupStoragesContextResolver(Function<ReplicationGroupId, String> groupNameResolver, Map<String, Path> serverDataPathByGroupName, Map<String, LogStorageFactory> logStorageFactoryByGroupName) {
        this.groupNameResolver = groupNameResolver;
        this.serverDataPathByGroupName = Map.copyOf(serverDataPathByGroupName);
        this.logStorageFactoryByGroupName = Map.copyOf(logStorageFactoryByGroupName);
    }

    StoragesDestructionContext getContext(StorageDestructionIntent intent) {
        LogStorageFactory logStorageFactory = intent.isVolatile() ? null : this.logStorageFactoryByGroupName.get(intent.groupName());
        return new StoragesDestructionContext(intent, logStorageFactory, this.serverDataPathByGroupName.get(intent.groupName()));
    }

    StorageDestructionIntent getIntent(RaftNodeId nodeId, boolean isVolatile) {
        return new StorageDestructionIntent(nodeId.nodeIdStringForStorage(), this.groupNameResolver.apply(nodeId.groupId()), isVolatile);
    }

    Collection<Path> serverDataPaths() {
        return List.copyOf(this.serverDataPathByGroupName.values());
    }

    Collection<LogStorageFactory> logStorageFactories() {
        return List.copyOf(this.logStorageFactoryByGroupName.values());
    }
}

