/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.ignite3.internal.failure.FailureManager;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.metrics.sources.RaftMetricSource;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.MessagingService;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.raft.ExceptionFactory;
import org.apache.ignite3.internal.raft.IndexWithTerm;
import org.apache.ignite3.internal.raft.Marshaller;
import org.apache.ignite3.internal.raft.PeersAndLearners;
import org.apache.ignite3.internal.raft.RaftGroupEventsListener;
import org.apache.ignite3.internal.raft.RaftGroupOptionsConfigurer;
import org.apache.ignite3.internal.raft.RaftGroupServiceImpl;
import org.apache.ignite3.internal.raft.RaftManager;
import org.apache.ignite3.internal.raft.RaftNodeId;
import org.apache.ignite3.internal.raft.RaftServiceFactory;
import org.apache.ignite3.internal.raft.StoppingExceptionFactories;
import org.apache.ignite3.internal.raft.StoredRaftNodeId;
import org.apache.ignite3.internal.raft.ThrottlingContextHolder;
import org.apache.ignite3.internal.raft.ThrottlingContextHolderImpl;
import org.apache.ignite3.internal.raft.configuration.RaftConfiguration;
import org.apache.ignite3.internal.raft.configuration.RaftView;
import org.apache.ignite3.internal.raft.configuration.VolatileRaftConfiguration;
import org.apache.ignite3.internal.raft.server.RaftGroupOptions;
import org.apache.ignite3.internal.raft.server.RaftServer;
import org.apache.ignite3.internal.raft.server.impl.GroupStoragesContextResolver;
import org.apache.ignite3.internal.raft.server.impl.JraftServerImpl;
import org.apache.ignite3.internal.raft.service.RaftGroupListener;
import org.apache.ignite3.internal.raft.service.RaftGroupService;
import org.apache.ignite3.internal.raft.storage.GroupStoragesDestructionIntents;
import org.apache.ignite3.internal.raft.storage.impl.NoopGroupStoragesDestructionIntents;
import org.apache.ignite3.internal.raft.util.ThreadLocalOptimizedMarshaller;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.option.NodeOptions;
import org.apache.ignite3.raft.jraft.rpc.impl.ActionRequestInterceptor;
import org.apache.ignite3.raft.jraft.rpc.impl.RaftGroupEventsClientListener;
import org.apache.ignite3.raft.jraft.rpc.impl.core.AppendEntriesRequestInterceptor;
import org.apache.ignite3.raft.jraft.util.Utils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class Loza
implements RaftManager {
    public static final RaftMessagesFactory FACTORY = new RaftMessagesFactory();
    public static final String CLIENT_POOL_NAME = "Raft-Group-Client";
    private static final int CLIENT_POOL_SIZE = Math.min(Utils.cpus() * 3, 20);
    private static final IgniteLogger LOG = Loggers.forClass(Loza.class);
    private final ClusterService clusterNetSvc;
    private final JraftServerImpl raftServer;
    private final ScheduledExecutorService executor;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final RaftConfiguration raftConfiguration;
    private final NodeOptions opts;
    private final MetricManager metricManager;
    private final ThrottlingContextHolder partitionThrottlingContextHolder;
    private final ThrottlingContextHolder systemGroupsThrottlingContextHolder;

    @TestOnly
    public Loza(ClusterService clusterService, MetricManager metricManager, RaftConfiguration raftConfiguration, HybridClock hybridClock, RaftGroupEventsClientListener raftGroupEventsClientListener, FailureManager failureManager) {
        this(clusterService, metricManager, raftConfiguration, hybridClock, raftGroupEventsClientListener, failureManager, new NoopGroupStoragesDestructionIntents(), new GroupStoragesContextResolver(Objects::toString, Map.of(), Map.of()));
    }

    public Loza(ClusterService clusterNetSvc, MetricManager metricManager, RaftConfiguration raftConfiguration, HybridClock clock, RaftGroupEventsClientListener raftGroupEventsClientListener, FailureManager failureManager, GroupStoragesDestructionIntents groupStoragesDestructionIntents, GroupStoragesContextResolver groupStoragesContextResolver) {
        this.clusterNetSvc = clusterNetSvc;
        this.raftConfiguration = raftConfiguration;
        this.metricManager = metricManager;
        NodeOptions options = new NodeOptions();
        options.setClock(clock);
        options.setCommandsMarshaller(new ThreadLocalOptimizedMarshaller(clusterNetSvc.serializationRegistry()));
        this.opts = options;
        double maxInflightOverflowRate = (Double)raftConfiguration.maxInflightOverflowRate().value();
        this.partitionThrottlingContextHolder = new ThrottlingContextHolderImpl(raftConfiguration, maxInflightOverflowRate);
        this.systemGroupsThrottlingContextHolder = new ThrottlingContextHolderImpl(raftConfiguration, 2.147483647E9);
        this.raftServer = new JraftServerImpl(clusterNetSvc, options, raftGroupEventsClientListener, failureManager, groupStoragesDestructionIntents, groupStoragesContextResolver);
        this.executor = new ScheduledThreadPoolExecutor(CLIENT_POOL_SIZE, IgniteThreadFactory.create(clusterNetSvc.nodeName(), CLIENT_POOL_NAME, LOG, new ThreadOperation[0]));
    }

    public void appendEntriesRequestInterceptor(AppendEntriesRequestInterceptor appendEntriesRequestInterceptor) {
        this.raftServer.appendEntriesRequestInterceptor(appendEntriesRequestInterceptor);
    }

    public void actionRequestInterceptor(ActionRequestInterceptor actionRequestInterceptor) {
        this.raftServer.actionRequestInterceptor(actionRequestInterceptor);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        RaftView raftConfig = (RaftView)this.raftConfiguration.value();
        RaftMetricSource stripeSource = new RaftMetricSource(((RaftView)this.raftConfiguration.value()).stripes(), ((RaftView)this.raftConfiguration.value()).logStripesCount());
        this.metricManager.registerSource(stripeSource);
        this.metricManager.enable(stripeSource);
        this.opts.setRaftMetrics(stripeSource);
        this.opts.setRpcInstallSnapshotTimeout(raftConfig.installSnapshotTimeoutMillis());
        this.opts.setStripes(raftConfig.disruptor().stripes());
        this.opts.setLogStripesCount(raftConfig.disruptor().logManagerStripes());
        this.opts.setLogYieldStrategy(raftConfig.logYieldStrategy());
        this.opts.getRaftOptions().setDisruptorBufferSize(raftConfig.disruptor().queueSize());
        this.opts.getRaftOptions().setSync(raftConfig.fsync());
        return this.raftServer.startAsync(componentContext);
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        IgniteUtils.shutdownAndAwaitTermination(this.executor, 10L, TimeUnit.SECONDS);
        return this.raftServer.stopAsync(componentContext);
    }

    @Override
    public <T extends RaftGroupService> T startRaftGroupNode(RaftNodeId nodeId, PeersAndLearners configuration, RaftGroupListener lsnr, RaftGroupEventsListener eventsLsnr, @Nullable RaftServiceFactory<T> factory, RaftGroupOptionsConfigurer groupOptionsConfigurer) throws NodeStoppingException {
        RaftGroupOptions groupOptions = RaftGroupOptions.defaults();
        groupOptionsConfigurer.configure(groupOptions);
        return this.startRaftGroupNode(nodeId, configuration, lsnr, eventsLsnr, groupOptions, factory);
    }

    public RaftGroupService startRaftGroupNode(RaftNodeId nodeId, PeersAndLearners configuration, RaftGroupListener lsnr, RaftGroupEventsListener eventsLsnr, RaftGroupOptions groupOptions) throws NodeStoppingException {
        return this.startRaftGroupNode(nodeId, configuration, lsnr, eventsLsnr, groupOptions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RaftGroupService> T startRaftGroupNode(RaftNodeId nodeId, PeersAndLearners configuration, RaftGroupListener lsnr, RaftGroupEventsListener eventsLsnr, RaftGroupOptions groupOptions, @Nullable RaftServiceFactory<T> raftServiceFactory) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            T t = this.startRaftGroupNodeInternal(nodeId, configuration, lsnr, eventsLsnr, groupOptions, raftServiceFactory, StoppingExceptionFactories.indicateComponentStop());
            return t;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends RaftGroupService> T startSystemRaftGroupNodeAndWaitNodeReady(RaftNodeId nodeId, PeersAndLearners configuration, RaftGroupListener lsnr, RaftGroupEventsListener eventsLsnr, @Nullable RaftServiceFactory<T> factory, RaftGroupOptionsConfigurer groupOptionsConfigurer) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            RaftGroupOptions raftGroupOptions = RaftGroupOptions.defaults().setSystemGroup(true);
            groupOptionsConfigurer.configure(raftGroupOptions);
            T t = this.startRaftGroupNodeInternal(nodeId, configuration, lsnr, eventsLsnr, raftGroupOptions, factory, StoppingExceptionFactories.indicateNodeStop());
            return t;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RaftGroupService startRaftGroupService(ReplicationGroupId groupId, PeersAndLearners configuration, boolean isSystemGroup) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            RaftGroupService raftGroupService = this.startRaftGroupServiceInternal(groupId, configuration, this.opts.getCommandsMarshaller(), StoppingExceptionFactories.indicateComponentStop(), isSystemGroup);
            return raftGroupService;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends RaftGroupService> T startRaftGroupService(ReplicationGroupId groupId, PeersAndLearners configuration, RaftServiceFactory<T> factory, @Nullable Marshaller commandsMarshaller, ExceptionFactory stoppingExceptionFactory, boolean isSystemGroup) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            if (commandsMarshaller == null) {
                commandsMarshaller = this.opts.getCommandsMarshaller();
            }
            ThrottlingContextHolder throttlingContextHolder = isSystemGroup ? this.systemGroupsThrottlingContextHolder : this.partitionThrottlingContextHolder;
            T t = factory.startRaftGroupService(groupId, configuration, this.raftConfiguration, this.executor, commandsMarshaller, stoppingExceptionFactory, throttlingContextHolder);
            return t;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyRaftNodeStorages(RaftNodeId nodeId, RaftGroupOptionsConfigurer raftGroupOptionsConfigurer) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            RaftGroupOptions groupOptions = RaftGroupOptions.defaults();
            raftGroupOptionsConfigurer.configure(groupOptions);
            this.raftServer.destroyRaftNodeStoragesDurably(nodeId, groupOptions);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void destroyRaftNodeStorages(RaftNodeId nodeId, RaftGroupOptions raftGroupOptions) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            this.raftServer.destroyRaftNodeStorages(nodeId, raftGroupOptions);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void destroyRaftNodeStoragesDurably(RaftNodeId nodeId, RaftGroupOptions raftGroupOptions) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            this.raftServer.destroyRaftNodeStoragesDurably(nodeId, raftGroupOptions);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public Set<StoredRaftNodeId> raftNodeIdsOnDisk() throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            Set<StoredRaftNodeId> set = this.raftServer.raftNodeIdsOnDisk();
            return set;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    @Nullable
    public IndexWithTerm raftNodeIndex(RaftNodeId nodeId) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            IndexWithTerm indexWithTerm = this.raftServer.raftNodeIndex(nodeId);
            return indexWithTerm;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private <T extends RaftGroupService> T startRaftGroupNodeInternal(RaftNodeId nodeId, PeersAndLearners configuration, RaftGroupListener lsnr, RaftGroupEventsListener raftGrpEvtsLsnr, RaftGroupOptions groupOptions, @Nullable RaftServiceFactory<T> raftServiceFactory, ExceptionFactory stoppingExceptionFactory) {
        this.startRaftGroupNodeInternalWithoutService(nodeId, configuration, lsnr, raftGrpEvtsLsnr, groupOptions);
        Marshaller cmdMarshaller = Objects.requireNonNullElse(groupOptions.commandsMarshaller(), this.opts.getCommandsMarshaller());
        if (raftServiceFactory == null) {
            return (T)this.startRaftGroupServiceInternal(nodeId.groupId(), configuration, cmdMarshaller, stoppingExceptionFactory, groupOptions.isSystemGroup());
        }
        ThrottlingContextHolder throttlingContextHolder = groupOptions.isSystemGroup() ? this.systemGroupsThrottlingContextHolder : this.partitionThrottlingContextHolder;
        return raftServiceFactory.startRaftGroupService(nodeId.groupId(), configuration, this.raftConfiguration, this.executor, cmdMarshaller, stoppingExceptionFactory, throttlingContextHolder);
    }

    private void startRaftGroupNodeInternalWithoutService(RaftNodeId nodeId, PeersAndLearners configuration, RaftGroupListener lsnr, RaftGroupEventsListener raftGrpEvtsLsnr, RaftGroupOptions groupOptions) {
        boolean started;
        if (LOG.isInfoEnabled()) {
            LOG.info("Start new raft node={} with initial configuration={}", nodeId, configuration);
        }
        if (!(started = this.raftServer.startRaftNode(nodeId, configuration, raftGrpEvtsLsnr, lsnr, groupOptions))) {
            throw new IgniteInternalException(IgniteStringFormatter.format("Raft group on the node is already started [nodeId={}]", nodeId));
        }
    }

    private RaftGroupService startRaftGroupServiceInternal(ReplicationGroupId grpId, PeersAndLearners membersConfiguration, Marshaller commandsMarshaller, ExceptionFactory stoppingExceptionFactory, boolean isSystemGroup) {
        ThrottlingContextHolder throttlingContextHolder = isSystemGroup ? this.systemGroupsThrottlingContextHolder : this.partitionThrottlingContextHolder;
        return RaftGroupServiceImpl.start(grpId, this.clusterNetSvc, FACTORY, this.raftConfiguration, membersConfiguration, this.executor, commandsMarshaller, stoppingExceptionFactory, throttlingContextHolder);
    }

    public boolean isStarted(RaftNodeId nodeId) {
        return this.raftServer.isStarted(nodeId);
    }

    @Override
    public boolean stopRaftNode(RaftNodeId nodeId) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Stop raft node={}", nodeId);
            }
            boolean bl = this.raftServer.stopRaftNode(nodeId);
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public boolean stopRaftNodes(ReplicationGroupId groupId) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Stop raft group={}", groupId);
            }
            boolean bl = this.raftServer.stopRaftNodes(groupId);
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void resetPeers(RaftNodeId raftNodeId, PeersAndLearners peersAndLearners) {
        LOG.warn("Reset peers for raft group {}, new configuration is {}", raftNodeId, peersAndLearners);
        this.raftServer.resetPeers(raftNodeId, peersAndLearners);
    }

    public void forEach(BiConsumer<RaftNodeId, org.apache.ignite3.raft.jraft.RaftGroupService> consumer) {
        this.raftServer.forEach(consumer);
    }

    public MessagingService messagingService() {
        return this.clusterNetSvc.messagingService();
    }

    public TopologyService topologyService() {
        return this.clusterNetSvc.topologyService();
    }

    public VolatileRaftConfiguration volatileRaft() {
        return this.raftConfiguration.volatileRaft();
    }

    @TestOnly
    public RaftServer server() {
        return this.raftServer;
    }

    @TestOnly
    public ClusterService service() {
        return this.clusterNetSvc;
    }

    @TestOnly
    public Set<RaftNodeId> localNodes() {
        return this.raftServer.localNodes();
    }
}

