/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.server;

import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.ignite3.internal.metastorage.WatchEvent;
import org.apache.ignite3.internal.metastorage.WatchListener;

public class Watch {
    private final long startRevision;
    private final Predicate<byte[]> predicate;
    private final WatchListener listener;

    public Watch(long startRevision, WatchListener listener, Predicate<byte[]> predicate) {
        this.predicate = predicate;
        this.listener = listener;
        this.startRevision = startRevision;
    }

    boolean matches(byte[] key, long revision) {
        return revision >= this.startRevision && this.predicate.test(key);
    }

    CompletableFuture<Void> onUpdate(WatchEvent event) {
        return this.listener.onUpdate(event);
    }

    WatchListener listener() {
        return this.listener;
    }

    long startRevision() {
        return this.startRevision;
    }
}

