/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.distributionzones.rebalance;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite3.internal.distributionzones.rebalance.AssignmentUtil;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Conditions;
import org.apache.ignite3.internal.metastorage.dsl.Iif;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.apache.ignite3.internal.metastorage.dsl.Statements;
import org.apache.ignite3.internal.partitiondistribution.Assignment;
import org.apache.ignite3.internal.partitiondistribution.Assignments;
import org.apache.ignite3.internal.partitiondistribution.AssignmentsChain;
import org.apache.ignite3.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite3.internal.partitiondistribution.PartitionDistributionUtils;
import org.apache.ignite3.internal.partitiondistribution.PendingAssignmentsCalculator;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RebalanceUtil {
    private static final IgniteLogger LOG = Loggers.forClass(RebalanceUtil.class);
    public static final String PLANNED_ASSIGNMENTS_PREFIX = "assignments.planned.";
    public static final String PENDING_ASSIGNMENTS_QUEUE_PREFIX = "assignments.pending.";
    public static final byte[] PENDING_ASSIGNMENTS_QUEUE_PREFIX_BYTES = "assignments.pending.".getBytes(StandardCharsets.UTF_8);
    public static final String STABLE_ASSIGNMENTS_PREFIX = "assignments.stable.";
    public static final byte[] STABLE_ASSIGNMENTS_PREFIX_BYTES = "assignments.stable.".getBytes(StandardCharsets.UTF_8);
    public static final String ASSIGNMENTS_SWITCH_REDUCE_PREFIX = "assignments.switch.reduce.";
    public static final byte[] ASSIGNMENTS_SWITCH_REDUCE_PREFIX_BYTES = "assignments.switch.reduce.".getBytes(StandardCharsets.UTF_8);
    public static final String ASSIGNMENTS_SWITCH_APPEND_PREFIX = "assignments.switch.append.";
    public static final String PENDING_CHANGE_TRIGGER_PREFIX = "pending.change.trigger.";
    static final byte[] PENDING_CHANGE_TRIGGER_PREFIX_BYTES = "pending.change.trigger.".getBytes(StandardCharsets.UTF_8);
    private static final String ASSIGNMENTS_CHAIN_PREFIX = "assignments.chain.";

    public static CompletableFuture<Void> updatePendingAssignmentsKeys(CatalogTableDescriptor tableDescriptor, TablePartitionId partId, Collection<String> dataNodes, int partitions, int replicas, int consensusGroupSize, long revision, HybridTimestamp timestamp, MetaStorageManager metaStorageMgr, int partNum, Set<Assignment> tableCfgPartAssignments, long assignmentsTimestamp, Set<String> aliveNodes, ConsistencyMode consistencyMode) {
        Set<Assignment> targetAssignmentSet;
        ByteArray partChangeTriggerKey = RebalanceUtil.pendingChangeTriggerKey(partId);
        ByteArray partAssignmentsPendingKey = RebalanceUtil.pendingPartAssignmentsQueueKey(partId);
        ByteArray partAssignmentsPlannedKey = RebalanceUtil.plannedPartAssignmentsKey(partId);
        ByteArray partAssignmentsStableKey = RebalanceUtil.stablePartAssignmentsKey(partId);
        Set<Assignment> calculatedAssignments = PartitionDistributionUtils.calculateAssignmentForPartition(dataNodes, partNum, partitions, replicas, consensusGroupSize);
        if (consistencyMode == ConsistencyMode.HIGH_AVAILABILITY) {
            Set resultingAssignments = calculatedAssignments.stream().filter(a -> aliveNodes.contains(a.consistentId())).collect(Collectors.toSet());
            for (Assignment assignment : tableCfgPartAssignments) {
                if (!calculatedAssignments.contains(assignment)) continue;
                resultingAssignments.add(assignment);
            }
            targetAssignmentSet = resultingAssignments;
        } else {
            targetAssignmentSet = calculatedAssignments;
        }
        boolean isNewAssignments = !tableCfgPartAssignments.equals(targetAssignmentSet);
        Assignments targetAssignments = Assignments.of(targetAssignmentSet, assignmentsTimestamp);
        AssignmentsQueue partAssignmentsPendingQueue = PendingAssignmentsCalculator.pendingAssignmentsCalculator().stable(Assignments.of(tableCfgPartAssignments, assignmentsTimestamp)).target(targetAssignments).toQueue();
        byte[] partAssignmentsPlannedBytes = targetAssignments.toBytes();
        byte[] partAssignmentsPendingQueueBytes = partAssignmentsPendingQueue.toBytes();
        Condition newAssignmentsCondition = Conditions.exists(partAssignmentsStableKey).and(Conditions.value(partAssignmentsStableKey).ne(partAssignmentsPlannedBytes));
        if (isNewAssignments) {
            newAssignmentsCondition = Conditions.notExists(partAssignmentsStableKey).or(newAssignmentsCondition);
        }
        byte[] timestampBytes = ByteUtils.longToBytesKeepingOrder(timestamp.longValue());
        Iif iif = Statements.iif((Condition)Conditions.or(Conditions.notExists(partChangeTriggerKey), Conditions.value(partChangeTriggerKey).lt(timestampBytes)), Statements.iif((Condition)Conditions.and(Conditions.notExists(partAssignmentsPendingKey), newAssignmentsCondition), Operations.ops(Operations.put(partAssignmentsPendingKey, partAssignmentsPendingQueueBytes), Operations.put(partChangeTriggerKey, timestampBytes)).yield(UpdateStatus.PENDING_KEY_UPDATED.ordinal()), Statements.iif((Condition)Conditions.and(Conditions.value(partAssignmentsPendingKey).ne(partAssignmentsPendingQueueBytes), Conditions.exists(partAssignmentsPendingKey)), Operations.ops(Operations.put(partAssignmentsPlannedKey, partAssignmentsPlannedBytes), Operations.put(partChangeTriggerKey, timestampBytes)).yield(UpdateStatus.PLANNED_KEY_UPDATED.ordinal()), Statements.iif((Condition)Conditions.value(partAssignmentsPendingKey).eq(partAssignmentsPendingQueueBytes), Operations.ops(Operations.remove(partAssignmentsPlannedKey), Operations.put(partChangeTriggerKey, timestampBytes)).yield(UpdateStatus.PLANNED_KEY_REMOVED_EQUALS_PENDING.ordinal()), Statements.iif((Condition)Conditions.notExists(partAssignmentsPendingKey), Operations.ops(Operations.remove(partAssignmentsPlannedKey), Operations.put(partChangeTriggerKey, timestampBytes)).yield(UpdateStatus.PLANNED_KEY_REMOVED_EMPTY_PENDING.ordinal()), Operations.ops(new Operation[0]).yield(UpdateStatus.ASSIGNMENT_NOT_UPDATED.ordinal()))))), Operations.ops(new Operation[0]).yield(UpdateStatus.OUTDATED_UPDATE_RECEIVED.ordinal()));
        return metaStorageMgr.invoke(iif).thenAccept(sr -> {
            switch (UpdateStatus.valueOf(sr.getAsInt())) {
                case PENDING_KEY_UPDATED: {
                    LOG.info("Update metastore pending partitions key [key={}, partition={}, table={}/{}, newVal={}]", partAssignmentsPendingKey.toString(), partNum, tableDescriptor.id(), tableDescriptor.name(), partAssignmentsPendingQueue);
                    break;
                }
                case PLANNED_KEY_UPDATED: {
                    LOG.info("Update metastore planned partitions key [key={}, partition={}, table={}/{}, newVal={}]", partAssignmentsPlannedKey, partNum, tableDescriptor.id(), tableDescriptor.name(), targetAssignmentSet);
                    break;
                }
                case PLANNED_KEY_REMOVED_EQUALS_PENDING: {
                    LOG.info("Remove planned key because current pending key has the same value [key={}, partition={}, table={}/{}, val={}]", partAssignmentsPlannedKey.toString(), partNum, tableDescriptor.id(), tableDescriptor.name(), targetAssignmentSet);
                    break;
                }
                case PLANNED_KEY_REMOVED_EMPTY_PENDING: {
                    LOG.info("Remove planned key because pending is empty and calculated assignments are equal to current assignments [key={}, partition={}, table={}/{}, val={}]", partAssignmentsPlannedKey.toString(), partNum, tableDescriptor.id(), tableDescriptor.name(), targetAssignmentSet);
                    break;
                }
                case ASSIGNMENT_NOT_UPDATED: {
                    LOG.debug("Assignments are not updated [key={}, partition={}, table={}/{}, val={}]", partAssignmentsPlannedKey.toString(), partNum, tableDescriptor.id(), tableDescriptor.name(), targetAssignmentSet);
                    break;
                }
                case OUTDATED_UPDATE_RECEIVED: {
                    LOG.debug("Received outdated rebalance trigger event [revision={}, partition={}, table={}/{}]", revision, partNum, tableDescriptor.id(), tableDescriptor.name());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown return code for rebalance metastore multi-invoke");
                }
            }
        });
    }

    public static CompletableFuture<Void> triggerAllTablePartitionsRebalance(CatalogTableDescriptor tableDescriptor, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, long storageRevision, HybridTimestamp storageTimestamp, MetaStorageManager metaStorageManager, long assignmentsTimestamp, Set<String> aliveNodes) {
        int[] partitionIds = AssignmentUtil.partitionIds(zoneDescriptor.partitions());
        return RebalanceUtil.tableStableAssignments(metaStorageManager, tableDescriptor.id(), partitionIds).thenCompose(stableAssignments -> {
            if (stableAssignments.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            return RebalanceUtil.tablePartitionAssignment(tableDescriptor, zoneDescriptor, dataNodes, storageRevision, storageTimestamp, metaStorageManager, assignmentsTimestamp, stableAssignments, aliveNodes);
        });
    }

    private static CompletableFuture<Void> tablePartitionAssignment(CatalogTableDescriptor tableDescriptor, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, long storageRevision, HybridTimestamp storageTimestamp, MetaStorageManager metaStorageManager, long assignmentsTimestamp, Map<Integer, Assignments> tableAssignments, Set<String> aliveNodes) {
        CompletableFuture[] futures = new CompletableFuture[zoneDescriptor.partitions()];
        for (int partId = 0; partId < zoneDescriptor.partitions(); ++partId) {
            TablePartitionId replicaGrpId = new TablePartitionId(tableDescriptor.id(), partId);
            futures[partId] = RebalanceUtil.updatePendingAssignmentsKeys(tableDescriptor, replicaGrpId, dataNodes, zoneDescriptor.partitions(), zoneDescriptor.replicas(), zoneDescriptor.consensusGroupSize(), storageRevision, storageTimestamp, metaStorageManager, partId, tableAssignments.get(partId).nodes(), assignmentsTimestamp, aliveNodes, zoneDescriptor.consistencyMode());
        }
        ConcurrentHashMap.KeySetView unwrappedCauses = ConcurrentHashMap.newKeySet();
        for (int partId = 0; partId < futures.length; ++partId) {
            int finalPartId = partId;
            futures[partId].exceptionally(e -> {
                Throwable cause = ExceptionUtils.unwrapCause(e);
                if (unwrappedCauses.add(cause)) {
                    LOG.error("Exception on updating assignments for [tableId={}, name={}, partition={}]", (Throwable)e, (Object)tableDescriptor.id(), (Object)tableDescriptor.name(), (Object)finalPartId);
                } else {
                    LOG.error("Exception on updating assignments for [tableId={}, name={}]", (Throwable)e, (Object)tableDescriptor.id(), (Object)tableDescriptor.name());
                }
                return null;
            });
        }
        return CompletableFuture.allOf(futures);
    }

    public static ByteArray pendingChangeTriggerKey(TablePartitionId partId) {
        return new ByteArray(PENDING_CHANGE_TRIGGER_PREFIX + partId);
    }

    public static ByteArray pendingPartAssignmentsQueueKey(TablePartitionId partId) {
        return new ByteArray(PENDING_ASSIGNMENTS_QUEUE_PREFIX + partId);
    }

    public static ByteArray plannedPartAssignmentsKey(TablePartitionId partId) {
        return new ByteArray(PLANNED_ASSIGNMENTS_PREFIX + partId);
    }

    public static ByteArray stablePartAssignmentsKey(TablePartitionId partId) {
        return new ByteArray(STABLE_ASSIGNMENTS_PREFIX + partId);
    }

    public static ByteArray assignmentsChainKey(TablePartitionId partId) {
        return new ByteArray(ASSIGNMENTS_CHAIN_PREFIX + partId);
    }

    public static ByteArray switchReduceKey(TablePartitionId partId) {
        return new ByteArray(ASSIGNMENTS_SWITCH_REDUCE_PREFIX + partId);
    }

    public static ByteArray switchAppendKey(TablePartitionId partId) {
        return new ByteArray(ASSIGNMENTS_SWITCH_APPEND_PREFIX + partId);
    }

    public static TablePartitionId extractTablePartitionId(byte[] key, byte[] prefix) {
        String tablePartitionIdString = StringUtils.toStringWithoutPrefix(key, prefix.length);
        return TablePartitionId.fromString(tablePartitionIdString);
    }

    public static int extractZoneId(byte[] key, byte[] prefix) {
        return Integer.parseInt(StringUtils.toStringWithoutPrefix(key, prefix.length));
    }

    public static boolean recoverable(Throwable t) {
        return true;
    }

    public static <T> Set<T> subtract(Set<T> minuend, Set<T> subtrahend) {
        return minuend.stream().filter(v -> !subtrahend.contains(v)).collect(Collectors.toSet());
    }

    public static <T> Set<T> union(Set<T> op1, Set<T> op2) {
        HashSet<T> res = new HashSet<T>(op1);
        res.addAll(op2);
        return res;
    }

    public static <T> Set<T> intersect(Set<T> op1, Set<T> op2) {
        return op1.stream().filter(op2::contains).collect(Collectors.toSet());
    }

    @TestOnly
    public static CompletableFuture<Set<Assignment>> stablePartitionAssignments(MetaStorageManager metaStorageManager, int tableId, int partitionId) {
        return metaStorageManager.get(RebalanceUtil.stablePartAssignmentsKey(new TablePartitionId(tableId, partitionId))).thenApply(e -> e.value() == null ? null : Assignments.fromBytes(e.value()).nodes());
    }

    @Nullable
    public static Assignments stableAssignmentsGetLocally(MetaStorageManager metaStorageManager, TablePartitionId tablePartitionId, long revision) {
        Entry entry = metaStorageManager.getLocally(RebalanceUtil.stablePartAssignmentsKey(tablePartitionId), revision);
        return entry == null || entry.empty() || entry.tombstone() ? null : Assignments.fromBytes(entry.value());
    }

    @Nullable
    public static Set<Assignment> partitionAssignmentsGetLocally(MetaStorageManager metaStorageManager, int tableId, int partitionNumber, long revision) {
        Assignments assignments = RebalanceUtil.stableAssignmentsGetLocally(metaStorageManager, new TablePartitionId(tableId, partitionNumber), revision);
        return assignments == null ? null : assignments.nodes();
    }

    public static CompletableFuture<Map<Integer, Assignments>> tableStableAssignments(MetaStorageManager metaStorageManager, int tableId, int[] partitionIds) {
        return AssignmentUtil.metastoreAssignments(metaStorageManager, partitionIds, partitionId -> RebalanceUtil.stablePartAssignmentsKey(new TablePartitionId(tableId, (int)partitionId))).whenComplete((assignmentsMap, throwable) -> {
            if (throwable == null) {
                int numberOfMsPartitions = assignmentsMap.size();
                assert (numberOfMsPartitions == 0 || numberOfMsPartitions == partitionIds.length) : "Invalid number of partition entries received from meta storage [received=" + numberOfMsPartitions + ", numberOfPartitions=" + partitionIds.length + ", tableId=" + tableId + "].";
            }
        });
    }

    public static List<Assignments> tableAssignmentsGetLocally(MetaStorageManager metaStorageManager, int tableId, int numberOfPartitions, long revision) {
        return IntStream.range(0, numberOfPartitions).mapToObj(p -> {
            Assignments assignments = RebalanceUtil.stableAssignmentsGetLocally(metaStorageManager, new TablePartitionId(tableId, p), revision);
            assert (assignments != null);
            return assignments;
        }).collect(Collectors.toList());
    }

    public static List<Assignments> tablePendingAssignmentsGetLocally(MetaStorageManager metaStorageManager, int tableId, int numberOfPartitions, long revision) {
        return IntStream.range(0, numberOfPartitions).mapToObj(p -> {
            Entry e = metaStorageManager.getLocally(RebalanceUtil.pendingPartAssignmentsQueueKey(new TablePartitionId(tableId, p)), revision);
            return e != null && e.value() != null ? AssignmentsQueue.fromBytes(e.value()).poll() : null;
        }).collect(Collectors.toList());
    }

    public static List<AssignmentsChain> tableAssignmentsChainGetLocally(MetaStorageManager metaStorageManager, int tableId, int numberOfPartitions, long revision) {
        return IntStream.range(0, numberOfPartitions).mapToObj(p -> RebalanceUtil.assignmentsChainGetLocally(metaStorageManager, new TablePartitionId(tableId, p), revision)).collect(Collectors.toList());
    }

    @Nullable
    public static AssignmentsChain assignmentsChainGetLocally(MetaStorageManager metaStorageManager, TablePartitionId tablePartitionId, long revision) {
        Entry e = metaStorageManager.getLocally(RebalanceUtil.assignmentsChainKey(tablePartitionId), revision);
        return e != null ? AssignmentsChain.fromBytes(e.value()) : null;
    }

    public static enum UpdateStatus {
        PENDING_KEY_UPDATED,
        PLANNED_KEY_UPDATED,
        PLANNED_KEY_REMOVED_EQUALS_PENDING,
        PLANNED_KEY_REMOVED_EMPTY_PENDING,
        ASSIGNMENT_NOT_UPDATED,
        OUTDATED_UPDATE_RECEIVED;

        private static final UpdateStatus[] VALUES;

        public static UpdateStatus valueOf(int ordinal) {
            return VALUES[ordinal];
        }

        static {
            VALUES = UpdateStatus.values();
        }
    }
}

