/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.distributionzones;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite3.internal.distributionzones.Node;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class NodeWithAttributes
implements Comparable<NodeWithAttributes> {
    private final Node node;
    @IgniteToStringInclude
    private final Map<String, String> userAttributes;
    @IgniteToStringInclude
    private final List<String> storageProfiles;

    public NodeWithAttributes(String nodeName, UUID nodeId, @Nullable Map<String, String> userAttributes) {
        this(nodeName, nodeId, userAttributes, List.of());
    }

    public NodeWithAttributes(String nodeName, UUID nodeId, @Nullable Map<String, String> userAttributes, @Nullable List<String> storageProfiles) {
        this.node = new Node(nodeName, nodeId);
        this.userAttributes = userAttributes == null ? Map.of() : userAttributes;
        this.storageProfiles = storageProfiles == null ? List.of() : storageProfiles;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodeWithAttributes that = (NodeWithAttributes)obj;
        return this.node.equals(that.node) && this.userAttributes.equals(that.userAttributes) && this.storageProfiles.equals(that.storageProfiles);
    }

    public String nodeName() {
        return this.node.nodeName();
    }

    public UUID nodeId() {
        return this.node.nodeId();
    }

    public Node node() {
        return this.node;
    }

    public Map<String, String> userAttributes() {
        return this.userAttributes;
    }

    public List<String> storageProfiles() {
        return this.storageProfiles;
    }

    public String toString() {
        return S.toString(NodeWithAttributes.class, this);
    }

    @Override
    public int compareTo(NodeWithAttributes o) {
        return this.node.compareTo(o.node);
    }
}

