/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.validation;

import java.util.List;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.configuration.validation.ExceptKeys;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;

public class ExceptKeysValidator
implements Validator<ExceptKeys, NamedListView<?>> {
    @Override
    public void validate(ExceptKeys annotation, ValidationContext<NamedListView<?>> ctx) {
        NamedListView<?> nameList = ctx.getNewValue();
        List<String> actualNames = nameList.namedListKeys();
        for (String exceptedName : annotation.value()) {
            if (!actualNames.contains(exceptedName)) continue;
            String message = "'" + ctx.currentKey() + "' configuration must not contain elements named '" + exceptedName + "'";
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
        }
    }
}

