/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.direct;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ignite3.configuration.ConfigurationProperty;
import org.apache.ignite3.configuration.NamedConfigurationTree;
import org.apache.ignite3.configuration.NamedListChange;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite3.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite3.internal.configuration.direct.DirectPropertyProxy;
import org.apache.ignite3.internal.configuration.direct.KeyPathNode;
import org.apache.ignite3.internal.configuration.util.ConfigurationUtil;
import org.jetbrains.annotations.Nullable;

public class DirectNamedListProxy<T extends ConfigurationProperty<VIEWT>, VIEWT, CHANGET extends VIEWT>
extends DirectPropertyProxy<NamedListView<VIEWT>>
implements NamedConfigurationTree<T, VIEWT, CHANGET> {
    private final BiFunction<List<KeyPathNode>, DynamicConfigurationChanger, T> creator;

    public DirectNamedListProxy(List<KeyPathNode> keys, DynamicConfigurationChanger changer, BiFunction<List<KeyPathNode>, DynamicConfigurationChanger, T> creator) {
        super(keys, changer);
        this.creator = creator;
    }

    @Override
    @Nullable
    public T get(String name) {
        return (T)((ConfigurationProperty)this.creator.apply(ConfigurationUtil.appendKey(this.keys, new KeyPathNode(name, true)), this.changer));
    }

    @Override
    @Nullable
    public T get(UUID internalId) {
        return (T)((ConfigurationProperty)this.creator.apply(ConfigurationUtil.appendKey(this.keys, new KeyPathNode(internalId.toString(), false)), this.changer));
    }

    @Override
    public List<UUID> internalIds() {
        return (List)this.changer.getLatest(ConfigurationUtil.appendKey(this.keys, new KeyPathNode("<internal_ids>", false)));
    }

    @Override
    public CompletableFuture<Void> change(Consumer<NamedListChange<VIEWT, CHANGET>> change) {
        throw new UnsupportedOperationException("change");
    }

    @Override
    public void listenElements(ConfigurationNamedListListener<VIEWT> listener) {
        throw new UnsupportedOperationException("listenElements");
    }

    @Override
    public void stopListenElements(ConfigurationNamedListListener<VIEWT> listener) {
        throw new UnsupportedOperationException("stopListenElements");
    }

    @Override
    public T any() {
        throw new UnsupportedOperationException("any");
    }

    @Override
    public NamedConfigurationTree<T, VIEWT, CHANGET> directProxy() {
        return this;
    }
}

