/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.topology.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.network.ClusterNodeSerializer;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

public class LogicalNodeSerializer
extends VersionedSerializer<LogicalNode> {
    public static final LogicalNodeSerializer INSTANCE = new LogicalNodeSerializer();
    private final ClusterNodeSerializer clusterNodeSerializer = ClusterNodeSerializer.INSTANCE;

    @Override
    protected void writeExternalData(LogicalNode node, IgniteDataOutput out) throws IOException {
        this.clusterNodeSerializer.writeExternal(node, out);
        LogicalNodeSerializer.writeStringToStringMap(node.userAttributes(), out);
        LogicalNodeSerializer.writeStringToStringMap(node.systemAttributes(), out);
        out.writeVarInt(node.storageProfiles().size());
        for (String profile : node.storageProfiles()) {
            out.writeUTF(profile);
        }
    }

    private static void writeStringToStringMap(Map<String, String> map, IgniteDataOutput output) throws IOException {
        output.writeVarInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            output.writeUTF(entry.getKey());
            output.writeUTF(entry.getValue());
        }
    }

    @Override
    protected LogicalNode readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        InternalClusterNode node = (InternalClusterNode)this.clusterNodeSerializer.readExternal(in);
        Map<String, String> userAttributes = LogicalNodeSerializer.readStringToStringMap(in);
        Map<String, String> systemAttributes = LogicalNodeSerializer.readStringToStringMap(in);
        List<String> storageProfiles = LogicalNodeSerializer.readStringList(in);
        return new LogicalNode(node, userAttributes, systemAttributes, storageProfiles);
    }

    private static Map<String, String> readStringToStringMap(IgniteDataInput in) throws IOException {
        int size = in.readVarIntAsInt();
        HashMap<String, String> map = new HashMap<String, String>(IgniteUtils.capacity(size));
        for (int i = 0; i < size; ++i) {
            map.put(in.readUTF(), in.readUTF());
        }
        return map;
    }

    private static List<String> readStringList(IgniteDataInput in) throws IOException {
        int size = in.readVarIntAsInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(in.readUTF());
        }
        return list;
    }
}

