/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.registry.impl;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.call.node.metric.NodeMetricSourceListCall;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.repl.SessionInfo;
import org.apache.ignite3.internal.cli.core.repl.registry.MetricRegistry;
import org.apache.ignite3.internal.cli.core.repl.registry.impl.LazyObjectRef;
import org.apache.ignite3.internal.cli.event.ConnectionEventListener;
import org.apache.ignite3.rest.client.model.MetricSource;
import org.jetbrains.annotations.Nullable;

@Singleton
public class MetricRegistryImpl
implements MetricRegistry,
ConnectionEventListener {
    @Inject
    private NodeMetricSourceListCall metricSourceListCall;
    @Nullable
    private LazyObjectRef<Set<String>> metricSourcesRef;

    @Override
    public Set<String> metricSources() {
        Set<String> sources = this.metricSourcesRef == null ? null : this.metricSourcesRef.get();
        return sources == null ? Set.of() : sources;
    }

    @Override
    public void onConnect(SessionInfo sessionInfo) {
        this.metricSourcesRef = new LazyObjectRef<Set>(() -> this.fetchMetricSources(sessionInfo));
    }

    @Nullable
    private Set<String> fetchMetricSources(SessionInfo sessionInfo) {
        CallOutput<List<MetricSource>> output = this.metricSourceListCall.execute(new UrlCallInput(sessionInfo.nodeUrl()));
        if (output.hasError()) {
            return null;
        }
        return output.body().stream().map(MetricSource::getName).collect(Collectors.toSet());
    }

    @Override
    public void onDisconnect() {
        this.metricSourcesRef = null;
    }
}

