/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.call;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipelineBuilder;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.apache.ignite3.internal.cli.core.call.SingleCallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.decorator.Decorator;
import org.apache.ignite3.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite3.internal.cli.core.exception.handler.DefaultExceptionHandlers;

public class SingleCallExecutionPipelineBuilder<I extends CallInput, T>
implements CallExecutionPipelineBuilder<I, T> {
    private final Call<I, T> call;
    private ExceptionHandlers exceptionHandlers = new DefaultExceptionHandlers();
    private Supplier<I> inputProvider;
    private PrintWriter output = SingleCallExecutionPipelineBuilder.wrapOutputStream(System.out);
    private PrintWriter errOutput = SingleCallExecutionPipelineBuilder.wrapOutputStream(System.err);
    private Decorator<T, TerminalOutput> decorator;
    private boolean[] verbose = new boolean[0];

    SingleCallExecutionPipelineBuilder(Call<I, T> call) {
        this.call = call;
    }

    private static PrintWriter wrapOutputStream(OutputStream output) {
        return new PrintWriter(output, true, SingleCallExecutionPipelineBuilder.getStdoutEncoding());
    }

    private static Charset getStdoutEncoding() {
        String encoding = System.getProperty("sun.stdout.encoding");
        return encoding != null ? Charset.forName(encoding) : Charset.defaultCharset();
    }

    public SingleCallExecutionPipelineBuilder<I, T> inputProvider(Supplier<I> inputProvider) {
        this.inputProvider = inputProvider;
        return this;
    }

    @Override
    public SingleCallExecutionPipelineBuilder<I, T> output(PrintWriter output) {
        this.output = output;
        return this;
    }

    public SingleCallExecutionPipelineBuilder<I, T> output(OutputStream output) {
        return this.output(SingleCallExecutionPipelineBuilder.wrapOutputStream(output));
    }

    @Override
    public SingleCallExecutionPipelineBuilder<I, T> errOutput(PrintWriter errOutput) {
        this.errOutput = errOutput;
        return this;
    }

    public SingleCallExecutionPipelineBuilder<I, T> errOutput(OutputStream output) {
        return this.errOutput(SingleCallExecutionPipelineBuilder.wrapOutputStream(output));
    }

    public SingleCallExecutionPipelineBuilder<I, T> exceptionHandler(ExceptionHandler<?> exceptionHandler) {
        this.exceptionHandlers.addExceptionHandler(exceptionHandler);
        return this;
    }

    public SingleCallExecutionPipelineBuilder<I, T> exceptionHandlers(ExceptionHandlers exceptionHandlers) {
        this.exceptionHandlers.addExceptionHandlers(exceptionHandlers);
        return this;
    }

    public SingleCallExecutionPipelineBuilder<I, T> defaultExceptionHandler(ExceptionHandlers defaultExceptionHandler) {
        defaultExceptionHandler.addExceptionHandlers(this.exceptionHandlers);
        this.exceptionHandlers = defaultExceptionHandler;
        return this;
    }

    public SingleCallExecutionPipelineBuilder<I, T> decorator(Decorator<T, TerminalOutput> decorator) {
        this.decorator = decorator;
        return this;
    }

    @Override
    public SingleCallExecutionPipelineBuilder<I, T> verbose(boolean[] verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public CallExecutionPipeline<I, T> build() {
        return new SingleCallExecutionPipeline<I, T>(this.call, this.output, this.errOutput, this.exceptionHandlers, this.decorator, this.inputProvider, this.verbose);
    }
}

