/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.sql;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.apache.ignite3.internal.cli.call.sql.SqlQueryCall;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.StringCallInput;
import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite3.internal.cli.core.exception.handler.SqlExceptionHandler;
import org.apache.ignite3.internal.cli.decorators.SqlQueryResultDecorator;
import org.apache.ignite3.internal.cli.sql.SqlManager;
import picocli.CommandLine;

@CommandLine.Command(name="sql", description={"Executes SQL query"})
public class SqlExecCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--jdbc-url"}, required=true, descriptionKey="ignite.jdbc-url", description={"JDBC url to ignite cluster. For example, 'jdbc:ignite:thin://127.0.0.1:10800'"})
    private String jdbc;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @CommandLine.ArgGroup(multiplicity="1")
    private ExecOptions execOptions;

    private static String extract(File file) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(file.toPath(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IgniteCliException("File [" + file.getAbsolutePath() + "] not found");
        }
    }

    @Override
    public Integer call() {
        Integer n;
        SqlManager sqlManager = new SqlManager(this.jdbc);
        try {
            String executeCommand = this.execOptions.file != null ? SqlExecCommand.extract(this.execOptions.file) : this.execOptions.command;
            n = this.runPipeline(CallExecutionPipeline.builder(new SqlQueryCall(sqlManager)).inputProvider(() -> new StringCallInput(executeCommand)).exceptionHandler(SqlExceptionHandler.INSTANCE).decorator(new SqlQueryResultDecorator(this.plain)));
        }
        catch (Throwable executeCommand) {
            try {
                try {
                    sqlManager.close();
                }
                catch (Throwable throwable) {
                    executeCommand.addSuppressed(throwable);
                }
                throw executeCommand;
            }
            catch (SQLException e) {
                ExceptionWriter exceptionWriter = ExceptionWriter.fromPrintWriter(this.spec.commandLine().getErr());
                return SqlExceptionHandler.INSTANCE.handle(exceptionWriter, e);
            }
        }
        sqlManager.close();
        return n;
    }

    private static class ExecOptions {
        @CommandLine.Parameters(index="0", description={"SQL query to execute"})
        private String command;
        @CommandLine.Option(names={"--file"}, description={"Path to file with SQL commands to execute"})
        private File file;

        private ExecOptions() {
        }
    }
}

