/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.storage.SetDefaultZoneEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;

public class SetDefaultZoneEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class SetDefaultZoneEntrySerializerV2
    implements CatalogObjectSerializer<SetDefaultZoneEntry> {
        SetDefaultZoneEntrySerializerV2() {
        }

        @Override
        public SetDefaultZoneEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int zoneId = input.readVarIntAsInt();
            return new SetDefaultZoneEntry(zoneId);
        }

        @Override
        public void writeTo(SetDefaultZoneEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(entry.zoneId());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class SetDefaultZoneEntrySerializerV1
    implements CatalogObjectSerializer<SetDefaultZoneEntry> {
        SetDefaultZoneEntrySerializerV1() {
        }

        @Override
        public SetDefaultZoneEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int zoneId = input.readVarIntAsInt();
            return new SetDefaultZoneEntry(zoneId);
        }

        @Override
        public void writeTo(SetDefaultZoneEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(entry.zoneId());
        }
    }
}

