/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class ObjectIdGenUpdateEntry
implements UpdateEntry {
    private final int delta;

    public ObjectIdGenUpdateEntry(int delta) {
        this.delta = delta;
    }

    public int delta() {
        return this.delta;
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState() + this.delta, catalog.zones(), catalog.schemas(), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.ID_GENERATOR.id();
    }

    public String toString() {
        return S.toString(this);
    }
}

