/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;

public class NewIndexEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class NewIndexEntrySerializerV2
    implements CatalogObjectSerializer<NewIndexEntry> {
        NewIndexEntrySerializerV2() {
        }

        @Override
        public NewIndexEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogIndexDescriptor descriptor = input.readEntry(CatalogIndexDescriptor.class);
            return new NewIndexEntry(descriptor);
        }

        @Override
        public void writeTo(NewIndexEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeEntry(entry.descriptor());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class NewIndexEntrySerializerV1
    implements CatalogObjectSerializer<NewIndexEntry> {
        private final CatalogSerializationUtils.IndexDescriptorSerializerHelper serializerHelper;

        NewIndexEntrySerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializerHelper = new CatalogSerializationUtils.IndexDescriptorSerializerHelper(serializers);
        }

        @Override
        public NewIndexEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogIndexDescriptor descriptor = this.serializerHelper.readFrom(input);
            return new NewIndexEntry(descriptor);
        }

        @Override
        public void writeTo(NewIndexEntry entry, CatalogObjectDataOutput output) throws IOException {
            this.serializerHelper.writeTo(entry.descriptor(), output);
        }
    }
}

