/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.util.BitSet;
import java.util.List;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.client.table.MutableTupleBinaryTupleAdapter;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaAware;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.sql.ColumnType;
import org.apache.ignite3.table.Tuple;
import org.jetbrains.annotations.Nullable;

class ClientHandlerTuple
extends MutableTupleBinaryTupleAdapter
implements SchemaAware {
    private final SchemaDescriptor schema;
    private final boolean keyOnly;

    ClientHandlerTuple(SchemaDescriptor schema, @Nullable BitSet noValueSet, BinaryTupleReader tuple, boolean keyOnly) {
        super(tuple, tuple.elementCount(), noValueSet);
        assert (tuple.elementCount() == (keyOnly ? schema.keyColumns().size() : schema.length())) : "Tuple element count mismatch";
        this.schema = schema;
        this.keyOnly = keyOnly;
    }

    @Override
    @Nullable
    public SchemaDescriptor schema() {
        return this.binaryTuple() != null ? this.schema : null;
    }

    @Override
    public Tuple set(String columnName, @Nullable Object value) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    protected String schemaColumnName(int binaryTupleIndex) {
        return this.schema.column(binaryTupleIndex).name();
    }

    @Override
    protected int binaryTupleIndex(String columnName) {
        Column column = this.schema.column(IgniteNameUtils.parseIdentifier(columnName));
        if (column == null) {
            return -1;
        }
        if (this.keyOnly) {
            return column.positionInKey();
        }
        return column.positionInRow();
    }

    @Override
    protected int binaryTupleIndex(int publicIndex) {
        return this.keyOnly ? this.schema.keyColumns().get(publicIndex).positionInRow() : super.binaryTupleIndex(publicIndex);
    }

    @Override
    protected int publicIndex(int binaryTupleIndex) {
        if (this.keyOnly) {
            Column col = this.schema.keyColumns().get(binaryTupleIndex);
            return col.positionInKey();
        }
        return super.publicIndex(binaryTupleIndex);
    }

    @Override
    protected ColumnType schemaColumnType(int binaryTupleIndex) {
        return this.column(binaryTupleIndex).type().spec();
    }

    @Override
    protected int schemaDecimalScale(int binaryTupleIndex) {
        return ClientTableCommon.getDecimalScale(this.column(binaryTupleIndex).type());
    }

    private Column column(int binaryTupleIndex) {
        List<Column> columns = this.keyOnly ? this.schema.keyColumns() : this.schema.columns();
        return columns.get(binaryTupleIndex);
    }
}

