/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler;

import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class ClientResource {
    private final Object obj;
    @Nullable
    private final Runnable releaseRunnable;

    public ClientResource(Object obj, @Nullable Runnable releaseRunnable) {
        this.obj = obj;
        this.releaseRunnable = releaseRunnable;
    }

    public <T> T get(Class<T> type) {
        if (!type.isInstance(this.obj)) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Incorrect resource type. Expected " + type.getName() + ", but got " + this.obj.getClass().getName());
        }
        return (T)this.obj;
    }

    public void release() {
        if (this.releaseRunnable != null) {
            this.releaseRunnable.run();
        }
    }
}

