/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.ConstantBytecodeExpression;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class InvokeDynamicBytecodeExpression
extends BytecodeExpression {
    private final Method bootstrapMethod;
    private final List<Object> bootstrapArgs;
    private final String methodName;
    private final ParameterizedType returnType;
    private final List<BytecodeExpression> parameters;
    private final List<ParameterizedType> parameterTypes;

    InvokeDynamicBytecodeExpression(Method bootstrapMethod, Collection<?> bootstrapArgs, String methodName, ParameterizedType returnType, Collection<? extends BytecodeExpression> parameters, Collection<ParameterizedType> parameterTypes) {
        super(returnType);
        this.bootstrapMethod = Objects.requireNonNull(bootstrapMethod, "bootstrapMethod is null");
        this.bootstrapArgs = List.copyOf(Objects.requireNonNull(bootstrapArgs, "bootstrapArgs is null"));
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.parameters = List.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.parameterTypes = List.copyOf(Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock block = new BytecodeBlock();
        for (BytecodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        return block.invokeDynamic(this.methodName, this.returnType, this.parameterTypes, this.bootstrapMethod, this.bootstrapArgs);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of();
    }

    @Override
    protected String formatOneLine() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.bootstrapMethod.getName());
        if (!this.bootstrapArgs.isEmpty()) {
            builder.append("(").append(this.bootstrapArgs.stream().map(ConstantBytecodeExpression::renderConstant).collect(Collectors.joining(", "))).append(")");
        }
        builder.append("]=>");
        builder.append(this.methodName).append("(").append(this.parameters.stream().map(BytecodeExpression::toString).collect(Collectors.joining(", "))).append(")");
        return builder.toString();
    }
}

