/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.ArrayOpCode;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.InstructionNode;
import java.util.List;
import java.util.Objects;

class GetElementBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final BytecodeExpression index;
    private final InstructionNode arrayLoadInstruction;

    GetElementBytecodeExpression(BytecodeExpression instance, BytecodeExpression index) {
        super(instance.getType().getArrayComponentType());
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.index = Objects.requireNonNull(index, "index is null");
        BytecodeUtils.checkArgument(index.getType().getPrimitiveType() == Integer.TYPE, "index must be int type, but is " + index.getType(), new Object[0]);
        this.arrayLoadInstruction = ArrayOpCode.getArrayOpCode(instance.getType().getArrayComponentType()).getLoad();
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(this.index).append(this.arrayLoadInstruction);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + "[" + this.index + "]";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.index);
    }
}

