/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.utils.pubsub;

import java.util.concurrent.Flow;
import org.apache.commons.lang3.mutable.MutableLong;

public class StreamerPublisher<T>
implements Flow.Publisher<T>,
Flow.Subscription,
AutoCloseable {
    private final MutableLong requested = new MutableLong(0L);
    private Flow.Subscriber<? super T> subscriber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        MutableLong mutableLong = this.requested;
        synchronized (mutableLong) {
            if (this.requested.getValue() == -1L || this.subscriber != null) {
                throw new IllegalStateException("Only one subscription is supported");
            }
        }
        this.subscriber = subscriber;
        subscriber.onSubscribe(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long n) {
        assert (n > 0L) : "Requested count must be positive";
        MutableLong mutableLong = this.requested;
        synchronized (mutableLong) {
            this.requested.add(n);
            this.requested.notifyAll();
        }
    }

    @Override
    public void cancel() {
        this.setCancelledStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(T item) throws InterruptedException {
        MutableLong mutableLong = this.requested;
        synchronized (mutableLong) {
            while (this.requested.getValue() <= 0L) {
                if (this.requested.getValue() <= -1L) {
                    return false;
                }
                if (this.requested.getValue() != 0L) continue;
                this.requested.wait();
            }
            this.requested.decrementAndGet();
        }
        this.subscriber.onNext(item);
        return true;
    }

    public void closeExceptionally(Throwable error) {
        if (this.subscriber == null) {
            throw new IllegalStateException("Subscriber already closed");
        }
        this.subscriber.onError(error);
        this.subscriber = null;
        this.setCancelledStatus();
    }

    @Override
    public void close() {
        if (this.subscriber != null) {
            this.subscriber.onComplete();
            this.subscriber = null;
            this.setCancelledStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCancelledStatus() {
        MutableLong mutableLong = this.requested;
        synchronized (mutableLong) {
            this.requested.setValue(-1L);
            this.requested.notifyAll();
        }
    }
}

