/*
 * Copyright 2012 Splunk, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"): you may
 * not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.splunk;

/**
 * The {@code SavedSearchCollectionArgs} class contains arguments getting a 
 * collection of saved searches.
 */
public class SavedSearchCollectionArgs extends CollectionArgs {

    /**
     * Class constructor.
     */
    public SavedSearchCollectionArgs() { super(); }
    
    /* BEGIN AUTOGENERATED CODE */
    
    /**
     * Sets the earliest time for which to display the scheduled times for scheduled searches (not just the next run time).
     * 
     * @param earliestTime
     *      The earliest time.
     */
    public void setEarliestTime(String earliestTime) {
        this.put("earliest_time", earliestTime);
    }
    
    /**
     * Sets the latest time until which to display the scheduled times for scheduled searches (not just the next run time). 
     * 
     * @param latestTime
     *      The latest time.
     */
    public void setLatestTime(String latestTime) {
        this.put("latest_time", latestTime);
    }
    
    /* END AUTOGENERATED CODE */
}
