/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hcatalog;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.hcatalog.HCatalogBeamSchema;
import org.apache.beam.sdk.io.hcatalog.HCatalogIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class HCatToRow {
    private static @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized HCatRecord>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> forSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return ParDo.of((DoFn)new HCatToRowFn(schema));
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> fromSpec(final @UnknownKeyFor @NonNull @Initialized HCatalogIO.Read readSpec) {
        return new PTransform<PBegin, PCollection<Row>>(){

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
                HCatalogBeamSchema hcatSchema = HCatalogBeamSchema.create(readSpec.getConfigProperties());
                Schema schema = (Schema)hcatSchema.getTableSchema(readSpec.getDatabase(), readSpec.getTable()).get();
                return ((PCollection)((PCollection)input.apply("ReadHCatRecords", (PTransform)readSpec)).apply("ConvertToRows", HCatToRow.forSchema(schema))).setRowSchema(schema);
            }
        };
    }

    private static class HCatToRowFn
    extends DoFn<HCatRecord, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;

        private @UnknownKeyFor @NonNull @Initialized Object maybeCastHDate(@UnknownKeyFor @NonNull @Initialized Object obj) {
            if (obj instanceof Date) {
                return new Instant(((Date)obj).toEpochMilli());
            }
            return obj;
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> castTypes(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> values) {
            return values.stream().map(this::maybeCastHDate).collect(Collectors.toList());
        }

        HCatToRowFn(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.schema = schema;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            HCatRecord hCatRecord = (HCatRecord)c.element();
            c.output((Object)Row.withSchema((Schema)this.schema).addValues(this.castTypes(hCatRecord.getAll())).build());
        }
    }
}

