/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.configuration.tabs;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.plugin.ConfigPluginType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.tab.GuiTab;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.util.TranslateUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class ConfigPluginOptionsTab {
    public static final String GUI_WIDGETS_PARENT_ID = "EnterOptionsDialog-GuiWidgetsParent";
    private org.eclipse.swt.widgets.List wPluginsList;
    private Composite wPluginComposite;

    @GuiTab(id="10200-config-perspective-plugins-options-tab", parentId="ConfigurationPerspective.Tabs.ID", description="Plugins options tab")
    public void addPluginOptionsTab(CTabFolder wTabFolder) {
        Shell shell = wTabFolder.getShell();
        int margin = PropsUi.getMargin();
        CTabItem wPluginsTab = new CTabItem(wTabFolder, 0);
        wPluginsTab.setFont(GuiResource.getInstance().getFontDefault());
        wPluginsTab.setText("Plugins");
        wPluginsTab.setImage(GuiResource.getInstance().getImagePlugin());
        Composite wPluginsTabComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wPluginsTabComp);
        FormLayout lookLayout = new FormLayout();
        lookLayout.marginWidth = PropsUi.getFormMargin();
        lookLayout.marginHeight = PropsUi.getFormMargin();
        wPluginsTabComp.setLayout((Layout)lookLayout);
        this.wPluginsList = new org.eclipse.swt.widgets.List(wPluginsTabComp, 18436);
        PropsUi.setLook((Widget)this.wPluginsList);
        FormData fdPluginsList = new FormData();
        fdPluginsList.left = new FormAttachment(0, 0);
        fdPluginsList.right = new FormAttachment(20, 0);
        fdPluginsList.top = new FormAttachment(0, 0);
        fdPluginsList.bottom = new FormAttachment(100, 0);
        this.wPluginsList.setLayoutData((Object)fdPluginsList);
        this.wPluginComposite = new Composite(wPluginsTabComp, 264192);
        PropsUi.setLook((Widget)this.wPluginComposite);
        FormData fdPluginComposite = new FormData();
        fdPluginComposite.left = new FormAttachment((Control)this.wPluginsList, margin);
        fdPluginComposite.right = new FormAttachment(100, 0);
        fdPluginComposite.top = new FormAttachment(0, 0);
        fdPluginComposite.bottom = new FormAttachment(100, 0);
        this.wPluginComposite.setLayoutData((Object)fdPluginComposite);
        this.wPluginComposite.setLayout((Layout)new FormLayout());
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        List configPlugins = pluginRegistry.getPlugins(ConfigPluginType.class);
        for (IPlugin configPlugin : configPlugins) {
            try {
                Object emptySourceData = pluginRegistry.loadClass(configPlugin);
                GuiPlugin annotation = emptySourceData.getClass().getAnnotation(GuiPlugin.class);
                if (annotation == null) continue;
                Method method = emptySourceData.getClass().getMethod("getInstance", new Class[0]);
                Object sourceData = method.invoke(null, (Object[])null);
                String name = Const.NVL((String)TranslateUtil.translate((String)annotation.description(), emptySourceData.getClass()), (String)"");
                this.wPluginsList.add(name);
                this.wPluginsList.setData(name, sourceData);
                this.wPluginsList.addListener(13, e -> this.showConfigPluginSettings());
            }
            catch (Exception e2) {
                new ErrorDialog(shell, "Error", "Error handling configuration options for config / GUI plugin " + configPlugin.getIds()[0], e2);
            }
        }
        this.wPluginsList.select(new int[0]);
        FormData fdPluginsTabComp = new FormData();
        fdPluginsTabComp.left = new FormAttachment(0, 0);
        fdPluginsTabComp.right = new FormAttachment(100, 0);
        fdPluginsTabComp.top = new FormAttachment(0, 0);
        fdPluginsTabComp.bottom = new FormAttachment(100, 100);
        wPluginsTabComp.setLayoutData((Object)fdPluginsTabComp);
        wPluginsTab.setControl((Control)wPluginsTabComp);
    }

    private void showConfigPluginSettings() {
        int index = this.wPluginsList.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String name = this.wPluginsList.getSelection()[0];
        Object pluginSourceData = this.wPluginsList.getData(name);
        for (Control child : this.wPluginComposite.getChildren()) {
            child.dispose();
        }
        ScrolledComposite sPluginsComp = new ScrolledComposite(this.wPluginComposite, 768);
        sPluginsComp.setLayout((Layout)new FormLayout());
        FormData fdsPluginsComp = new FormData();
        fdsPluginsComp.left = new FormAttachment(0, 0);
        fdsPluginsComp.right = new FormAttachment(100, 0);
        fdsPluginsComp.top = new FormAttachment(0, 0);
        fdsPluginsComp.bottom = new FormAttachment(100, 0);
        sPluginsComp.setLayoutData((Object)fdsPluginsComp);
        Composite wPluginsComp = new Composite((Composite)sPluginsComp, 0);
        PropsUi.setLook((Widget)wPluginsComp);
        wPluginsComp.setLayout((Layout)new FormLayout());
        this.wPluginComposite.layout();
        GuiCompositeWidgets compositeWidgets = new GuiCompositeWidgets(HopGui.getInstance().getVariables());
        compositeWidgets.createCompositeWidgets(pluginSourceData, null, wPluginsComp, GUI_WIDGETS_PARENT_ID, null);
        compositeWidgets.setWidgetsContents(pluginSourceData, wPluginsComp, GUI_WIDGETS_PARENT_ID);
        if (pluginSourceData instanceof IGuiPluginCompositeWidgetsListener) {
            IGuiPluginCompositeWidgetsListener iGuiPluginCompositeWidgetsListener = (IGuiPluginCompositeWidgetsListener)pluginSourceData;
            compositeWidgets.setWidgetsListener(iGuiPluginCompositeWidgetsListener);
        }
        wPluginsComp.layout();
        wPluginsComp.pack();
        Rectangle bounds = wPluginsComp.getBounds();
        sPluginsComp.setContent((Control)wPluginsComp);
        sPluginsComp.setExpandHorizontal(true);
        sPluginsComp.setExpandVertical(true);
        sPluginsComp.setMinWidth(bounds.width);
        sPluginsComp.setMinHeight(bounds.height);
        this.wPluginComposite.layout(true, true);
    }
}

