/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.database.dialog;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.database.Catalog;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaInformation;
import org.apache.hop.core.database.Schema;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.GetDatabaseInfoProgressDialog;
import org.apache.hop.ui.core.database.dialog.GetPreviewTableProgressDialog;
import org.apache.hop.ui.core.database.dialog.GetTableSizeProgressDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.dialog.TransformFieldsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class DatabaseExplorerDialog
extends Dialog {
    private static final Class<?> PKG = DatabaseExplorerDialog.class;
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "DatabaseExplorerDialog-Toolbar";
    public static final String TOOLBAR_ITEM_EXPAND_ALL = "DatabaseExplorer-ToolBar-10100-ExpandAll";
    public static final String TOOLBAR_ITEM_COLLAPSE_ALL = "DatabaseExplorer-ToolBar-10200-CollapseAll";
    public static final String CONST_DATABASE_EXPLORER_DIALOG_MENU_PREVIEW_100 = "DatabaseExplorerDialog.Menu.Preview100";
    public static final String CONST_DATABASE_EXPLORER_DIALOG_MENU_PREVIEW_N = "DatabaseExplorerDialog.Menu.PreviewN";
    public static final String CONST_DATABASE_EXPLORER_DIALOG_MENU_SHOW_SIZE = "DatabaseExplorerDialog.Menu.ShowSize";
    public static final String CONST_DATABASE_EXPLORER_DIALOG_MENU_SHOW_LAYOUT = "DatabaseExplorerDialog.Menu.ShowLayout";
    public static final String CONST_DATABASE_EXPLORER_DIALOG_MENU_OPEN_SQL = "DatabaseExplorerDialog.Menu.OpenSQL";
    public static final String CONST_DATABASE_EXPLORER_DIALOG_MENU_GEN_DDL = "DatabaseExplorerDialog.Menu.GenDDL";
    public static final String CONST_DATABASE_EXPLORER_DIALOG_MENU_GEN_DDLOTHER_CONN = "DatabaseExplorerDialog.Menu.GenDDLOtherConn";
    private final ILogChannel log;
    private final PropsUi props;
    private DatabaseMeta dbMeta;
    private final IVariables variables;
    private final DbCache dbcache;
    private final ILoggingObject loggingObject;
    private static final String STRING_CATALOG = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Catalogs.Label", (String[])new String[0]);
    private static final String STRING_SCHEMAS = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Schemas.Label", (String[])new String[0]);
    private static final String STRING_TABLES = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Tables.Label", (String[])new String[0]);
    private static final String STRING_VIEWS = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Views.Label", (String[])new String[0]);
    private static final String STRING_SYNONYMS = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Synonyms.Label", (String[])new String[0]);
    private final Shell parent;
    private Shell shell;
    private Tree wTree;
    private TreeItem tiTree;
    private String tableName;
    private final boolean justLook;
    private String selectedSchema;
    private String selectedTable;
    private final List<DatabaseMeta> databases;
    private boolean splitSchemaAndTable;
    private String schemaName;
    private Composite buttonsComposite;
    private Button bPrev;
    private Button bPrevN;
    private Button bCount;
    private Button bShow;
    private Button bDDL;
    private Button bDDL2;
    private Button bSql;
    private String activeSchemaTable;
    private Button bTruncate;
    private ToolBar toolBar;

    public DatabaseExplorerDialog(Shell parent, int style, IVariables variables, DatabaseMeta conn, List<DatabaseMeta> databases) {
        this(parent, style, variables, conn, databases, false, true);
    }

    public DatabaseExplorerDialog(Shell parent, int style, IVariables variables, DatabaseMeta conn, List<DatabaseMeta> databases, boolean look, boolean splitSchemaAndTable) {
        super(parent, style);
        this.parent = parent;
        this.dbMeta = conn;
        this.variables = variables;
        this.databases = databases;
        this.justLook = look;
        this.splitSchemaAndTable = splitSchemaAndTable;
        this.loggingObject = new LoggingObject((Object)"Database Explorer");
        this.selectedSchema = null;
        this.selectedTable = null;
        this.props = PropsUi.getInstance();
        this.log = new LogChannel((Object)"DBExplorer");
        this.dbcache = DbCache.getInstance();
    }

    public void setSelectedTable(String selectedTable) {
        this.selectedTable = selectedTable;
    }

    public boolean open() {
        this.tableName = null;
        this.shell = Const.isLinux() ? new Shell(this.parent, 68848) : new Shell(this.parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageDatabase());
        this.shell.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Title", (String[])new String[]{this.dbMeta.toString()}));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        int margin = PropsUi.getMargin();
        ArrayList<Button> buttons = new ArrayList<Button>();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        buttons.add(wOk);
        Button wRefresh = new Button((Composite)this.shell, 8);
        wRefresh.setText(BaseMessages.getString(PKG, (String)"System.Button.Refresh", (String[])new String[0]));
        wRefresh.addListener(13, e -> this.getData());
        buttons.add(wRefresh);
        if (!this.justLook) {
            Button wCancel = new Button((Composite)this.shell, 8);
            wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            wCancel.addListener(13, e -> this.cancel());
            buttons.add(wCancel);
        }
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons.toArray(new Button[0]), margin, null);
        this.toolBar = new ToolBar((Composite)this.shell, 16704);
        GuiToolbarWidgets toolBarWidgets = new GuiToolbarWidgets();
        toolBarWidgets.registerGuiPluginObject((Object)this);
        toolBarWidgets.createToolbarWidgets((Composite)this.toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 0);
        layoutData.left = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        this.toolBar.setLayoutData((Object)layoutData);
        this.toolBar.pack();
        PropsUi.setLook((Widget)this.toolBar, 5);
        this.addRightButtons();
        this.refreshButtons(null);
        this.wTree = new Tree((Composite)this.shell, 2052);
        PropsUi.setLook((Widget)this.wTree);
        FormData fdTree = new FormData();
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment((Control)this.toolBar, margin);
        fdTree.right = new FormAttachment((Control)this.buttonsComposite, -margin);
        fdTree.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wTree.setLayoutData((Object)fdTree);
        if (!this.getData()) {
            return false;
        }
        this.wTree.addListener(13, e -> this.refreshButtons(this.getSchemaTable()));
        this.wTree.addListener(14, this::openSchema);
        this.wTree.addListener(3, e -> {
            if (e.button == 3) {
                this.setTreeMenu();
            }
        });
        this.shell.addListener(21, e -> this.cancel());
        BaseTransformDialog.setSize(this.shell);
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.tableName != null;
    }

    private void cancel() {
        this.log.logBasic("SelectTableDialog", new Object[]{"CANCEL SelectTableDialog", null});
        this.dbMeta = null;
        this.dispose();
    }

    private void addRightButtons() {
        this.buttonsComposite = new Composite((Composite)this.shell, 0);
        PropsUi.setLook((Widget)this.buttonsComposite);
        this.buttonsComposite.setLayout((Layout)new FormLayout());
        this.activeSchemaTable = null;
        this.bPrev = new Button(this.buttonsComposite, 8);
        this.bPrev.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_PREVIEW_100, (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bPrev.setEnabled(this.activeSchemaTable != null);
        this.bPrev.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialog.this.previewTable(DatabaseExplorerDialog.this.activeSchemaTable, false);
            }
        });
        FormData prevData = new FormData();
        prevData.left = new FormAttachment(0, 0);
        prevData.right = new FormAttachment(100, 0);
        prevData.top = new FormAttachment(0, 0);
        this.bPrev.setLayoutData((Object)prevData);
        this.bPrevN = new Button(this.buttonsComposite, 8);
        this.bPrevN.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_PREVIEW_N, (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bPrevN.setEnabled(this.activeSchemaTable != null);
        this.bPrevN.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialog.this.previewTable(DatabaseExplorerDialog.this.activeSchemaTable, true);
            }
        });
        FormData prevNData = new FormData();
        prevNData.left = new FormAttachment(0, 0);
        prevNData.right = new FormAttachment(100, 0);
        prevNData.top = new FormAttachment((Control)this.bPrev, PropsUi.getMargin());
        this.bPrevN.setLayoutData((Object)prevNData);
        this.bCount = new Button(this.buttonsComposite, 8);
        this.bCount.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_SHOW_SIZE, (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bCount.setEnabled(this.activeSchemaTable != null);
        this.bCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialog.this.showCount(DatabaseExplorerDialog.this.activeSchemaTable);
            }
        });
        FormData countData = new FormData();
        countData.left = new FormAttachment(0, 0);
        countData.right = new FormAttachment(100, 0);
        countData.top = new FormAttachment((Control)this.bPrevN, PropsUi.getMargin());
        this.bCount.setLayoutData((Object)countData);
        this.bShow = new Button(this.buttonsComposite, 8);
        this.bShow.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_SHOW_LAYOUT, (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bShow.setEnabled(this.activeSchemaTable != null);
        this.bShow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialog.this.showTable(DatabaseExplorerDialog.this.activeSchemaTable);
            }
        });
        FormData showData = new FormData();
        showData.left = new FormAttachment(0, 0);
        showData.right = new FormAttachment(100, 0);
        showData.top = new FormAttachment((Control)this.bCount, PropsUi.getMargin() * 7);
        this.bShow.setLayoutData((Object)showData);
        this.bDDL = new Button(this.buttonsComposite, 8);
        this.bDDL.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_GEN_DDL, (String[])new String[0]));
        this.bDDL.setEnabled(this.activeSchemaTable != null);
        this.bDDL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialog.this.getDDL(DatabaseExplorerDialog.this.activeSchemaTable);
            }
        });
        FormData ddlData = new FormData();
        ddlData.left = new FormAttachment(0, 0);
        ddlData.right = new FormAttachment(100, 0);
        ddlData.top = new FormAttachment((Control)this.bShow, PropsUi.getMargin());
        this.bDDL.setLayoutData((Object)ddlData);
        this.bDDL2 = new Button(this.buttonsComposite, 8);
        this.bDDL2.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_GEN_DDLOTHER_CONN, (String[])new String[0]));
        this.bDDL2.setEnabled(this.activeSchemaTable != null);
        this.bDDL2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialog.this.getDDLForOther(DatabaseExplorerDialog.this.activeSchemaTable);
            }
        });
        this.bDDL2.setEnabled(this.databases != null);
        FormData ddl2Data = new FormData();
        ddl2Data.left = new FormAttachment(0, 0);
        ddl2Data.right = new FormAttachment(100, 0);
        ddl2Data.top = new FormAttachment((Control)this.bDDL, PropsUi.getMargin());
        this.bDDL2.setLayoutData((Object)ddl2Data);
        this.bSql = new Button(this.buttonsComposite, 8);
        this.bSql.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_OPEN_SQL, (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bSql.setEnabled(this.activeSchemaTable != null);
        this.bSql.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialog.this.getSql(DatabaseExplorerDialog.this.activeSchemaTable);
            }
        });
        FormData sqlData = new FormData();
        sqlData.left = new FormAttachment(0, 0);
        sqlData.right = new FormAttachment(100, 0);
        sqlData.top = new FormAttachment((Control)this.bDDL2, PropsUi.getMargin());
        this.bSql.setLayoutData((Object)sqlData);
        this.bTruncate = new Button(this.buttonsComposite, 8);
        this.bTruncate.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.Truncate", (String[])new String[]{Const.NVL((String)this.activeSchemaTable, (String)"?")}));
        this.bTruncate.setEnabled(this.activeSchemaTable != null);
        this.bTruncate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseExplorerDialog.this.getTruncate(DatabaseExplorerDialog.this.activeSchemaTable);
            }
        });
        FormData truncateData = new FormData();
        truncateData.left = new FormAttachment(0, 0);
        truncateData.right = new FormAttachment(100, 0);
        truncateData.top = new FormAttachment((Control)this.bSql, PropsUi.getMargin() * 7);
        this.bTruncate.setLayoutData((Object)truncateData);
        FormData fdComposite = new FormData();
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, this.toolBar.getBounds().height);
        this.buttonsComposite.setLayoutData((Object)fdComposite);
    }

    @GuiToolbarElement(root="DatabaseExplorerDialog-Toolbar", id="DatabaseExplorer-ToolBar-10100-ExpandAll", toolTip="i18n::DatabaseExplorerDialog.Toolbar.ExpandAll.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/expand-all.svg")
    public void expandAll() {
        this.expandAllItems(this.wTree.getItems(), true);
    }

    @GuiToolbarElement(root="DatabaseExplorerDialog-Toolbar", id="DatabaseExplorer-ToolBar-10200-CollapseAll", toolTip="i18n::DatabaseExplorerDialog.Toolbar.CollapseAll.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/collapse-all.svg")
    public void collapseAll() {
        this.expandAllItems(this.wTree.getItems(), false);
    }

    private void expandAllItems(TreeItem[] treeitems, boolean expand) {
        for (TreeItem item : treeitems) {
            item.setExpanded(expand);
            if (item.getItemCount() <= 0) continue;
            this.expandAllItems(item.getItems(), expand);
        }
    }

    private void refreshButtons(String table) {
        this.activeSchemaTable = table;
        this.bPrev.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_PREVIEW_100, (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bPrev.setEnabled(table != null);
        this.bPrevN.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_PREVIEW_N, (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bPrevN.setEnabled(table != null);
        this.bCount.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_SHOW_SIZE, (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bCount.setEnabled(table != null);
        this.bShow.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_SHOW_LAYOUT, (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bShow.setEnabled(table != null);
        this.bDDL.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_GEN_DDL, (String[])new String[0]));
        this.bDDL.setEnabled(table != null);
        this.bDDL2.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_GEN_DDLOTHER_CONN, (String[])new String[0]));
        this.bDDL2.setEnabled(table != null);
        this.bSql.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_OPEN_SQL, (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bSql.setEnabled(table != null);
        this.bTruncate.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Menu.Truncate", (String[])new String[]{Const.NVL((String)table, (String)"?")}));
        this.bTruncate.setEnabled(table != null);
        this.shell.layout(true, true);
    }

    private boolean getData() {
        GetDatabaseInfoProgressDialog gdipd = new GetDatabaseInfoProgressDialog(this.shell, this.variables, this.dbMeta);
        DatabaseMetaInformation dmi = gdipd.open();
        if (dmi != null) {
            Schema[] schemas;
            if (this.tiTree != null && !this.tiTree.isDisposed()) {
                this.tiTree.dispose();
            }
            this.tiTree = new TreeItem(this.wTree, 0);
            this.tiTree.setImage(GuiResource.getInstance().getImageDatabase());
            this.tiTree.setText(this.dbMeta == null ? "" : this.dbMeta.getName());
            Catalog[] catalogs = dmi.getCatalogs();
            if (catalogs != null) {
                TreeItem tiCat = new TreeItem(this.tiTree, 0);
                tiCat.setImage(GuiResource.getInstance().getImageFolder());
                tiCat.setText(STRING_CATALOG);
                for (int i = 0; i < catalogs.length; ++i) {
                    TreeItem newCat = new TreeItem(tiCat, 0);
                    newCat.setImage(GuiResource.getInstance().getImageFolder());
                    newCat.setText(catalogs[i].getCatalogName());
                    for (int j = 0; j < catalogs[i].getItems().length; ++j) {
                        String tableName = catalogs[i].getItems()[j];
                        TreeItem ti = new TreeItem(newCat, 0);
                        ti.setImage(GuiResource.getInstance().getImageTable());
                        ti.setText(tableName);
                    }
                }
            }
            if ((schemas = dmi.getSchemas()) != null) {
                TreeItem tiSch = new TreeItem(this.tiTree, 0);
                tiSch.setImage(GuiResource.getInstance().getImageFolder());
                tiSch.setText(STRING_SCHEMAS);
                for (int i = 0; i < schemas.length; ++i) {
                    TreeItem newSch = new TreeItem(tiSch, 0);
                    newSch.setImage(GuiResource.getInstance().getImageSchema());
                    newSch.setText(schemas[i].getSchemaName());
                    for (int j = 0; j < schemas[i].getItems().length; ++j) {
                        String tableName = schemas[i].getItems()[j];
                        TreeItem ti = new TreeItem(newSch, 0);
                        ti.setImage(GuiResource.getInstance().getImageTable());
                        ti.setText(tableName);
                    }
                }
            }
            TreeItem tiTab = null;
            String[] tabnames = dmi.getTables();
            if (tabnames != null) {
                tiTab = new TreeItem(this.tiTree, 0);
                tiTab.setImage(GuiResource.getInstance().getImageFolder());
                tiTab.setText(STRING_TABLES);
                tiTab.setExpanded(true);
                for (int i = 0; i < tabnames.length; ++i) {
                    TreeItem newTab = new TreeItem(tiTab, 0);
                    newTab.setImage(GuiResource.getInstance().getImageTable());
                    newTab.setText(tabnames[i]);
                }
            }
            TreeItem tiView = null;
            String[] views = dmi.getViews();
            if (views != null) {
                tiView = new TreeItem(this.tiTree, 0);
                tiView.setImage(GuiResource.getInstance().getImageFolder());
                tiView.setText(STRING_VIEWS);
                for (int i = 0; i < views.length; ++i) {
                    TreeItem newView = new TreeItem(tiView, 0);
                    newView.setImage(GuiResource.getInstance().getImageView());
                    newView.setText(views[i]);
                }
            }
            TreeItem tiSyn = null;
            String[] syn = dmi.getSynonyms();
            if (syn != null) {
                tiSyn = new TreeItem(this.tiTree, 0);
                tiSyn.setImage(GuiResource.getInstance().getImageFolder());
                tiSyn.setText(STRING_SYNONYMS);
                for (int i = 0; i < syn.length; ++i) {
                    TreeItem newSyn = new TreeItem(tiSyn, 0);
                    newSyn.setImage(GuiResource.getInstance().getImageSynonym());
                    newSyn.setText(syn[i]);
                }
            }
            if (!StringUtils.isEmpty((String)this.selectedTable)) {
                TreeItem ti = null;
                if (ti == null && tiTab != null) {
                    ti = ConstUi.findTreeItem(tiTab, this.selectedSchema, this.selectedTable);
                }
                if (ti == null && tiView != null) {
                    ti = ConstUi.findTreeItem(tiView, this.selectedSchema, this.selectedTable);
                }
                if (ti == null && this.tiTree != null) {
                    ti = ConstUi.findTreeItem(this.tiTree, this.selectedSchema, this.selectedTable);
                }
                if (ti == null && tiSyn != null) {
                    ti = ConstUi.findTreeItem(tiSyn, this.selectedSchema, this.selectedTable);
                }
                if (ti != null) {
                    this.wTree.setSelection(new TreeItem[]{ti});
                    this.wTree.showSelection();
                    this.refreshButtons(this.dbMeta.getQuotedSchemaTableCombination(this.variables, this.selectedSchema, this.selectedTable));
                }
                this.selectedTable = null;
            }
        } else {
            return false;
        }
        this.tiTree.setExpanded(true);
        return true;
    }

    private String getSchemaTable() {
        TreeItem parent;
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1 && (parent = ti[0].getParentItem()) != null) {
            String schemaName = parent.getText();
            String tableName = ti[0].getText();
            if (ti[0].getItemCount() == 0) {
                String tab = null;
                tab = schemaName.equalsIgnoreCase(STRING_TABLES) || schemaName.equalsIgnoreCase(STRING_VIEWS) || schemaName.equalsIgnoreCase(STRING_SYNONYMS) || schemaName != null && schemaName.isEmpty() ? tableName : this.dbMeta.getQuotedSchemaTableCombination(this.variables, schemaName, tableName);
                return tab;
            }
        }
        return null;
    }

    public void setTreeMenu() {
        final String table = this.getSchemaTable();
        if (table != null) {
            Menu mTree = new Menu((Decorations)this.shell, 8);
            MenuItem miPrev = new MenuItem(mTree, 8);
            miPrev.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_PREVIEW_100, (String[])new String[]{table}));
            miPrev.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialog.this.previewTable(table, false);
                }
            });
            MenuItem miPrevN = new MenuItem(mTree, 8);
            miPrevN.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_PREVIEW_N, (String[])new String[]{table}));
            miPrevN.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialog.this.previewTable(table, true);
                }
            });
            MenuItem miCount = new MenuItem(mTree, 8);
            miCount.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_SHOW_SIZE, (String[])new String[]{table}));
            miCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialog.this.showCount(table);
                }
            });
            new MenuItem(mTree, 2);
            MenuItem miShow = new MenuItem(mTree, 8);
            miShow.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_SHOW_LAYOUT, (String[])new String[]{table}));
            miShow.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialog.this.showTable(table);
                }
            });
            MenuItem miDDL = new MenuItem(mTree, 8);
            miDDL.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_GEN_DDL, (String[])new String[0]));
            miDDL.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialog.this.getDDL(table);
                }
            });
            MenuItem miDDL2 = new MenuItem(mTree, 8);
            miDDL2.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_GEN_DDLOTHER_CONN, (String[])new String[0]));
            miDDL2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialog.this.getDDLForOther(table);
                }
            });
            miDDL2.setEnabled(this.databases != null);
            MenuItem miSql = new MenuItem(mTree, 8);
            miSql.setText(BaseMessages.getString(PKG, (String)CONST_DATABASE_EXPLORER_DIALOG_MENU_OPEN_SQL, (String[])new String[]{table}));
            miSql.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseExplorerDialog.this.getSql(table);
                }
            });
            this.wTree.setMenu(mTree);
        } else {
            this.wTree.setMenu(null);
        }
    }

    public void previewTable(String tableName, boolean asklimit) {
        String lineText;
        String shellText;
        EnterNumberDialog end;
        int samples;
        int limit = 100;
        if (asklimit && (samples = (end = new EnterNumberDialog(this.shell, limit, shellText = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.PreviewTable.Title", (String[])new String[0]), lineText = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.PreviewTable.Message", (String[])new String[0]))).open()) >= 0) {
            limit = samples;
        }
        String[] tableNameParts = tableName.split("\\.");
        GetPreviewTableProgressDialog pd = null;
        pd = this.schemaName == null && tableNameParts.length == 2 ? new GetPreviewTableProgressDialog(this.shell, this.variables, this.dbMeta, tableNameParts[0], tableNameParts[1], limit) : new GetPreviewTableProgressDialog(this.shell, this.variables, this.dbMeta, null, tableName, limit);
        List<Object[]> rows = pd.open();
        if (rows != null) {
            if (!rows.isEmpty()) {
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, tableName, pd.getRowMeta(), rows);
                prd.open();
            } else {
                MessageBox mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoRows.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoRows.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showTable(String tableName) {
        String sql = this.dbMeta.getSqlQueryFields(tableName);
        IRowMeta result = null;
        Database db = new Database(HopGui.getInstance().getLoggingObject(), this.variables, this.dbMeta);
        try {
            db.connect();
            result = db.getQueryFields(sql, false);
        }
        catch (Exception exception) {
        }
        finally {
            db.disconnect();
        }
        if (result != null) {
            TransformFieldsDialog sfd = new TransformFieldsDialog(this.shell, this.variables, 0, tableName, result);
            sfd.open();
        }
    }

    public void showCount(String tableName) {
        String realTableName = tableName.contains(".") ? tableName.substring(tableName.indexOf(".") + 1) : tableName;
        GetTableSizeProgressDialog pd = new GetTableSizeProgressDialog(this.shell, this.variables, this.dbMeta, realTableName);
        Long size = pd.open();
        if (size != null) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TableSize.Message", (String[])new String[]{tableName, size.toString()}));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TableSize.Title", (String[])new String[0]));
            mb.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDDL(String tableName) {
        Database db = new Database(this.loggingObject, this.variables, this.dbMeta);
        try {
            db.connect();
            IRowMeta r = db.getTableFields(tableName);
            String realTableName = tableName.contains(".") ? tableName.substring(tableName.indexOf(".") + 1) : tableName;
            String sql = db.getCreateTableStatement(realTableName, r, null, false, null, true);
            SqlEditor se = new SqlEditor(this.shell, 0, this.variables, this.dbMeta, this.dbcache, sql);
            se.open();
        }
        catch (HopDatabaseException dbe) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Dialog.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Error.RetrieveLayout", (String[])new String[0]), (Exception)((Object)dbe));
        }
        finally {
            db.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getDDLForOther(String tableName) {
        if (this.databases != null) {
            Database database = new Database(this.loggingObject, this.variables, this.dbMeta);
            try {
                database.connect();
                String realTableName = tableName.contains(".") ? tableName.substring(tableName.indexOf(".") + 1) : tableName;
                IRowMeta rowMeta = database.getTableFields(realTableName);
                ArrayList<DatabaseMeta> databaseMetaList = new ArrayList<DatabaseMeta>();
                for (int i = 0; i < this.databases.size(); ++i) {
                    databaseMetaList.add(this.databases.get(i));
                }
                String[] connectionNames = new String[databaseMetaList.size()];
                for (int i = 0; i < connectionNames.length; ++i) {
                    connectionNames[i] = ((DatabaseMeta)databaseMetaList.get(i)).getName();
                }
                EnterSelectionDialog enterSelectionDialog = new EnterSelectionDialog(this.shell, connectionNames, BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TargetDatabase.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TargetDatabase.Message", (String[])new String[0]));
                String target = enterSelectionDialog.open();
                if (target == null) return;
                DatabaseMeta targetDatabaseMeta = DatabaseMeta.findDatabase(databaseMetaList, (String)target);
                Database targetDatabase = new Database(this.loggingObject, this.variables, targetDatabaseMeta);
                String sql = targetDatabase.getCreateTableStatement(tableName, rowMeta, null, false, null, true);
                SqlEditor sqlEditor = new SqlEditor(this.shell, 0, this.variables, this.dbMeta, this.dbcache, sql);
                sqlEditor.open();
                return;
            }
            catch (HopDatabaseException dbe) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Dialog.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Error.GenDDL", (String[])new String[0]), (Exception)((Object)dbe));
                return;
            }
            finally {
                database.disconnect();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 2);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoConnectionsKnown.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoConnectionsKnown.Title", (String[])new String[0]));
            mb.open();
        }
    }

    public void getSql(String tableName) {
        String realTableName = tableName.contains(".") ? tableName.substring(tableName.indexOf(".") + 1) : tableName;
        SqlEditor sqlEditor = new SqlEditor(this.shell, 0, this.variables, this.dbMeta, this.dbcache, "SELECT * FROM " + realTableName);
        sqlEditor.open();
    }

    public void getTruncate(String activeSchemaTable) {
        SqlEditor sql = new SqlEditor(this.shell, 0, this.variables, this.dbMeta, this.dbcache, "-- TRUNCATE TABLE " + activeSchemaTable);
        sql.open();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void ok() {
        if (this.justLook) {
            this.dispose();
            return;
        }
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1) {
            String table = ti[0].getText();
            String[] path = ConstUi.getTreeStrings(ti[0]);
            if (path.length == 3 && (STRING_TABLES.equalsIgnoreCase(path[1]) || STRING_VIEWS.equalsIgnoreCase(path[1]) || STRING_SYNONYMS.equalsIgnoreCase(path[1]))) {
                this.schemaName = null;
                this.tableName = table;
                String[] st = this.tableName.split("\\.", 2);
                if (st.length > 1) {
                    this.schemaName = st[0];
                    this.tableName = st[1];
                }
                this.dispose();
            }
            if (path.length == 4 && (STRING_SCHEMAS.equals(path[1]) || STRING_CATALOG.equals(path[1]))) {
                if (this.splitSchemaAndTable) {
                    this.schemaName = path[2];
                    this.tableName = path[3];
                } else {
                    this.schemaName = null;
                    this.tableName = this.dbMeta.getQuotedSchemaTableCombination(this.variables, path[2], path[3]);
                }
                this.dispose();
            }
        }
    }

    public void openSchema(Event e) {
        TreeItem up3;
        TreeItem up2;
        TreeItem sel = (TreeItem)e.item;
        TreeItem up1 = sel.getParentItem();
        if (up1 != null && (up2 = up1.getParentItem()) != null && (up3 = up2.getParentItem()) != null) {
            this.tableName = sel.getText();
            if (!this.justLook) {
                this.ok();
            } else {
                this.previewTable(this.tableName, false);
            }
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isSplitSchemaAndTable() {
        return this.splitSchemaAndTable;
    }

    public void setSplitSchemaAndTable(boolean splitSchemaAndTable) {
        this.splitSchemaAndTable = splitSchemaAndTable;
    }

    public String getSelectedSchema() {
        return this.selectedSchema;
    }

    public void setSelectedSchema(String selectSchema) {
        this.selectedSchema = selectSchema;
    }

    public void setSelectedSchemaAndTable(String schemaName, String tableName) {
        this.selectedSchema = schemaName;
        this.selectedTable = tableName;
    }
}

