/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.internal;

import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DataflowGroupByKey<@UnknownKeyFor K, @UnknownKeyFor V>
extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final @UnknownKeyFor @NonNull @Initialized boolean allowDuplicates;

    private DataflowGroupByKey(@UnknownKeyFor @NonNull @Initialized boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized DataflowGroupByKey<K, V> create() {
        return new DataflowGroupByKey<K, V>(false);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized DataflowGroupByKey<K, V> createWithAllowDuplicates() {
        return new DataflowGroupByKey<K, V>(true);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean allowDuplicates() {
        return this.allowDuplicates;
    }

    public static void applicableTo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input) {
        WindowingStrategy windowingStrategy = input.getWindowingStrategy();
        if (windowingStrategy.getWindowFn() instanceof GlobalWindows && windowingStrategy.getTrigger() instanceof DefaultTrigger && input.isBounded() != PCollection.IsBounded.BOUNDED) {
            throw new IllegalStateException("DataflowGroupByKey cannot be applied to non-bounded PCollection in the GlobalWindow without a trigger. Use a Window.into or Window.triggering transform prior to DataflowGroupByKey.");
        }
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> updateWindowingStrategy(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> inputStrategy) {
        return inputStrategy.withAlreadyMerged(!inputStrategy.getWindowFn().isNonMerging()).withTrigger(inputStrategy.getTrigger().getContinuationTrigger());
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
        DataflowGroupByKey.applicableTo(input);
        Coder<K> keyCoder = DataflowGroupByKey.getKeyCoder(input.getCoder());
        try {
            keyCoder.verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            throw new IllegalStateException("the keyCoder of a DataflowGroupByKey must be deterministic", e);
        }
        return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), this.updateWindowingStrategy(input.getWindowingStrategy()), (PCollection.IsBounded)input.isBounded(), DataflowGroupByKey.getOutputKvCoder(input.getCoder()));
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized KvCoder<K, V> getInputKvCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputCoder) {
        if (!(inputCoder instanceof KvCoder)) {
            throw new IllegalStateException("DataflowGroupByKey requires its input to use KvCoder");
        }
        return (KvCoder)inputCoder;
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> inputCoder) {
        return DataflowGroupByKey.getInputKvCoder(inputCoder).getKeyCoder();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Coder<V> getInputValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> inputCoder) {
        return DataflowGroupByKey.getInputKvCoder(inputCoder).getValueCoder();
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<V>> getOutputValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> inputCoder) {
        return IterableCoder.of(DataflowGroupByKey.getInputValueCoder(inputCoder));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized KvCoder<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>> getOutputKvCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> inputCoder) {
        return KvCoder.of(DataflowGroupByKey.getKeyCoder(inputCoder), DataflowGroupByKey.getOutputValueCoder(inputCoder));
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(DataflowGroupByKey.class, new DataflowGroupByKeyTranslator());
        }
    }

    static class DataflowGroupByKeyTranslator
    implements PTransformTranslation.TransformPayloadTranslator<DataflowGroupByKey<?, ?>> {
        DataflowGroupByKeyTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:group_by_key:v1";
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized DataflowGroupByKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((DataflowGroupByKey)transform.getTransform())).build();
        }
    }
}

