/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

@GwtIncompatible
public final class LazyExecutorService
implements ExecutorService {
    private volatile boolean shutdown = false;
    private final ExecutorService backingService;
    private final CountDownLatch terminated = new CountDownLatch(1);
    private final Set<ExecutingFuture<?>> pendingTasks = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private final ReentrantLock tasksAndTerminationLock = new ReentrantLock();

    public LazyExecutorService() {
        this.backingService = MoreExecutors.newDirectExecutorService();
    }

    public LazyExecutorService(ExecutorService backingService) {
        this.backingService = backingService;
    }

    private void removePendingTask(ExecutingFutureImpl<?> f) {
        this.pendingTasks.remove(f);
        this.updateTerminationState();
    }

    private void updateTerminationState() {
        this.tasksAndTerminationLock.lock();
        try {
            if (this.shutdown && this.pendingTasks.isEmpty()) {
                this.terminated.countDown();
            }
        }
        finally {
            this.tasksAndTerminationLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        this.updateTerminationState();
    }

    @Override
    @CanIgnoreReturnValue
    public List<Runnable> shutdownNow() {
        Future[] runningTasks;
        this.shutdown();
        for (Future future : runningTasks = this.pendingTasks.toArray(new Future[0])) {
            future.cancel(true);
        }
        return Lists.newLinkedList();
    }

    @Override
    public boolean isShutdown() {
        this.checkBackingService();
        return this.shutdown;
    }

    private void checkBackingService() {
        if (this.backingService.isShutdown()) {
            ExecutingFuture[] runningTasks;
            this.shutdown();
            for (ExecutingFuture future : runningTasks = this.pendingTasks.toArray(new ExecutingFuture[0])) {
                future.backingServiceDied();
            }
        }
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && this.terminated.getCount() == 0L;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isTerminated()) {
            return true;
        }
        return this.terminated.await(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Preconditions.checkNotNull(task, (Object)"Null task submitted.");
        this.tasksAndTerminationLock.lock();
        try {
            if (this.isShutdown()) {
                throw new RejectedExecutionException("ExecutorService is shutdown");
            }
            ExecutingFutureImpl<T> future = new ExecutingFutureImpl<T>(task);
            this.pendingTasks.add(future);
            ExecutingFutureImpl<T> executingFutureImpl = future;
            return executingFutureImpl;
        }
        finally {
            this.tasksAndTerminationLock.unlock();
        }
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(Executors.callable(task, result));
    }

    @Override
    public Future<?> submit(Runnable command) {
        return this.submit(Executors.callable(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CanIgnoreReturnValue
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        LinkedList result = Lists.newLinkedList();
        try {
            for (Callable<T> task : tasks) {
                result.add(this.submit(task));
            }
            List<Callable<Void>> monitorTasks = LazyExecutorService.createMonitorTasksFor(result, 0L, null);
            this.backingService.invokeAll(monitorTasks);
        }
        finally {
            for (Future future : result) {
                future.cancel(true);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CanIgnoreReturnValue
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull((Object)((Object)unit));
        LinkedList result = Lists.newLinkedList();
        try {
            for (Callable<T> task : tasks) {
                result.add(this.submit(task));
            }
            List<Callable<Void>> monitorTasks = LazyExecutorService.createMonitorTasksFor(result, timeout, unit);
            this.backingService.invokeAll(monitorTasks, timeout, unit);
        }
        finally {
            for (Future future : result) {
                future.cancel(true);
            }
        }
        return result;
    }

    private static <T> List<Callable<Void>> createMonitorTasksFor(List<Future<T>> futures, long timeout, @Nullable TimeUnit unit) {
        LinkedList monitorTasks = Lists.newLinkedList();
        long deadline = unit == null ? 0L : System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit);
        for (Future<T> future : futures) {
            monitorTasks.add(new StartExecutionTask(future));
        }
        for (Future<T> future : futures) {
            monitorTasks.add(new CompletionCheckTask(future, deadline));
        }
        return monitorTasks;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new RejectedExecutionException("Use another ExecutorService implementation.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new RejectedExecutionException("Use another ExecutorService implementation.");
    }

    @Override
    public void execute(Runnable command) {
        throw new RejectedExecutionException("Use submit instead of execute.");
    }

    private class ExecutingFutureImpl<T>
    extends ForwardingFuture<T>
    implements ExecutingFuture<T> {
        private final AtomicReference<ExecutingFuture<T>> state;

        ExecutingFutureImpl(Callable<T> task) {
            this.state = new AtomicReference<Created>(new Created(task));
        }

        protected Future<T> delegate() {
            return this.state.get();
        }

        @Override
        public void backingServiceDied() {
            this.state.get().backingServiceDied();
        }

        private class InbetweenStates
        implements ExecutingFuture<T> {
            public final CountDownLatch latch = new CountDownLatch(1);

            private InbetweenStates() {
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
                long startWait = System.nanoTime();
                if (!this.latch.await(timeout, unit)) {
                    throw new TimeoutException();
                }
                long endWait = System.nanoTime();
                return ((ExecutingFuture)ExecutingFutureImpl.this.state.get()).get(timeout -= unit.convert(endWait - startWait, TimeUnit.NANOSECONDS), unit);
            }

            @Override
            public T get() throws ExecutionException, InterruptedException {
                this.latch.await();
                return ((ExecutingFuture)ExecutingFutureImpl.this.state.get()).get();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public void backingServiceDied() {
            }
        }

        private class Delegated
        implements ExecutingFuture<T> {
            private final Future<T> backingFuture;

            Delegated(Future<T> backingFuture) {
                this.backingFuture = backingFuture;
            }

            @Override
            public boolean isDone() {
                return this.backingFuture.isDone();
            }

            @Override
            public boolean isCancelled() {
                return this.backingFuture.isCancelled();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
                return this.backingFuture.get(timeout, unit);
            }

            @Override
            public T get() throws ExecutionException, InterruptedException {
                return this.backingFuture.get();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (!mayInterruptIfRunning) {
                    return false;
                }
                return this.backingFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public void backingServiceDied() {
            }
        }

        private class Cancelled
        implements ExecutingFuture<T> {
            private Cancelled() {
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public boolean isCancelled() {
                return true;
            }

            @Override
            public T get(long timeout, TimeUnit unit) {
                throw new CancellationException();
            }

            @Override
            public T get() {
                throw new CancellationException();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public void backingServiceDied() {
            }
        }

        private class Created
        implements ExecutingFuture<T> {
            private final Callable<T> task;

            Created(Callable<T> task) {
                this.task = task;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.transitionToCancelled()) {
                    return true;
                }
                return ((ExecutingFuture)ExecutingFutureImpl.this.state.get()).cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                this.transitionToDelegated();
                return ((ExecutingFuture)ExecutingFutureImpl.this.state.get()).isDone();
            }

            @Override
            public T get() throws ExecutionException, InterruptedException {
                this.transitionToDelegated();
                return ((ExecutingFuture)ExecutingFutureImpl.this.state.get()).get();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
                this.transitionToDelegated();
                return ((ExecutingFuture)ExecutingFutureImpl.this.state.get()).get(timeout, unit);
            }

            @Override
            public void backingServiceDied() {
                this.transitionToCancelled();
            }

            private void transitionToDelegated() {
                InbetweenStates transitionGuard = new InbetweenStates();
                if (ExecutingFutureImpl.this.state.compareAndSet(this, transitionGuard)) {
                    try {
                        Future backingFuture = LazyExecutorService.this.backingService.submit(new Callable<T>(){

                            @Override
                            public T call() throws Exception {
                                try {
                                    Object v = Created.this.task.call();
                                    return v;
                                }
                                finally {
                                    LazyExecutorService.this.removePendingTask(ExecutingFutureImpl.this);
                                }
                            }
                        });
                        ExecutingFutureImpl.this.state.set(new Delegated(backingFuture));
                    }
                    catch (RejectedExecutionException e) {
                        ExecutingFutureImpl.this.state.set(new Cancelled());
                        LazyExecutorService.this.removePendingTask(ExecutingFutureImpl.this);
                        LazyExecutorService.this.checkBackingService();
                    }
                    finally {
                        transitionGuard.latch.countDown();
                    }
                }
            }

            @CanIgnoreReturnValue
            private boolean transitionToCancelled() {
                if (ExecutingFutureImpl.this.state.compareAndSet(this, new Cancelled())) {
                    LazyExecutorService.this.removePendingTask(ExecutingFutureImpl.this);
                    return true;
                }
                return false;
            }
        }
    }

    private static interface ExecutingFuture<T>
    extends Future<T> {
        public void backingServiceDied();
    }

    private static class CompletionCheckTask
    implements Callable<Void> {
        private final Future<?> future;
        private final long deadline;

        CompletionCheckTask(Future<?> future, long deadline) {
            this.future = future;
            this.deadline = deadline;
        }

        @Override
        public Void call() {
            try {
                if (this.deadline == 0L) {
                    this.future.get();
                } else {
                    this.future.get(this.deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
                }
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.future.cancel(true);
            }
            catch (TimeoutException e) {
                this.future.cancel(true);
            }
            return null;
        }
    }

    private static class StartExecutionTask
    implements Callable<Void> {
        private final Future<?> future;

        StartExecutionTask(Future<?> future) {
            this.future = future;
        }

        @Override
        public Void call() {
            this.future.isDone();
            return null;
        }
    }
}

