/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.admin.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AppProfileName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_APP_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/appProfiles/{app_profile}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String appProfile;

    @Deprecated
    protected AppProfileName() {
        this.project = null;
        this.instance = null;
        this.appProfile = null;
    }

    private AppProfileName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.appProfile = (String)Preconditions.checkNotNull((Object)builder.getAppProfile());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getAppProfile() {
        return this.appProfile;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AppProfileName of(String project, String instance, String appProfile) {
        return AppProfileName.newBuilder().setProject(project).setInstance(instance).setAppProfile(appProfile).build();
    }

    public static String format(String project, String instance, String appProfile) {
        return AppProfileName.newBuilder().setProject(project).setInstance(instance).setAppProfile(appProfile).build().toString();
    }

    public static AppProfileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INSTANCE_APP_PROFILE.validatedMatch(formattedString, "AppProfileName.parse: formattedString not in valid format");
        return AppProfileName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("app_profile"));
    }

    public static List<AppProfileName> parseList(List<String> formattedStrings) {
        ArrayList<AppProfileName> list = new ArrayList<AppProfileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AppProfileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AppProfileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AppProfileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_APP_PROFILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AppProfileName appProfileName = this;
            synchronized (appProfileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.appProfile != null) {
                        fieldMapBuilder.put((Object)"app_profile", (Object)this.appProfile);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_APP_PROFILE.instantiate(new String[]{"project", this.project, "instance", this.instance, "app_profile", this.appProfile});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AppProfileName that = (AppProfileName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.appProfile, that.appProfile);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.appProfile);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String appProfile;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getAppProfile() {
            return this.appProfile;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setAppProfile(String appProfile) {
            this.appProfile = appProfile;
            return this;
        }

        private Builder(AppProfileName appProfileName) {
            this.project = appProfileName.project;
            this.instance = appProfileName.instance;
            this.appProfile = appProfileName.appProfile;
        }

        public AppProfileName build() {
            return new AppProfileName(this);
        }
    }
}

