/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.util;

import java.util.stream.IntStream;

public final class StringUtil {
    private StringUtil() {
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isEmpty(CharSequence cs) {
        return StringUtil.length(cs) == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        int len = StringUtil.length(cs);
        return len == 0 || IntStream.range(0, len).allMatch(i -> Character.isWhitespace(cs.charAt(i)));
    }

    public static String trimToNull(CharSequence cs) {
        String str = cs == null ? null : cs.toString().trim();
        return StringUtil.isEmpty(str) ? null : str;
    }

    public static String capitalize(String str) {
        int newCp;
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        int cp = str.codePointAt(0);
        return cp == (newCp = Character.toTitleCase(cp)) ? str : (char)newCp + str.substring(1);
    }

    public static String toTitleCase(String str) {
        if (str == null || str.isBlank()) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        boolean nextUpper = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('_' == c) {
                nextUpper = true;
                continue;
            }
            if (i == 0) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (nextUpper) {
                if ('_' == c) continue;
                sb.append(Character.toTitleCase(c));
                nextUpper = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String replace(String text, CharSequence searchString, CharSequence replacement) {
        return StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) ? text : text.replace(searchString, replacement);
    }

    public static String remove(CharSequence cs, CharSequence remove) {
        if (cs == null) {
            return null;
        }
        int len = cs.length();
        if (len == 0) {
            return "";
        }
        if (StringUtil.isEmpty(remove) || remove.length() > len) {
            return cs.toString();
        }
        return cs.toString().replace(remove, "");
    }
}

