/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.stats.DataPathsHolder;
import org.apache.cassandra.tools.nodetool.stats.DataPathsPrinter;
import org.apache.cassandra.tools.nodetool.stats.StatsPrinter;

@Command(name="datapaths", description="Print all directories where data of tables are stored")
public class DataPaths
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace.table>...]", description="List of table (or keyspace) names")
    private List<String> tableNames = new ArrayList<String>();
    @Option(title="format", name={"-F", "--format"}, description="Output format (json, yaml)")
    private String outputFormat = "";

    @Override
    protected void execute(NodeProbe probe) {
        if (!(this.outputFormat.isEmpty() || "json".equals(this.outputFormat) || "yaml".equals(this.outputFormat))) {
            throw new IllegalArgumentException("arguments for -F are yaml and json only.");
        }
        DataPathsHolder holder = new DataPathsHolder(probe, this.tableNames);
        StatsPrinter<DataPathsHolder> printer = DataPathsPrinter.from(this.outputFormat);
        printer.print(holder, probe.output().out);
    }
}

