/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.InfiniteLoopExecutor;
import org.apache.cassandra.concurrent.Interruptible;
import org.apache.cassandra.db.commitlog.BatchCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.concurrent.Semaphore;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommitLogService {
    static final long DEFAULT_MARKER_INTERVAL_MILLIS = 100L;
    private volatile Interruptible executor;
    protected volatile long lastSyncedAt = MonotonicClock.Global.preciseTime.now();
    private final AtomicLong written = new AtomicLong(0L);
    protected final AtomicLong pending = new AtomicLong(0L);
    protected final WaitQueue syncComplete = WaitQueue.newWaitQueue();
    protected final Semaphore haveWork = Semaphore.newSemaphore(1);
    final CommitLog commitLog;
    private final String name;
    final long syncIntervalNanos;
    final long markerIntervalNanos;
    private volatile boolean syncRequested;
    private static final Logger logger = LoggerFactory.getLogger(AbstractCommitLogService.class);

    AbstractCommitLogService(CommitLog commitLog, String name, long syncIntervalMillis) {
        this(commitLog, name, syncIntervalMillis, false);
    }

    AbstractCommitLogService(CommitLog commitLog, String name, long syncIntervalMillis, boolean markHeadersFaster) {
        long markerIntervalMillis;
        this.commitLog = commitLog;
        this.name = name;
        if (syncIntervalMillis < 0L) {
            markerIntervalMillis = -1L;
        } else if (markHeadersFaster && syncIntervalMillis > 100L) {
            markerIntervalMillis = 100L;
            long modulo = syncIntervalMillis % markerIntervalMillis;
            if (modulo != 0L) {
                syncIntervalMillis -= modulo;
                if (modulo >= markerIntervalMillis / 2L) {
                    syncIntervalMillis += markerIntervalMillis;
                }
            }
            assert (syncIntervalMillis % markerIntervalMillis == 0L);
            logger.debug("Will update the commitlog markers every {}ms and flush every {}ms", (Object)markerIntervalMillis, (Object)syncIntervalMillis);
        } else {
            markerIntervalMillis = syncIntervalMillis;
        }
        this.markerIntervalNanos = TimeUnit.NANOSECONDS.convert(markerIntervalMillis, TimeUnit.MILLISECONDS);
        this.syncIntervalNanos = TimeUnit.NANOSECONDS.convert(syncIntervalMillis, TimeUnit.MILLISECONDS);
    }

    void start() {
        if (this.syncIntervalNanos < 1L && !(this instanceof BatchCommitLogService)) {
            throw new IllegalArgumentException(String.format("Commit log flush interval must be positive: %fms", (double)this.syncIntervalNanos * 1.0E-6));
        }
        SyncRunnable sync = new SyncRunnable(MonotonicClock.Global.preciseTime);
        this.executor = ExecutorFactory.Global.executorFactory().infiniteLoop(this.name, sync, InfiniteLoopExecutor.SimulatorSafe.SAFE, InfiniteLoopExecutor.Daemon.NON_DAEMON, InfiniteLoopExecutor.Interrupts.SYNCHRONIZED);
    }

    public void finishWriteFor(CommitLogSegment.Allocation alloc) {
        this.maybeWaitForSync(alloc);
        this.written.incrementAndGet();
    }

    protected abstract void maybeWaitForSync(CommitLogSegment.Allocation var1);

    void requestExtraSync() {
        this.syncRequested = true;
        this.haveWork.release(1);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void syncBlocking() {
        long requestTime = Clock.Global.nanoTime();
        this.requestExtraSync();
        this.awaitSyncAt(requestTime, null);
    }

    void awaitSyncAt(long syncTime, Timer.Context context) {
        do {
            WaitQueue.Signal signal;
            WaitQueue.Signal signal2 = signal = context != null ? this.syncComplete.register(context, Timer.Context::stop) : this.syncComplete.register();
            if (this.lastSyncedAt < syncTime) {
                signal.awaitUninterruptibly();
                continue;
            }
            signal.cancel();
        } while (this.lastSyncedAt < syncTime);
    }

    public void awaitTermination() throws InterruptedException {
        this.executor.awaitTermination(5L, TimeUnit.MINUTES);
    }

    public long getCompletedTasks() {
        return this.written.get();
    }

    public long getPendingTasks() {
        return this.pending.get();
    }

    class SyncRunnable
    implements Interruptible.Task {
        private final MonotonicClock clock;
        private long firstLagAt = 0L;
        private long totalSyncDuration = 0L;
        private long syncExceededIntervalBy = 0L;
        private int lagCount = 0;
        private int syncCount = 0;

        SyncRunnable(MonotonicClock clock) {
            this.clock = clock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Interruptible.State state) throws InterruptedException {
            try {
                long pollStarted = this.clock.now();
                boolean flushToDisk = AbstractCommitLogService.this.lastSyncedAt + AbstractCommitLogService.this.syncIntervalNanos <= pollStarted || state != Interruptible.State.NORMAL || AbstractCommitLogService.this.syncRequested;
                SyncRunnable syncRunnable = this;
                synchronized (syncRunnable) {
                    Thread.interrupted();
                    if (flushToDisk) {
                        AbstractCommitLogService.this.syncRequested = false;
                        AbstractCommitLogService.this.commitLog.sync(true);
                        AbstractCommitLogService.this.lastSyncedAt = pollStarted;
                        AbstractCommitLogService.this.syncComplete.signalAll();
                        ++this.syncCount;
                    } else {
                        AbstractCommitLogService.this.commitLog.sync(false);
                    }
                }
                if (state == Interruptible.State.SHUTTING_DOWN) {
                    return;
                }
                if (AbstractCommitLogService.this.markerIntervalNanos <= 0L) {
                    AbstractCommitLogService.this.haveWork.acquire(1);
                } else {
                    long wakeUpAt;
                    long now = this.clock.now();
                    if (flushToDisk) {
                        this.maybeLogFlushLag(pollStarted, now);
                    }
                    if ((wakeUpAt = pollStarted + AbstractCommitLogService.this.markerIntervalNanos) > now) {
                        AbstractCommitLogService.this.haveWork.tryAcquireUntil(1, wakeUpAt);
                    }
                }
            }
            catch (Throwable t) {
                if (!CommitLog.handleCommitError("Failed to persist commits to disk", t)) {
                    throw new Interruptible.TerminateException();
                }
                AbstractCommitLogService.this.haveWork.tryAcquire(1, AbstractCommitLogService.this.markerIntervalNanos, TimeUnit.NANOSECONDS);
            }
        }

        @VisibleForTesting
        boolean maybeLogFlushLag(long pollStarted, long now) {
            boolean logged;
            long flushDuration = now - pollStarted;
            this.totalSyncDuration += flushDuration;
            long maxFlushTimestamp = pollStarted + AbstractCommitLogService.this.syncIntervalNanos;
            if (maxFlushTimestamp > now) {
                return false;
            }
            if (this.firstLagAt == 0L) {
                this.firstLagAt = now;
                this.lagCount = 0;
                this.syncExceededIntervalBy = 0;
                this.syncCount = 1;
                this.totalSyncDuration = flushDuration;
            }
            this.syncExceededIntervalBy += now - maxFlushTimestamp;
            ++this.lagCount;
            if (this.firstLagAt > 0L && (logged = NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 5L, TimeUnit.MINUTES, "Out of {} commit log syncs over the past {}s with average duration of {}ms, {} have exceeded the configured commit interval by an average of {}ms", this.syncCount, String.format("%.2f", (double)(now - this.firstLagAt) * 1.0E-9), String.format("%.2f", (double)this.totalSyncDuration * 1.0E-6 / (double)this.syncCount), this.lagCount, String.format("%.2f", (double)this.syncExceededIntervalBy * 1.0E-6 / (double)this.lagCount)))) {
                this.firstLagAt = 0L;
            }
            return true;
        }

        @VisibleForTesting
        long getTotalSyncDuration() {
            return this.totalSyncDuration;
        }
    }
}

