/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

abstract class FlinkMetricContainerBase {
    private static final @UnknownKeyFor @NonNull @Initialized String METRIC_KEY_SEPARATOR = GlobalConfiguration.loadConfiguration().getString(MetricOptions.SCOPE_DELIMITER);
    protected final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap metricsContainers;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Counter> flinkCounterCache = new HashMap<String, Counter>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FlinkDistributionGauge> flinkDistributionGaugeCache = new HashMap<String, FlinkDistributionGauge>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FlinkGauge> flinkGaugeCache = new HashMap<String, FlinkGauge>();
    private final @UnknownKeyFor @NonNull @Initialized MetricGroup metricGroup;

    public FlinkMetricContainerBase(@UnknownKeyFor @NonNull @Initialized MetricGroup metricGroup) {
        this.metricsContainers = new MetricsContainerStepMap();
        this.metricGroup = metricGroup;
    }

    public @UnknownKeyFor @NonNull @Initialized MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    public @UnknownKeyFor @NonNull @Initialized MetricsContainerImpl getMetricsContainer(@UnknownKeyFor @NonNull @Initialized String stepName) {
        return this.metricsContainers.getContainer(stepName);
    }

    public void updateMetrics(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo> monitoringInfos) {
        this.getMetricsContainer(stepName).update(monitoringInfos);
        this.updateMetrics(stepName);
    }

    void updateMetrics(@UnknownKeyFor @NonNull @Initialized String stepName) {
        MetricResults metricResults = MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.metricsContainers);
        MetricQueryResults metricQueryResults = metricResults.queryMetrics(MetricsFilter.builder().addStep(stepName).build());
        this.updateCounters(metricQueryResults.getCounters());
        this.updateDistributions(metricQueryResults.getDistributions());
        this.updateGauge(metricQueryResults.getGauges());
    }

    private void updateCounters(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> counters) {
        for (MetricResult<Long> metricResult : counters) {
            String flinkMetricName = FlinkMetricContainerBase.getFlinkMetricNameString(metricResult.getKey());
            Long update = (Long)metricResult.getAttempted();
            Counter counter = this.flinkCounterCache.computeIfAbsent(flinkMetricName, n -> this.getMetricGroup().counter(n));
            counter.inc(update - counter.getCount());
        }
    }

    private void updateDistributions(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> distributions) {
        for (MetricResult<DistributionResult> metricResult : distributions) {
            String flinkMetricName = FlinkMetricContainerBase.getFlinkMetricNameString(metricResult.getKey());
            DistributionResult update = (DistributionResult)metricResult.getAttempted();
            FlinkDistributionGauge gauge = this.flinkDistributionGaugeCache.get(flinkMetricName);
            if (gauge == null) {
                gauge = (FlinkDistributionGauge)this.getMetricGroup().gauge(flinkMetricName, (Gauge)new FlinkDistributionGauge(update));
                this.flinkDistributionGaugeCache.put(flinkMetricName, gauge);
                continue;
            }
            gauge.update(update);
        }
    }

    private void updateGauge(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> gauges) {
        for (MetricResult<GaugeResult> metricResult : gauges) {
            String flinkMetricName = FlinkMetricContainerBase.getFlinkMetricNameString(metricResult.getKey());
            GaugeResult update = (GaugeResult)metricResult.getAttempted();
            FlinkGauge gauge = this.flinkGaugeCache.get(flinkMetricName);
            if (gauge == null) {
                gauge = (FlinkGauge)this.getMetricGroup().gauge(flinkMetricName, (Gauge)new FlinkGauge(update));
                this.flinkGaugeCache.put(flinkMetricName, gauge);
                continue;
            }
            gauge.update(update);
        }
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String getFlinkMetricNameString(@UnknownKeyFor @NonNull @Initialized MetricKey metricKey) {
        MetricName metricName = metricKey.metricName();
        return metricName.getNamespace() + METRIC_KEY_SEPARATOR + metricName.getName();
    }

    public static class FlinkGauge
    implements Gauge<Long> {
        @UnknownKeyFor @NonNull @Initialized GaugeResult data;

        FlinkGauge(@UnknownKeyFor @NonNull @Initialized GaugeResult data) {
            this.data = data;
        }

        void update(@UnknownKeyFor @NonNull @Initialized GaugeResult update) {
            this.data = update;
        }

        public @UnknownKeyFor @NonNull @Initialized Long getValue() {
            return this.data.getValue();
        }
    }

    public static class FlinkDistributionGauge
    implements Gauge<DistributionResult> {
        @UnknownKeyFor @NonNull @Initialized DistributionResult data;

        FlinkDistributionGauge(@UnknownKeyFor @NonNull @Initialized DistributionResult data) {
            this.data = data;
        }

        void update(@UnknownKeyFor @NonNull @Initialized DistributionResult data) {
            this.data = data;
        }

        public @UnknownKeyFor @NonNull @Initialized DistributionResult getValue() {
            return this.data;
        }
    }
}

