/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.entrypoint.WorkingDirectory;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.memory.SharedResources;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.shuffle.ShuffleEnvironmentContext;
import org.apache.flink.runtime.shuffle.ShuffleServiceLoader;
import org.apache.flink.runtime.state.TaskExecutorChannelStateExecutorFactoryManager;
import org.apache.flink.runtime.state.TaskExecutorFileMergingManager;
import org.apache.flink.runtime.state.TaskExecutorLocalStateStoresManager;
import org.apache.flink.runtime.state.TaskExecutorStateChangelogStoragesManager;
import org.apache.flink.runtime.taskexecutor.DefaultJobLeaderService;
import org.apache.flink.runtime.taskexecutor.DefaultJobTable;
import org.apache.flink.runtime.taskexecutor.JobLeaderService;
import org.apache.flink.runtime.taskexecutor.JobTable;
import org.apache.flink.runtime.taskexecutor.KvStateService;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskexecutor.slot.DefaultTimerService;
import org.apache.flink.runtime.taskexecutor.slot.FileSlotAllocationSnapshotPersistenceService;
import org.apache.flink.runtime.taskexecutor.slot.NoOpSlotAllocationSnapshotPersistenceService;
import org.apache.flink.runtime.taskexecutor.slot.SlotAllocationSnapshotPersistenceService;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTableImpl;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.UnresolvedTaskManagerLocation;
import org.apache.flink.runtime.util.DefaultGroupCache;
import org.apache.flink.runtime.util.GroupCache;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerServices {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerServices.class);
    private final UnresolvedTaskManagerLocation unresolvedTaskManagerLocation;
    private final long managedMemorySize;
    private final IOManager ioManager;
    private final ShuffleEnvironment<?, ?> shuffleEnvironment;
    private final KvStateService kvStateService;
    private final BroadcastVariableManager broadcastVariableManager;
    private final TaskSlotTable<Task> taskSlotTable;
    private final JobTable jobTable;
    private final JobLeaderService jobLeaderService;
    private final TaskExecutorLocalStateStoresManager taskManagerStateStore;
    private final TaskExecutorFileMergingManager taskManagerFileMergingManager;
    private final TaskExecutorStateChangelogStoragesManager taskManagerChangelogManager;
    private final TaskExecutorChannelStateExecutorFactoryManager taskManagerChannelStateManager;
    private final TaskEventDispatcher taskEventDispatcher;
    private final ExecutorService ioExecutor;
    private final LibraryCacheManager libraryCacheManager;
    private final SlotAllocationSnapshotPersistenceService slotAllocationSnapshotPersistenceService;
    private final SharedResources sharedResources;
    private final GroupCache<JobID, PermanentBlobKey, JobInformation> jobInformationCache;
    private final GroupCache<JobID, PermanentBlobKey, TaskInformation> taskInformationCache;
    private final GroupCache<JobID, PermanentBlobKey, TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> shuffleDescriptorsCache;

    TaskManagerServices(UnresolvedTaskManagerLocation unresolvedTaskManagerLocation, long managedMemorySize, IOManager ioManager, ShuffleEnvironment<?, ?> shuffleEnvironment, KvStateService kvStateService, BroadcastVariableManager broadcastVariableManager, TaskSlotTable<Task> taskSlotTable, JobTable jobTable, JobLeaderService jobLeaderService, TaskExecutorLocalStateStoresManager taskManagerStateStore, TaskExecutorFileMergingManager taskManagerFileMergingManager, TaskExecutorStateChangelogStoragesManager taskManagerChangelogManager, TaskExecutorChannelStateExecutorFactoryManager taskManagerChannelStateManager, TaskEventDispatcher taskEventDispatcher, ExecutorService ioExecutor, LibraryCacheManager libraryCacheManager, SlotAllocationSnapshotPersistenceService slotAllocationSnapshotPersistenceService, SharedResources sharedResources, GroupCache<JobID, PermanentBlobKey, JobInformation> jobInformationCache, GroupCache<JobID, PermanentBlobKey, TaskInformation> taskInformationCache, GroupCache<JobID, PermanentBlobKey, TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> shuffleDescriptorsCache) {
        this.unresolvedTaskManagerLocation = (UnresolvedTaskManagerLocation)Preconditions.checkNotNull((Object)unresolvedTaskManagerLocation);
        this.managedMemorySize = managedMemorySize;
        this.ioManager = (IOManager)Preconditions.checkNotNull((Object)ioManager);
        this.shuffleEnvironment = (ShuffleEnvironment)Preconditions.checkNotNull(shuffleEnvironment);
        this.kvStateService = (KvStateService)Preconditions.checkNotNull((Object)kvStateService);
        this.broadcastVariableManager = (BroadcastVariableManager)Preconditions.checkNotNull((Object)broadcastVariableManager);
        this.taskSlotTable = (TaskSlotTable)Preconditions.checkNotNull(taskSlotTable);
        this.jobTable = (JobTable)Preconditions.checkNotNull((Object)jobTable);
        this.jobLeaderService = (JobLeaderService)Preconditions.checkNotNull((Object)jobLeaderService);
        this.taskManagerStateStore = (TaskExecutorLocalStateStoresManager)Preconditions.checkNotNull((Object)taskManagerStateStore);
        this.taskManagerFileMergingManager = (TaskExecutorFileMergingManager)Preconditions.checkNotNull((Object)taskManagerFileMergingManager);
        this.taskManagerChangelogManager = (TaskExecutorStateChangelogStoragesManager)Preconditions.checkNotNull((Object)taskManagerChangelogManager);
        this.taskManagerChannelStateManager = taskManagerChannelStateManager;
        this.taskEventDispatcher = (TaskEventDispatcher)Preconditions.checkNotNull((Object)taskEventDispatcher);
        this.ioExecutor = (ExecutorService)Preconditions.checkNotNull((Object)ioExecutor);
        this.libraryCacheManager = (LibraryCacheManager)Preconditions.checkNotNull((Object)libraryCacheManager);
        this.slotAllocationSnapshotPersistenceService = slotAllocationSnapshotPersistenceService;
        this.sharedResources = (SharedResources)Preconditions.checkNotNull((Object)sharedResources);
        this.jobInformationCache = jobInformationCache;
        this.taskInformationCache = taskInformationCache;
        this.shuffleDescriptorsCache = (GroupCache)Preconditions.checkNotNull(shuffleDescriptorsCache);
    }

    public long getManagedMemorySize() {
        return this.managedMemorySize;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public ShuffleEnvironment<?, ?> getShuffleEnvironment() {
        return this.shuffleEnvironment;
    }

    public KvStateService getKvStateService() {
        return this.kvStateService;
    }

    public UnresolvedTaskManagerLocation getUnresolvedTaskManagerLocation() {
        return this.unresolvedTaskManagerLocation;
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.broadcastVariableManager;
    }

    public TaskSlotTable<Task> getTaskSlotTable() {
        return this.taskSlotTable;
    }

    public JobTable getJobTable() {
        return this.jobTable;
    }

    public JobLeaderService getJobLeaderService() {
        return this.jobLeaderService;
    }

    public TaskExecutorLocalStateStoresManager getTaskManagerStateStore() {
        return this.taskManagerStateStore;
    }

    public TaskExecutorFileMergingManager getTaskManagerFileMergingManager() {
        return this.taskManagerFileMergingManager;
    }

    public TaskExecutorStateChangelogStoragesManager getTaskManagerChangelogManager() {
        return this.taskManagerChangelogManager;
    }

    public TaskExecutorChannelStateExecutorFactoryManager getTaskManagerChannelStateManager() {
        return this.taskManagerChannelStateManager;
    }

    public TaskEventDispatcher getTaskEventDispatcher() {
        return this.taskEventDispatcher;
    }

    public Executor getIOExecutor() {
        return this.ioExecutor;
    }

    public LibraryCacheManager getLibraryCacheManager() {
        return this.libraryCacheManager;
    }

    public SharedResources getSharedResources() {
        return this.sharedResources;
    }

    public GroupCache<JobID, PermanentBlobKey, JobInformation> getJobInformationCache() {
        return this.jobInformationCache;
    }

    public GroupCache<JobID, PermanentBlobKey, TaskInformation> getTaskInformationCache() {
        return this.taskInformationCache;
    }

    public GroupCache<JobID, PermanentBlobKey, TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> getShuffleDescriptorCache() {
        return this.shuffleDescriptorsCache;
    }

    public void shutDown() throws FlinkException {
        Exception exception = null;
        try {
            this.taskManagerStateStore.shutdown();
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            this.ioManager.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.shuffleEnvironment.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.kvStateService.shutdown();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.taskSlotTable.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.jobLeaderService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.ioExecutor.shutdown();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.jobTable.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.libraryCacheManager.shutdown();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        this.taskEventDispatcher.clearAll();
        if (exception != null) {
            throw new FlinkException("Could not properly shut down the TaskManager services.", (Throwable)exception);
        }
    }

    public static TaskManagerServices fromConfiguration(TaskManagerServicesConfiguration taskManagerServicesConfiguration, PermanentBlobService permanentBlobService, MetricGroup taskManagerMetricGroup, ExecutorService ioExecutor, ScheduledExecutor scheduledExecutor, FatalErrorHandler fatalErrorHandler, WorkingDirectory workingDirectory) throws Exception {
        TaskManagerServices.checkTempDirs(taskManagerServicesConfiguration.getTmpDirPaths());
        TaskEventDispatcher taskEventDispatcher = new TaskEventDispatcher();
        IOManagerAsync ioManager = new IOManagerAsync(taskManagerServicesConfiguration.getTmpDirPaths());
        ShuffleEnvironment<?, ?> shuffleEnvironment = TaskManagerServices.createShuffleEnvironment(taskManagerServicesConfiguration, taskEventDispatcher, taskManagerMetricGroup, ioExecutor, scheduledExecutor);
        int listeningDataPort = shuffleEnvironment.start();
        LOG.info("TaskManager data connection initialized successfully; listening internally on port: {}", (Object)listeningDataPort);
        KvStateService kvStateService = KvStateService.fromConfiguration(taskManagerServicesConfiguration);
        kvStateService.start();
        UnresolvedTaskManagerLocation unresolvedTaskManagerLocation = new UnresolvedTaskManagerLocation(taskManagerServicesConfiguration.getResourceID(), taskManagerServicesConfiguration.getExternalAddress(), taskManagerServicesConfiguration.getExternalDataPort() > 0 ? taskManagerServicesConfiguration.getExternalDataPort() : listeningDataPort, taskManagerServicesConfiguration.getNodeId());
        BroadcastVariableManager broadcastVariableManager = new BroadcastVariableManager();
        TaskSlotTable<Task> taskSlotTable = TaskManagerServices.createTaskSlotTable(taskManagerServicesConfiguration.getNumberOfSlots(), taskManagerServicesConfiguration.getTaskExecutorResourceSpec(), taskManagerServicesConfiguration.getTimerServiceShutdownTimeout(), taskManagerServicesConfiguration.getPageSize(), ioExecutor);
        DefaultJobTable jobTable = DefaultJobTable.create();
        DefaultJobLeaderService jobLeaderService = new DefaultJobLeaderService(unresolvedTaskManagerLocation, taskManagerServicesConfiguration.getRetryingRegistrationConfiguration());
        TaskExecutorLocalStateStoresManager taskStateManager = new TaskExecutorLocalStateStoresManager(taskManagerServicesConfiguration.isLocalRecoveryEnabled(), taskManagerServicesConfiguration.getLocalRecoveryStateDirectories(), ioExecutor);
        TaskExecutorStateChangelogStoragesManager changelogStoragesManager = new TaskExecutorStateChangelogStoragesManager();
        TaskExecutorChannelStateExecutorFactoryManager channelStateExecutorFactoryManager = new TaskExecutorChannelStateExecutorFactoryManager();
        TaskExecutorFileMergingManager fileMergingManager = new TaskExecutorFileMergingManager();
        boolean failOnJvmMetaspaceOomError = (Boolean)taskManagerServicesConfiguration.getConfiguration().get(CoreOptions.FAIL_ON_USER_CLASS_LOADING_METASPACE_OOM);
        boolean checkClassLoaderLeak = (Boolean)taskManagerServicesConfiguration.getConfiguration().get(CoreOptions.CHECK_LEAKED_CLASSLOADER);
        BlobLibraryCacheManager libraryCacheManager = new BlobLibraryCacheManager(permanentBlobService, BlobLibraryCacheManager.defaultClassLoaderFactory(taskManagerServicesConfiguration.getClassLoaderResolveOrder(), taskManagerServicesConfiguration.getAlwaysParentFirstLoaderPatterns(), (FatalErrorHandler)(failOnJvmMetaspaceOomError ? fatalErrorHandler : null), checkClassLoaderLeak), false);
        SlotAllocationSnapshotPersistenceService slotAllocationSnapshotPersistenceService = taskManagerServicesConfiguration.isLocalRecoveryEnabled() ? new FileSlotAllocationSnapshotPersistenceService(workingDirectory.getSlotAllocationSnapshotDirectory()) : NoOpSlotAllocationSnapshotPersistenceService.INSTANCE;
        DefaultGroupCache<JobID, PermanentBlobKey, JobInformation> jobInformationCache = new DefaultGroupCache.Factory().create();
        DefaultGroupCache<JobID, PermanentBlobKey, TaskInformation> taskInformationCache = new DefaultGroupCache.Factory().create();
        DefaultGroupCache<JobID, PermanentBlobKey, TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> shuffleDescriptorsCache = new DefaultGroupCache.Factory().create();
        return new TaskManagerServices(unresolvedTaskManagerLocation, taskManagerServicesConfiguration.getManagedMemorySize().getBytes(), ioManager, shuffleEnvironment, kvStateService, broadcastVariableManager, taskSlotTable, jobTable, jobLeaderService, taskStateManager, fileMergingManager, changelogStoragesManager, channelStateExecutorFactoryManager, taskEventDispatcher, ioExecutor, libraryCacheManager, slotAllocationSnapshotPersistenceService, new SharedResources(), jobInformationCache, taskInformationCache, shuffleDescriptorsCache);
    }

    private static TaskSlotTable<Task> createTaskSlotTable(int numberOfSlots, TaskExecutorResourceSpec taskExecutorResourceSpec, long timerServiceShutdownTimeout, int pageSize, Executor memoryVerificationExecutor) {
        DefaultTimerService<AllocationID> timerService = new DefaultTimerService<AllocationID>(new ScheduledThreadPoolExecutor(1), timerServiceShutdownTimeout);
        return new TaskSlotTableImpl<Task>(numberOfSlots, TaskExecutorResourceUtils.generateTotalAvailableResourceProfile(taskExecutorResourceSpec), TaskExecutorResourceUtils.generateDefaultSlotResourceProfile(taskExecutorResourceSpec, numberOfSlots), pageSize, timerService, memoryVerificationExecutor);
    }

    private static ShuffleEnvironment<?, ?> createShuffleEnvironment(TaskManagerServicesConfiguration taskManagerServicesConfiguration, TaskEventDispatcher taskEventDispatcher, MetricGroup taskManagerMetricGroup, Executor ioExecutor, ScheduledExecutor scheduledExecutor) throws FlinkException {
        ShuffleEnvironmentContext shuffleEnvironmentContext = new ShuffleEnvironmentContext(taskManagerServicesConfiguration.getConfiguration(), taskManagerServicesConfiguration.getResourceID(), taskManagerServicesConfiguration.getNetworkMemorySize(), taskManagerServicesConfiguration.isLocalCommunicationOnly(), taskManagerServicesConfiguration.getBindAddress(), taskManagerServicesConfiguration.getNumberOfSlots(), taskManagerServicesConfiguration.getTmpDirPaths(), taskEventDispatcher, taskManagerMetricGroup, ioExecutor, scheduledExecutor);
        return ShuffleServiceLoader.loadShuffleServiceFactory(taskManagerServicesConfiguration.getConfiguration()).createShuffleEnvironment(shuffleEnvironmentContext);
    }

    private static void checkTempDirs(String[] tmpDirs) throws IOException {
        for (String dir : tmpDirs) {
            if (dir != null && !dir.equals("")) {
                File file = new File(dir);
                if (!file.exists() && !file.mkdirs()) {
                    throw new IOException("Temporary file directory " + file.getAbsolutePath() + " does not exist and could not be created.");
                }
                if (!file.isDirectory()) {
                    throw new IOException("Temporary file directory " + file.getAbsolutePath() + " is not a directory.");
                }
                if (!file.canWrite()) {
                    throw new IOException("Temporary file directory " + file.getAbsolutePath() + " is not writable.");
                }
                if (!LOG.isInfoEnabled()) continue;
                long totalSpaceGb = file.getTotalSpace() >> 30;
                long usableSpaceGb = file.getUsableSpace() >> 30;
                double usablePercentage = (double)usableSpaceGb / (double)totalSpaceGb * 100.0;
                String path = file.getAbsolutePath();
                LOG.info(String.format("Temporary file directory '%s': total %d GB, usable %d GB (%.2f%% usable)", path, totalSpaceGb, usableSpaceGb, usablePercentage));
                continue;
            }
            throw new IllegalArgumentException("Temporary file directory #$id is null.");
        }
    }

    public SlotAllocationSnapshotPersistenceService getSlotAllocationSnapshotPersistenceService() {
        return this.slotAllocationSnapshotPersistenceService;
    }
}

