/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.topology;

import java.util.function.Function;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalVertex;
import org.apache.flink.runtime.jobgraph.topology.LogicalResult;
import org.apache.flink.util.Preconditions;

public class DefaultLogicalResult
implements LogicalResult {
    private final IntermediateDataSet intermediateDataSet;
    private final Function<JobVertexID, DefaultLogicalVertex> vertexRetriever;

    DefaultLogicalResult(IntermediateDataSet intermediateDataSet, Function<JobVertexID, DefaultLogicalVertex> vertexRetriever) {
        this.intermediateDataSet = (IntermediateDataSet)Preconditions.checkNotNull((Object)intermediateDataSet);
        this.vertexRetriever = (Function)Preconditions.checkNotNull(vertexRetriever);
    }

    @Override
    public IntermediateDataSetID getId() {
        return this.intermediateDataSet.getId();
    }

    @Override
    public ResultPartitionType getResultType() {
        return this.intermediateDataSet.getResultType();
    }

    @Override
    public DefaultLogicalVertex getProducer() {
        return this.vertexRetriever.apply(this.intermediateDataSet.getProducer().getID());
    }
}

