/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.hop.core.util.Utils;

public class EnvUtil {
    private static Properties env = null;

    private EnvUtil() {
    }

    public static final String getSystemProperty(String key, String def) {
        return System.getProperty(key, def);
    }

    public static final String getSystemProperty(String key) {
        return EnvUtil.getSystemProperty(key, null);
    }

    public static final String clearSystemProperty(String key) {
        return System.clearProperty(key);
    }

    public static Locale createLocale(String localeCode) {
        if (Utils.isEmpty(localeCode)) {
            return null;
        }
        StringTokenizer parser = new StringTokenizer(localeCode, "_");
        if (parser.countTokens() == 2) {
            return new Locale(parser.nextToken(), parser.nextToken());
        }
        if (parser.countTokens() == 3) {
            return new Locale(parser.nextToken(), parser.nextToken(), parser.nextToken());
        }
        return new Locale(localeCode);
    }

    public static TimeZone createTimeZone(String timeZoneId) {
        TimeZone resultTimeZone = null;
        if (!Utils.isEmpty(timeZoneId)) {
            return TimeZone.getTimeZone(timeZoneId);
        }
        resultTimeZone = TimeZone.getDefault();
        return resultTimeZone;
    }

    public static String[] getTimeZones() {
        Object[] timeZones = TimeZone.getAvailableIDs();
        Arrays.sort(timeZones);
        return timeZones;
    }

    public static String[] getLocaleList() {
        Locale[] locales = Locale.getAvailableLocales();
        Object[] strings = new String[locales.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = locales[i].toString();
        }
        Arrays.sort(strings);
        return strings;
    }
}

