/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.hash;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;

public class ByteArrayHashMap
extends AbstractHashedMap {
    private IRowMeta keyMeta;

    public ByteArrayHashMap(int initialCapacity, float loadFactor, IRowMeta keyMeta) {
        super(initialCapacity, loadFactor);
        this.keyMeta = keyMeta;
    }

    protected boolean isEqualKey(Object key1, Object key2) {
        return this.equalsByteArray((byte[])key1, (byte[])key2);
    }

    protected boolean isEqualValue(Object value1, Object value2) {
        return this.equalsByteArray((byte[])value1, (byte[])value2);
    }

    public final boolean equalsByteArray(byte[] value, byte[] cmpValue) {
        if (value.length == cmpValue.length) {
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == cmpValue[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ByteArrayHashMap(int initialCapacity, IRowMeta keyMeta) {
        this(initialCapacity, 0.75f, keyMeta);
    }

    public ByteArrayHashMap(IRowMeta keyMeta) {
        this(16, 0.75f, keyMeta);
    }

    public byte[] get(byte[] key) {
        return (byte[])super.get((Object)key);
    }

    public void put(byte[] key, byte[] value) {
        super.put((Object)key, (Object)value);
    }

    protected int hash(Object key) {
        byte[] rowKey = (byte[])key;
        try {
            return this.keyMeta.hashCode(RowMeta.getRow(this.keyMeta, rowKey));
        }
        catch (HopValueException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public List<byte[]> getKeys() {
        ArrayList<byte[]> rtn = new ArrayList<byte[]>(this.size());
        Set kSet = this.keySet();
        Iterator it = kSet.iterator();
        while (it.hasNext()) {
            rtn.add((byte[])it.next());
        }
        return rtn;
    }
}

