/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.database;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.Counter;
import org.apache.hop.core.Counters;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.DbCacheEntry;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabasePluginType;
import org.apache.hop.core.database.DelegatingDriver;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.database.SqlScriptParser;
import org.apache.hop.core.database.map.DatabaseConnectionMap;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopDatabaseBatchException;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.DefaultLogLevel;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.IMetrics;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.Metrics;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaBigNumber;
import org.apache.hop.core.row.value.ValueMetaBinary;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaInternetAddress;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.row.value.ValueMetaTimestamp;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;

public class Database
implements IVariables,
ILoggingObject,
AutoCloseable {
    private static final Class<?> PKG = Database.class;
    private static final Map<String, Set<String>> registeredDrivers = new HashMap<String, Set<String>>();
    private final DatabaseMeta databaseMeta;
    private static final String DATA_SERVICES_PLUGIN_ID = "HopThin";
    private static final String CONST_INOUT = "INOUT";
    private static final String CONST_BETWEEN = "BETWEEN";
    private static final String CONST_IS_NULL = "IS NULL";
    private static final String CONST_IS_NOT_NULL = "IS NULL";
    private static final String CONST_BETWEEN_AND = " BETWEEN ? AND ? ";
    private static final String CONST_TRUNCATE_NOT_SUPPORTED = "Truncate table not supported by ";
    private static final String CONST_TABLE_CAT = "TABLE_CAT";
    private static final String CONST_TABLE_SCHEM = "TABLE_SCHEM";
    private static final String CONST_READ = "read :";
    private static final String CONST_ERROR_UPDATING_BATCH = "Error updating batch";
    private int rowlimit;
    private int commitsize;
    private Connection connection;
    private Statement selStmt;
    private PreparedStatement pstmt;
    private PreparedStatement prepStatementLookup;
    private PreparedStatement prepStatementUpdate;
    private PreparedStatement prepStatementInsert;
    private PreparedStatement pstmtSeq;
    private CallableStatement cstmt;
    private DatabaseMetaData dbmd;
    private IRowMeta rowMeta;
    private int written;
    private final ILogChannel log;
    private final ILoggingObject parentLoggingObject;
    private static final String TABLES_META_DATA_TABLE_NAME = "TABLE_NAME";
    private volatile int opened;
    private volatile int copy;
    private String connectionGroup;
    private String partitionId;
    private IVariables variables = new Variables();
    private LogLevel logLevel = DefaultLogLevel.getLogLevel();
    private String containerObjectId;
    private int nrExecutedCommits;
    private static final List<IValueMeta> valueMetaPluginClasses;

    public Database(ILoggingObject parentObject, IVariables variables, DatabaseMeta databaseMeta) {
        this.parentLoggingObject = parentObject;
        this.variables = variables;
        this.databaseMeta = databaseMeta;
        this.log = new LogChannel((Object)this, parentObject);
        this.containerObjectId = this.log.getContainerObjectId();
        this.logLevel = this.log.getLogLevel();
        if (parentObject != null) {
            this.log.setGatheringMetrics(parentObject.isGatheringMetrics());
        }
        this.pstmt = null;
        this.rowMeta = null;
        this.dbmd = null;
        this.rowlimit = 0;
        this.written = 0;
        this.copy = 0;
        this.opened = 0;
        try {
            ExtensionPointHandler.callExtensionPoint(this.log, variables, HopExtensionPoint.DatabaseCreated.id, this);
        }
        catch (Exception e) {
            throw new RuntimeException("Error calling extension point while creating database connection", e);
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed("New database connection defined");
        }
    }

    public boolean equals(Object obj) {
        Database other = (Database)obj;
        if (other == null) {
            return false;
        }
        return this.databaseMeta.equals(other.databaseMeta);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setQueryLimit(int rows) {
        this.rowlimit = rows;
    }

    public PreparedStatement getPrepStatementInsert() {
        return this.prepStatementInsert;
    }

    public PreparedStatement getPrepStatementLookup() {
        return this.prepStatementLookup;
    }

    public PreparedStatement getPrepStatementUpdate() {
        return this.prepStatementUpdate;
    }

    public void connect() throws HopDatabaseException {
        try {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_CONNECT_START, this.databaseMeta.getName(), new long[0]);
            if (!Utils.isEmpty(this.connectionGroup)) {
                Database lookup = DatabaseConnectionMap.getInstance().getOrStoreIfAbsent(this.connectionGroup, this.partitionId, this);
                if (lookup == null) {
                    lookup = this;
                }
                lookup.shareConnectionWith(this.partitionId, this);
            } else {
                this.normalConnect(this.partitionId);
            }
            try {
                ExtensionPointHandler.callExtensionPoint(this.log, this, HopExtensionPoint.DatabaseConnected.id, this);
            }
            catch (HopException e) {
                throw new HopDatabaseException(e);
            }
        }
        finally {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_CONNECT_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    private synchronized void shareConnectionWith(String partitionId, Database anotherDb) throws HopDatabaseException {
        ++this.opened;
        if (this.connection == null) {
            this.normalConnect(partitionId);
            this.copy = this.opened;
            this.setAutoCommit(false);
        }
        anotherDb.connection = this.connection;
        anotherDb.copy = this.opened;
    }

    public void normalConnect(String partitionId) throws HopDatabaseException {
        if (this.databaseMeta == null) {
            throw new HopDatabaseException("No valid database connection defined!");
        }
        try {
            this.connectUsingClass(this.databaseMeta.getDriverClass(this), partitionId);
            String sql = this.resolve(this.databaseMeta.getConnectSql());
            if (!Utils.isEmpty(sql) && !Const.onlySpaces(sql)) {
                this.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Executed connect time SQL statements:" + Const.CR + sql);
                }
            }
        }
        catch (Exception e) {
            throw new HopDatabaseException("Error occurred while trying to connect to the database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectUsingClass(String classname, String partitionId) throws HopDatabaseException {
        IPlugin plugin = PluginRegistry.getInstance().getPlugin(DatabasePluginType.class, this.databaseMeta.getIDatabase());
        try {
            Class<DriverManager> clazz = DriverManager.class;
            synchronized (DriverManager.class) {
                ClassLoader classLoader = PluginRegistry.getInstance().getClassLoader(plugin);
                Class<?> driverClass = classLoader.loadClass(classname);
                if (driverClass.getClassLoader() != this.getClass().getClassLoader()) {
                    String pluginId = PluginRegistry.getInstance().getPluginId(DatabasePluginType.class, this.databaseMeta.getIDatabase());
                    Set<String> registeredDriversFromPlugin = registeredDrivers.get(pluginId);
                    if (registeredDriversFromPlugin == null) {
                        registeredDriversFromPlugin = new HashSet<String>();
                        registeredDrivers.put(pluginId, registeredDriversFromPlugin);
                    }
                    if (!registeredDriversFromPlugin.contains(driverClass.getCanonicalName())) {
                        DriverManager.registerDriver(new DelegatingDriver((Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
                        registeredDriversFromPlugin.add(driverClass.getCanonicalName());
                    }
                } else {
                    Class.forName(classname);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToFindClassMissingDriver", classname, plugin.getName()), e);
        }
        catch (Exception e) {
            throw new HopDatabaseException("Exception while loading class", e);
        }
        {
            try {
                Object url = this.resolve(this.databaseMeta.getURL(this));
                this.log.logDebug("Connecting to database using URL: " + (String)url);
                String username = this.resolve(this.databaseMeta.getUsername());
                String password = Encr.decryptPasswordOptionallyEncrypted(this.resolve(this.databaseMeta.getPassword()));
                Properties properties = this.databaseMeta.getConnectionProperties(this);
                if (this.databaseMeta.supportsOptionsInURL()) {
                    if (!Utils.isEmpty(username) || !Utils.isEmpty(password)) {
                        String instance;
                        properties.put("user", Const.NVL(username, " "));
                        properties.put("password", Const.NVL(password, ""));
                        if (this.databaseMeta.getIDatabase().isMsSqlServerNativeVariant() && !Utils.isEmpty(instance = this.resolve(this.databaseMeta.getSqlServerInstance()))) {
                            url = (String)url + ";instanceName=" + instance;
                        }
                        this.connection = DriverManager.getConnection((String)url, properties);
                    } else {
                        this.connection = DriverManager.getConnection((String)url, properties);
                    }
                } else {
                    if (!Utils.isEmpty(username)) {
                        properties.put("user", username);
                    }
                    if (!Utils.isEmpty(password)) {
                        properties.put("password", password);
                    }
                    this.connection = DriverManager.getConnection((String)url, properties);
                }
            }
            catch (Exception e) {
                throw new HopDatabaseException("Error connecting to database: (using class " + classname + ")", e);
            }
            return;
        }
    }

    @Override
    public synchronized void close() {
        this.disconnect();
    }

    public synchronized void disconnect() {
        if (this.connection == null) {
            return;
        }
        try {
            if (this.connection.isClosed()) {
                return;
            }
        }
        catch (SQLException ex) {
            this.log.logError("Error checking closing connection:" + Const.CR + ex.getMessage());
            this.log.logError(Const.getStackTracker(ex));
        }
        if (this.pstmt != null) {
            try {
                this.pstmt.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.pstmt = null;
        }
        if (this.prepStatementLookup != null) {
            try {
                this.prepStatementLookup.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing lookup statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.prepStatementLookup = null;
        }
        if (this.prepStatementInsert != null) {
            try {
                this.prepStatementInsert.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing insert statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.prepStatementInsert = null;
        }
        if (this.prepStatementUpdate != null) {
            try {
                this.prepStatementUpdate.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing update statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.prepStatementUpdate = null;
        }
        if (this.pstmtSeq != null) {
            try {
                this.pstmtSeq.close();
            }
            catch (SQLException ex) {
                this.log.logError("Error closing seq statement:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
            this.pstmtSeq = null;
        }
        if (!Utils.isEmpty(this.connectionGroup)) {
            return;
        }
        if (!this.isAutoCommit()) {
            try {
                this.commit();
            }
            catch (HopDatabaseException ex) {
                this.log.logError("Error committing:" + Const.CR + ex.getMessage());
                this.log.logError(Const.getStackTracker(ex));
            }
        }
        try {
            ExtensionPointHandler.callExtensionPoint(this.log, this, HopExtensionPoint.DatabaseDisconnected.id, this);
        }
        catch (HopException e) {
            this.log.logError("Error disconnecting from database:" + Const.CR + e.getMessage());
            this.log.logError(Const.getStackTracker(e));
        }
        finally {
            try {
                this.closeConnectionOnly();
            }
            catch (HopDatabaseException hde) {
                this.log.logError("Error disconnecting from database - closeConnectionOnly failed:" + Const.CR + hde.getMessage());
                this.log.logError(Const.getStackTracker(hde));
            }
        }
    }

    public synchronized void closeConnectionOnly() throws HopDatabaseException {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed("Connection to database closed!");
            }
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Error disconnecting from database '" + String.valueOf(this) + "'", e);
        }
    }

    public void cancelQuery() throws HopDatabaseException {
        if (this.databaseMeta.isMySqlVariant() && this.databaseMeta.isStreamingResults() && this.getDatabaseMetaData().getDriverMajorVersion() == 3) {
            return;
        }
        this.cancelStatement(this.pstmt);
        this.cancelStatement(this.selStmt);
    }

    public void cancelStatement(Statement statement) throws HopDatabaseException {
        try {
            if (statement != null) {
                statement.cancel();
            }
            if (this.log.isDebug()) {
                this.log.logDebug("Statement canceled!");
            }
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Error cancelling statement", ex);
        }
    }

    public void setCommit(int commsize) {
        block3: {
            this.commitsize = commsize;
            String onOff = this.commitsize <= 0 ? "on" : "off";
            try {
                this.connection.setAutoCommit(this.commitsize <= 0);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Auto commit " + onOff);
                }
            }
            catch (Exception e) {
                if (!this.log.isDebug()) break block3;
                this.log.logDebug("Can't turn auto commit " + onOff + Const.CR + Const.getSimpleStackTrace(e) + Const.CR + Const.getStackTracker(e));
            }
        }
    }

    public void setAutoCommit(boolean useAutoCommit) throws HopDatabaseException {
        try {
            this.connection.setAutoCommit(useAutoCommit);
        }
        catch (SQLException e) {
            if (useAutoCommit) {
                throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToEnableAutoCommit", this.toString()));
            }
            throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToDisableAutoCommit", this.toString()));
        }
    }

    public void commit() throws HopDatabaseException {
        this.commit(false);
    }

    public void commit(boolean force) throws HopDatabaseException {
        block7: {
            try {
                if (!Utils.isEmpty(this.connectionGroup) && !force) {
                    return;
                }
                if (this.getDatabaseMetaData().supportsTransactions()) {
                    if (this.log.isDebug()) {
                        this.log.logDebug("Commit on database connection [" + String.valueOf(this) + "]");
                    }
                    this.connection.commit();
                    ++this.nrExecutedCommits;
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("No commit possible on database connection [" + String.valueOf(this) + "]");
                }
            }
            catch (Exception e) {
                if (!this.databaseMeta.supportsEmptyTransactions()) break block7;
                throw new HopDatabaseException("Error comitting connection", e);
            }
        }
    }

    public void rollback() throws HopDatabaseException {
        this.rollback(false);
    }

    public void rollback(boolean force) throws HopDatabaseException {
        try {
            if (!Utils.isEmpty(this.connectionGroup) && !force) {
                return;
            }
            if (this.getDatabaseMetaData().supportsTransactions()) {
                if (this.connection != null) {
                    if (this.log.isDebug()) {
                        this.log.logDebug("Rollback on database connection [" + String.valueOf(this) + "]");
                    }
                    this.connection.rollback();
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("No rollback possible on database connection [" + String.valueOf(this) + "]");
            }
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Error performing rollback on connection", e);
        }
    }

    public void prepareInsert(IRowMeta rowMeta, String tableName) throws HopDatabaseException {
        this.prepareInsert(rowMeta, null, tableName);
    }

    public void prepareInsert(IRowMeta rowMeta, String schemaName, String tableName) throws HopDatabaseException {
        if (rowMeta.isEmpty()) {
            throw new HopDatabaseException("No fields in row, can't insert!");
        }
        String ins = this.getInsertStatement(schemaName, tableName, rowMeta);
        if (this.log.isDetailed()) {
            this.log.logDetailed("Preparing statement: " + Const.CR + ins);
        }
        this.prepStatementInsert = this.prepareSql(ins);
    }

    public PreparedStatement prepareSql(String sql) throws HopDatabaseException {
        return this.prepareSql(sql, false);
    }

    public PreparedStatement prepareSql(String sql, boolean returnKeys) throws HopDatabaseException {
        IDatabase iDatabase = this.databaseMeta.getIDatabase();
        boolean supportsAutoGeneratedKeys = iDatabase.isSupportsAutoGeneratedKeys();
        try {
            if (returnKeys && supportsAutoGeneratedKeys) {
                return this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1);
            }
            return this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Couldn't prepare statement:" + Const.CR + sql, ex);
        }
    }

    public void closeLookup() throws HopDatabaseException {
        this.closePreparedStatement(this.pstmt);
        this.pstmt = null;
    }

    public void closePreparedStatement(PreparedStatement ps) throws HopDatabaseException {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Error closing prepared statement", e);
            }
        }
    }

    public void closeInsert() throws HopDatabaseException {
        if (this.prepStatementInsert != null) {
            try {
                this.prepStatementInsert.close();
                this.prepStatementInsert = null;
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Error closing insert prepared statement.", e);
            }
        }
    }

    public void closeUpdate() throws HopDatabaseException {
        if (this.prepStatementUpdate != null) {
            try {
                this.prepStatementUpdate.close();
                this.prepStatementUpdate = null;
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Error closing update prepared statement.", e);
            }
        }
    }

    public void setValues(IRowMeta rowMeta, Object[] data) throws HopDatabaseException {
        this.setValues(rowMeta, data, this.pstmt);
    }

    public void setValues(RowMetaAndData row) throws HopDatabaseException {
        this.setValues(row.getRowMeta(), row.getData());
    }

    public void setValuesInsert(IRowMeta rowMeta, Object[] data) throws HopDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementInsert);
    }

    public void setValuesInsert(RowMetaAndData row) throws HopDatabaseException {
        this.setValues(row.getRowMeta(), row.getData(), this.prepStatementInsert);
    }

    public void setValuesUpdate(IRowMeta rowMeta, Object[] data) throws HopDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementUpdate);
    }

    public void setValuesLookup(IRowMeta rowMeta, Object[] data) throws HopDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementLookup);
    }

    public void setProcValues(IRowMeta rowMeta, Object[] data, int[] argnrs, String[] argdir, boolean result) throws HopDatabaseException {
        int pos = result ? 2 : 1;
        for (int i = 0; i < argnrs.length; ++i) {
            if (argdir[i].equalsIgnoreCase("IN") || argdir[i].equalsIgnoreCase(CONST_INOUT)) {
                IValueMeta valueMeta = rowMeta.getValueMeta(argnrs[i]);
                Object value = data[argnrs[i]];
                this.setValue(this.cstmt, valueMeta, value, pos);
                ++pos;
                continue;
            }
            ++pos;
        }
    }

    public void setValue(PreparedStatement ps, IValueMeta v, Object object, int pos) throws HopDatabaseException {
        v.setPreparedStatementValue(this.databaseMeta, ps, pos, object);
    }

    public void setValues(RowMetaAndData row, PreparedStatement ps) throws HopDatabaseException {
        this.setValues(row.getRowMeta(), row.getData(), ps);
    }

    public void setValues(IRowMeta rowMeta, Object[] data, PreparedStatement ps) throws HopDatabaseException {
        for (int i = 0; i < rowMeta.size(); ++i) {
            IValueMeta v = rowMeta.getValueMeta(i);
            Object object = data[i];
            try {
                this.setValue(ps, v, object, i + 1);
                continue;
            }
            catch (HopDatabaseException e) {
                throw new HopDatabaseException("offending row : " + String.valueOf(rowMeta), e);
            }
        }
    }

    public void setValues(IRowMeta rowMeta, Object[] data, PreparedStatement ps, int ignoreThisValueIndex) throws HopDatabaseException {
        int index = 0;
        for (int i = 0; i < rowMeta.size(); ++i) {
            if (i == ignoreThisValueIndex) continue;
            IValueMeta v = rowMeta.getValueMeta(i);
            Object object = data[i];
            try {
                this.setValue(ps, v, object, index + 1);
                ++index;
                continue;
            }
            catch (HopDatabaseException e) {
                throw new HopDatabaseException("offending row : " + String.valueOf(rowMeta), e);
            }
        }
    }

    public RowMetaAndData getGeneratedKeys(PreparedStatement ps) throws HopDatabaseException {
        ResultSet keys = null;
        try {
            IRowMeta rowMeta;
            keys = ps.getGeneratedKeys();
            ResultSetMetaData resultSetMetaData = keys.getMetaData();
            if (resultSetMetaData == null) {
                resultSetMetaData = ps.getMetaData();
            }
            if (resultSetMetaData == null) {
                rowMeta = new RowMeta();
                rowMeta.addValueMeta(new ValueMetaInteger("ai-key"));
            } else {
                rowMeta = this.getRowInfo(resultSetMetaData, false, false);
            }
            RowMetaAndData rowMetaAndData = new RowMetaAndData(rowMeta, this.getRow(keys, resultSetMetaData, rowMeta));
            return rowMetaAndData;
        }
        catch (Exception ex) {
            throw new HopDatabaseException("Unable to retrieve key(s) from auto-increment field(s)", ex);
        }
        finally {
            if (keys != null) {
                try {
                    keys.close();
                }
                catch (SQLException e) {
                    this.log.logError("Unable to close resultset of auto-generated keys", e);
                }
            }
        }
    }

    public Long getNextSequenceValue(String sequenceName, String keyfield) throws HopDatabaseException {
        return this.getNextSequenceValue(null, sequenceName, keyfield);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextSequenceValue(String schemaName, String sequenceName, String keyfield) throws HopDatabaseException {
        Long retval = null;
        String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, sequenceName);
        try {
            if (this.pstmtSeq == null) {
                this.pstmtSeq = this.connection.prepareStatement(this.databaseMeta.getSeqNextvalSql(this.databaseMeta.stripCR(schemaSequence)));
            }
            try (ResultSet rs = null;){
                rs = this.pstmtSeq.executeQuery();
                if (rs.next()) {
                    retval = rs.getLong(1);
                }
            }
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to get next value for sequence : " + schemaSequence, ex);
        }
        return retval;
    }

    public void insertRow(String tableName, IRowMeta fields, Object[] data) throws HopDatabaseException {
        this.insertRow(null, tableName, fields, data);
    }

    public void insertRow(String schemaName, String tableName, IRowMeta fields, Object[] data) throws HopDatabaseException {
        this.prepareInsert(fields, schemaName, tableName);
        this.setValuesInsert(fields, data);
        this.insertRow();
        this.closeInsert();
    }

    public String getInsertStatement(String tableName, IRowMeta fields) {
        return this.getInsertStatement(null, tableName, fields);
    }

    public String getInsertStatement(String schemaName, String tableName, IRowMeta fields) {
        int i;
        StringBuilder ins = new StringBuilder(128);
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, tableName);
        ins.append("INSERT INTO ").append(schemaTable).append(" ");
        String beforeFieldsClause = this.databaseMeta.getIDatabase().getSqlInsertClauseBeforeFields(this, schemaTable);
        if (StringUtils.isNotEmpty((String)beforeFieldsClause)) {
            ins.append(beforeFieldsClause).append(" ");
        }
        ins.append("(");
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins.append(", ");
            }
            String name = fields.getValueMeta(i).getName();
            ins.append(this.databaseMeta.quoteField(name));
        }
        ins.append(")");
        ins.append(" VALUES (");
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins.append(", ");
            }
            ins.append(" ?");
        }
        ins.append(')');
        return ins.toString();
    }

    public void insertRow() throws HopDatabaseException {
        this.insertRow(this.prepStatementInsert);
    }

    public void insertRow(boolean batch) throws HopDatabaseException {
        this.insertRow(this.prepStatementInsert, batch);
    }

    public void updateRow() throws HopDatabaseException {
        this.insertRow(this.prepStatementUpdate);
    }

    public void insertRow(PreparedStatement ps) throws HopDatabaseException {
        this.insertRow(ps, false);
    }

    public boolean insertRow(PreparedStatement ps, boolean batch) throws HopDatabaseException {
        return this.insertRow(ps, batch, true);
    }

    public boolean getUseBatchInsert(boolean batch) throws HopDatabaseException {
        try {
            return batch && this.getDatabaseMetaData().supportsBatchUpdates() && this.databaseMeta.supportsBatchUpdates() && Utils.isEmpty(this.connectionGroup);
        }
        catch (SQLException e) {
            throw Database.createHopDatabaseBatchException("Error determining whether to use batch", e);
        }
    }

    public boolean insertRow(PreparedStatement ps, boolean batch, boolean handleCommit) throws HopDatabaseException {
        String debug = "insertRow start";
        boolean rowsAreSafe = false;
        boolean isBatchUpdate = false;
        try {
            boolean useBatchInsert = this.getUseBatchInsert(batch);
            if (!this.isAutoCommit()) {
                if (useBatchInsert) {
                    debug = "insertRow add batch";
                    ps.addBatch();
                } else {
                    debug = "insertRow exec update";
                    ps.executeUpdate();
                }
            } else {
                ps.executeUpdate();
            }
            ++this.written;
            if (handleCommit && !this.isAutoCommit() && this.written % this.commitsize == 0) {
                if (useBatchInsert) {
                    isBatchUpdate = true;
                    debug = "insertRow executeBatch commit";
                    ps.executeBatch();
                    this.commit();
                    ps.clearBatch();
                } else {
                    debug = "insertRow normal commit";
                    this.commit();
                }
                this.written = 0;
                rowsAreSafe = true;
            }
            return rowsAreSafe;
        }
        catch (BatchUpdateException ex) {
            throw Database.createHopDatabaseBatchException(CONST_ERROR_UPDATING_BATCH, ex);
        }
        catch (SQLException ex) {
            if (isBatchUpdate) {
                throw Database.createHopDatabaseBatchException(CONST_ERROR_UPDATING_BATCH, ex);
            }
            throw new HopDatabaseException("Error inserting/updating row", ex);
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unexpected error inserting/updating row in part [" + debug + "]", e);
        }
    }

    public void clearBatch(PreparedStatement preparedStatement) throws HopDatabaseException {
        try {
            preparedStatement.clearBatch();
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Unable to clear batch for prepared statement", e);
        }
    }

    public void executeAndClearBatch(PreparedStatement preparedStatement) throws HopDatabaseException {
        try {
            if (this.written > 0 && this.getDatabaseMetaData().supportsBatchUpdates()) {
                preparedStatement.executeBatch();
            }
            this.written = 0;
            preparedStatement.clearBatch();
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Unable to clear batch for prepared statement", e);
        }
    }

    public void emptyAndCommit(PreparedStatement ps, boolean batch) throws HopDatabaseException {
        this.emptyAndCommit(ps, batch, this.written);
    }

    public void emptyAndCommit(PreparedStatement ps, boolean batch, int batchCounter) throws HopDatabaseException {
        this.emptyAndCommit(ps, batch, batchCounter, true);
    }

    public void emptyAndCommit(PreparedStatement ps, boolean batch, int batchCounter, boolean closeStatement) throws HopDatabaseException {
        boolean isBatchUpdate = false;
        try {
            if (ps != null) {
                if (!this.isAutoCommit()) {
                    if (batch && this.getDatabaseMetaData().supportsBatchUpdates() && batchCounter > 0) {
                        isBatchUpdate = true;
                        ps.executeBatch();
                        this.commit();
                        ps.clearBatch();
                    } else {
                        this.commit();
                    }
                }
                if (closeStatement) {
                    ps.close();
                }
            }
        }
        catch (BatchUpdateException ex) {
            throw Database.createHopDatabaseBatchException(CONST_ERROR_UPDATING_BATCH, ex);
        }
        catch (SQLException ex) {
            if (isBatchUpdate) {
                throw Database.createHopDatabaseBatchException(CONST_ERROR_UPDATING_BATCH, ex);
            }
            throw new HopDatabaseException("Unable to empty ps and commit connection.", ex);
        }
    }

    public static HopDatabaseBatchException createHopDatabaseBatchException(String message, SQLException ex) {
        HopDatabaseBatchException kdbe = new HopDatabaseBatchException(message, ex);
        if (ex instanceof BatchUpdateException) {
            BatchUpdateException batchUpdateException = (BatchUpdateException)ex;
            kdbe.setUpdateCounts(batchUpdateException.getUpdateCounts());
        } else {
            kdbe.setUpdateCounts(null);
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        SQLException oldException = null;
        for (SQLException nextException = ex.getNextException(); nextException != null && oldException != nextException; nextException = nextException.getNextException()) {
            exceptions.add(nextException);
            oldException = nextException;
        }
        kdbe.setExceptionsList(exceptions);
        return kdbe;
    }

    public Result execStatement(String sql) throws HopDatabaseException {
        return this.execStatement(sql, null, null);
    }

    public Result execStatement(String rawsql, IRowMeta params, Object[] data) throws HopDatabaseException {
        Result result = new Result();
        String sql = this.databaseMeta.getIDatabase().createSqlScriptParser().removeComments(rawsql).trim();
        try {
            int count;
            boolean resultSet;
            if (params != null) {
                PreparedStatement prepStmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                this.setValues(params, data, prepStmt);
                resultSet = prepStmt.execute();
                count = prepStmt.getUpdateCount();
                prepStmt.close();
            } else {
                String sqlStripped = this.databaseMeta.stripCR(sql);
                try (Statement stmt = this.connection.createStatement();){
                    resultSet = stmt.execute(sqlStripped);
                    count = stmt.getUpdateCount();
                }
            }
            String upperSql = sql.toUpperCase();
            if (!resultSet && count > 0) {
                if (upperSql.startsWith("INSERT")) {
                    result.setNrLinesOutput(count);
                } else if (!this.databaseMeta.isSupportsCustomUpdateStmt() && upperSql.startsWith("UPDATE")) {
                    result.setNrLinesUpdated(count);
                } else if (this.databaseMeta.isSupportsCustomUpdateStmt() && upperSql.contains("UPDATE")) {
                    result.setNrLinesUpdated(count);
                } else if (!this.databaseMeta.isSupportsCustomDeleteStmt() && upperSql.startsWith("DELETE")) {
                    result.setNrLinesDeleted(count);
                } else if (this.databaseMeta.isSupportsCustomDeleteStmt() && upperSql.contains("DELETE")) {
                    result.setNrLinesDeleted(count);
                }
            }
            if (upperSql.startsWith("ALTER TABLE") || upperSql.startsWith("DROP TABLE") || upperSql.startsWith("CREATE TABLE")) {
                DbCache.getInstance().clear(this.databaseMeta.getName());
            }
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Couldn't execute SQL: " + sql + Const.CR, ex);
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unexpected error executing SQL: " + Const.CR, e);
        }
        return result;
    }

    public Result execStatements(String script) throws HopDatabaseException {
        return this.execStatements(script, null, null);
    }

    public Result execStatements(String script, IRowMeta params, Object[] data) throws HopDatabaseException {
        Result result = new Result();
        SqlScriptParser sqlScriptParser = this.databaseMeta.getIDatabase().createSqlScriptParser();
        List<String> statements = sqlScriptParser.split(script);
        int nrstats = 0;
        if (statements != null) {
            for (String stat : statements) {
                if (Const.onlySpaces(stat = sqlScriptParser.removeComments(stat))) continue;
                String sql = Const.trim(stat);
                if (sql.toUpperCase().startsWith("SELECT") && !sql.toUpperCase().matches("(?is)^(select\\s.*\\sinto\\s).*")) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("launch SELECT statement: " + Const.CR + sql);
                    }
                    ++nrstats;
                    ResultSet rs = null;
                    try {
                        rs = this.openQuery(sql, params, data);
                        if (rs != null) {
                            Object[] row = this.getRow(rs);
                            while (row != null) {
                                result.setNrLinesRead(result.getNrLinesRead() + 1L);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed(this.rowMeta.getString(row));
                                }
                                row = this.getRow(rs);
                            }
                            continue;
                        }
                        if (!this.log.isDebug()) continue;
                        this.log.logDebug("Error executing query: " + Const.CR + sql);
                        continue;
                    }
                    catch (HopValueException e) {
                        throw new HopDatabaseException(e);
                    }
                    finally {
                        try {
                            if (rs == null) continue;
                            rs.close();
                        }
                        catch (SQLException ex) {
                            if (!this.log.isDebug()) continue;
                            this.log.logDebug("Error closing query: " + Const.CR + sql);
                        }
                        continue;
                    }
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed("launch DDL statement: " + Const.CR + sql);
                }
                ++nrstats;
                Result res = this.execStatement(sql, params, data);
                result.add(res);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(nrstats + " statement" + (nrstats == 1 ? "" : "s") + " executed");
        }
        return result;
    }

    public ResultSet openQuery(String sql) throws HopDatabaseException {
        return this.openQuery(sql, null, null);
    }

    public ResultSet openQuery(String sql, IRowMeta params, Object[] data) throws HopDatabaseException {
        return this.openQuery(sql, params, data, 1000);
    }

    public ResultSet openQuery(String sql, IRowMeta params, Object[] data, int fetchMode) throws HopDatabaseException {
        return this.openQuery(sql, params, data, fetchMode, false);
    }

    public ResultSet openQuery(String sql, IRowMeta params, Object[] data, int fetchMode, boolean lazyConversion) throws HopDatabaseException {
        ResultSet res;
        try {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_OPEN_QUERY_START, this.databaseMeta.getName(), new long[0]);
            if (params != null) {
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_SQL_START, this.databaseMeta.getName(), new long[0]);
                this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1003, 1007);
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_SQL_VALUES_START, this.databaseMeta.getName(), new long[0]);
                this.setValues(params, data);
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_SQL_VALUES_STOP, this.databaseMeta.getName(), new long[0]);
                if (this.canWeSetFetchSize(this.pstmt)) {
                    int fs;
                    int maxRows = this.pstmt.getMaxRows();
                    int n = fs = 10000 <= maxRows ? maxRows : 10000;
                    if (this.databaseMeta.isMySqlVariant()) {
                        this.setMysqlFetchSize(this.pstmt, fs, maxRows);
                    } else {
                        this.pstmt.setFetchSize(fs);
                    }
                    this.pstmt.setFetchDirection(fetchMode);
                }
                if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                    this.pstmt.setMaxRows(this.rowlimit);
                }
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_EXECUTE_SQL_START, this.databaseMeta.getName(), new long[0]);
                res = this.pstmt.executeQuery();
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_EXECUTE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
            } else {
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_CREATE_SQL_START, this.databaseMeta.getName(), new long[0]);
                this.selStmt = this.connection.createStatement();
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_CREATE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
                if (this.canWeSetFetchSize(this.selStmt)) {
                    int fs;
                    int n = fs = 10000 <= this.selStmt.getMaxRows() ? this.selStmt.getMaxRows() : 10000;
                    if (this.databaseMeta.getIDatabase().isMySqlVariant() && this.databaseMeta.isStreamingResults()) {
                        this.selStmt.setFetchSize(Integer.MIN_VALUE);
                    } else {
                        this.selStmt.setFetchSize(fs);
                    }
                    this.selStmt.setFetchDirection(fetchMode);
                }
                if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                    this.selStmt.setMaxRows(this.rowlimit);
                }
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_EXECUTE_SQL_START, this.databaseMeta.getName(), new long[0]);
                res = this.selStmt.executeQuery(this.databaseMeta.stripCR(sql));
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_EXECUTE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
            }
            this.rowMeta = this.getRowInfo(res.getMetaData(), this.databaseMeta.isMySqlVariant(), lazyConversion);
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("An error occurred executing SQL: " + Const.CR + sql, ex);
        }
        catch (Exception e) {
            throw new HopDatabaseException("An error occurred executing SQL:" + Const.CR + sql, e);
        }
        finally {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_OPEN_QUERY_STOP, this.databaseMeta.getName(), new long[0]);
        }
        return res;
    }

    private boolean canWeSetFetchSize(Statement statement) throws SQLException {
        return this.databaseMeta.isFetchSizeSupported() && (statement.getMaxRows() > 0 || this.databaseMeta.getIDatabase().isPostgresVariant() || this.databaseMeta.isMySqlVariant() && this.databaseMeta.isStreamingResults());
    }

    public ResultSet openQuery(PreparedStatement ps, IRowMeta params, Object[] data) throws HopDatabaseException {
        ResultSet res;
        try {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_OPEN_QUERY_START, this.databaseMeta.getName(), new long[0]);
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_SQL_VALUES_START, this.databaseMeta.getName(), new long[0]);
            this.setValues(params, data, ps);
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_SQL_VALUES_STOP, this.databaseMeta.getName(), new long[0]);
            if (this.canWeSetFetchSize(ps)) {
                int fs;
                int maxRows = ps.getMaxRows();
                int n = fs = 10000 <= maxRows ? maxRows : 10000;
                if (this.databaseMeta.isMySqlVariant()) {
                    this.setMysqlFetchSize(ps, fs, maxRows);
                } else {
                    ps.setFetchSize(fs);
                }
                ps.setFetchDirection(1000);
            }
            if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                ps.setMaxRows(this.rowlimit);
            }
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_EXECUTE_SQL_START, this.databaseMeta.getName(), new long[0]);
            res = ps.executeQuery();
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_EXECUTE_SQL_STOP, this.databaseMeta.getName(), new long[0]);
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_META_START, this.databaseMeta.getName(), new long[0]);
            this.rowMeta = this.getRowInfo(res.getMetaData(), this.databaseMeta.isMySqlVariant(), false);
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_META_STOP, this.databaseMeta.getName(), new long[0]);
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("ERROR executing query", ex);
        }
        catch (Exception e) {
            throw new HopDatabaseException("ERROR executing query", e);
        }
        finally {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_OPEN_QUERY_STOP, this.databaseMeta.getName(), new long[0]);
        }
        return res;
    }

    void setMysqlFetchSize(PreparedStatement ps, int fs, int getMaxRows) throws SQLException, HopDatabaseException {
        if (this.databaseMeta.isStreamingResults() && this.getDatabaseMetaData().getDriverMajorVersion() == 3) {
            ps.setFetchSize(Integer.MIN_VALUE);
        } else if (fs <= getMaxRows) {
            ps.setFetchSize(fs);
        }
    }

    public IRowMeta getTableFields(String tableName) throws HopDatabaseException {
        return this.getQueryFields(this.databaseMeta.getSqlQueryFields(tableName), false);
    }

    public IRowMeta getQueryFields(String sql, boolean param) throws HopDatabaseException {
        return this.getQueryFields(sql, param, null, null);
    }

    private boolean checkTableExists(String tableName) throws HopDatabaseException {
        try {
            if (this.log.isDebug()) {
                this.log.logDebug("Checking if table [" + tableName + "] exists!");
            }
            String sql = this.databaseMeta.getSqlTableExists(tableName);
            try {
                this.getOneRow(sql);
                return true;
            }
            catch (HopDatabaseException e) {
                return false;
            }
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unable to check if table [" + tableName + "] exists on connection [" + this.databaseMeta.getName() + "]", e);
        }
    }

    public boolean checkTableExists(String schema, String tableName) throws HopDatabaseException {
        return this.checkTableExists(this.databaseMeta.getQuotedSchemaTableCombination(this, schema, tableName));
    }

    public boolean checkColumnExists(String schemaname, String tableName, String columnName) throws HopDatabaseException {
        return this.checkColumnExists(this.databaseMeta.quoteField(columnName), this.databaseMeta.getQuotedSchemaTableCombination(this, schemaname, tableName));
    }

    private boolean checkColumnExists(String columnName, String tableName) throws HopDatabaseException {
        try {
            if (this.log.isDebug()) {
                this.log.logDebug("Checking if column [" + columnName + "] exists in table [" + tableName + "] !");
            }
            String sql = this.databaseMeta.getSqlColumnExists(columnName, tableName);
            try {
                this.getOneRow(sql);
                return true;
            }
            catch (HopDatabaseException e) {
                return false;
            }
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unable to check if column [" + columnName + "] exists in table [" + tableName + "] on connection [" + this.databaseMeta.getName() + "]", e);
        }
    }

    public boolean checkSequenceExists(String sequenceName) throws HopDatabaseException {
        return this.checkSequenceExists(null, sequenceName);
    }

    public boolean checkSequenceExists(String schemaName, String sequenceName) throws HopDatabaseException {
        boolean retval = false;
        if (!this.databaseMeta.supportsSequences()) {
            return retval;
        }
        String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, sequenceName);
        try {
            String sql = this.databaseMeta.getSqlSequenceExists(schemaSequence);
            ResultSet res = this.openQuery(sql);
            if (res != null) {
                Object[] row = this.getRow(res);
                if (row != null) {
                    retval = true;
                }
                this.closeQuery(res);
            }
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unexpected error checking whether or not sequence [" + schemaSequence + "] exists", e);
        }
        return retval;
    }

    public boolean checkIndexExists(String tableName, String[] idxFields) throws HopDatabaseException {
        return this.checkIndexExists(null, tableName, idxFields);
    }

    public boolean checkIndexExists(String schemaName, String tableName, String[] idxFields) throws HopDatabaseException {
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, tableName);
        if (!this.checkTableExists(schemaTable)) {
            return false;
        }
        if (this.log.isDebug()) {
            this.log.logDebug("CheckIndexExists() table = " + schemaTable + " type = " + this.databaseMeta.getPluginId());
        }
        return this.databaseMeta.getIDatabase().hasIndex(this, schemaName, schemaTable, idxFields);
    }

    public String getCreateIndexStatement(String tableName, String indexname, String[] idxFields, boolean tk, boolean unique, boolean bitmap, boolean semiColon) {
        return this.getCreateIndexStatement(null, tableName, indexname, idxFields, tk, unique, bitmap, semiColon);
    }

    public String getCreateIndexStatement(String schemaname, String tableName, String indexname, String[] idxFields, boolean tk, boolean unique, boolean bitmap, boolean semiColon) {
        StringBuilder crIndex = new StringBuilder();
        IDatabase iDatabase = this.databaseMeta.getIDatabase();
        if (iDatabase.isExasolVariant()) {
            return "";
        }
        crIndex.append("CREATE ");
        if (unique || tk && iDatabase.isSybaseVariant()) {
            crIndex.append("UNIQUE ");
        }
        if (bitmap && this.databaseMeta.supportsBitmapIndex()) {
            crIndex.append("BITMAP ");
        }
        crIndex.append("INDEX ").append(this.databaseMeta.quoteField(indexname)).append(" ");
        crIndex.append("ON ");
        crIndex.append(tableName);
        crIndex.append("(");
        for (int i = 0; i < idxFields.length; ++i) {
            if (i > 0) {
                crIndex.append(", ");
            }
            crIndex.append(this.databaseMeta.quoteField(idxFields[i]));
        }
        crIndex.append(")").append(Const.CR);
        crIndex.append(iDatabase.getIndexTablespaceDDL(this.variables, this.databaseMeta));
        if (semiColon) {
            crIndex.append(";").append(Const.CR);
        }
        return crIndex.toString();
    }

    public String getCreateSequenceStatement(String sequence, long startAt, long incrementBy, long maxValue, boolean semiColon) {
        return this.getCreateSequenceStatement(null, sequence, Long.toString(startAt), Long.toString(incrementBy), Long.toString(maxValue), semiColon);
    }

    public String getCreateSequenceStatement(String sequence, String startAt, String incrementBy, String maxValue, boolean semiColon) {
        return this.getCreateSequenceStatement(null, sequence, startAt, incrementBy, maxValue, semiColon);
    }

    public String getCreateSequenceStatement(String schemaName, String sequence, long startAt, long incrementBy, long maxValue, boolean semiColon) {
        return this.getCreateSequenceStatement(schemaName, sequence, Long.toString(startAt), Long.toString(incrementBy), Long.toString(maxValue), semiColon);
    }

    public String getCreateSequenceStatement(String schemaName, String sequenceName, String startAt, String incrementBy, String maxValue, boolean semiColon) {
        Object crSeq = "";
        if (Utils.isEmpty(sequenceName)) {
            return crSeq;
        }
        if (this.databaseMeta.supportsSequences()) {
            String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, sequenceName);
            crSeq = (String)crSeq + "CREATE SEQUENCE " + schemaSequence + " " + Const.CR;
            crSeq = (String)crSeq + "START WITH " + startAt + " " + Const.CR;
            crSeq = (String)crSeq + "INCREMENT BY " + incrementBy + " " + Const.CR;
            if (maxValue != null) {
                if (this.databaseMeta.supportsSequenceNoMaxValueOption() && maxValue.trim().equals("-1")) {
                    IDatabase iDatabase = this.databaseMeta.getIDatabase();
                    crSeq = (String)crSeq + iDatabase.getSequenceNoMaxValueOption() + Const.CR;
                } else {
                    crSeq = (String)crSeq + "MAXVALUE " + maxValue + Const.CR;
                }
            }
            if (semiColon) {
                crSeq = (String)crSeq + ";" + Const.CR;
            }
        }
        return crSeq;
    }

    public IRowMeta getTableFieldsMeta(String schemaName, String tableName) throws HopDatabaseException {
        String tableSchema = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, tableName);
        String sql = this.databaseMeta.getSqlQueryFields(tableSchema);
        return this.getQueryFields(sql, false);
    }

    public IRowMeta getQueryFields(String sql, boolean param, IRowMeta inform, Object[] data) throws HopDatabaseException {
        DbCacheEntry entry;
        DbCache dbcache;
        IRowMeta fields;
        block12: {
            fields = null;
            dbcache = DbCache.getInstance();
            entry = null;
            if (dbcache != null && (fields = dbcache.get(entry = new DbCacheEntry(this.databaseMeta.getName(), sql))) != null) {
                return fields;
            }
            if (this.connection == null) {
                return null;
            }
            boolean maybeScanTable = false;
            try {
                if (this.databaseMeta.supportsPreparedStatementMetadataRetrieval()) {
                    fields = this.getQueryFieldsFromPreparedStatement(sql);
                } else if (this.isDataServiceConnection()) {
                    fields = this.getQueryFieldsFromDatabaseMetaData(sql);
                } else {
                    maybeScanTable = true;
                    fields = this.getQueryFieldsFromDatabaseMetaData();
                }
            }
            catch (Exception e) {
                String fastFetchSql;
                if (maybeScanTable && (fastFetchSql = sql.replaceAll("\\b((?i)WHERE)\\b(\\s)", "$1 1=2 AND$2")).length() > sql.length()) {
                    try {
                        fields = this.getQueryFieldsFallback(sql, param, inform, data);
                    }
                    catch (HopDatabaseException hopDatabaseException) {
                        // empty catch block
                    }
                }
                if (fields != null) break block12;
                fields = this.getQueryFieldsFallback(sql, param, inform, data);
            }
        }
        if (dbcache != null && fields != null) {
            dbcache.put(entry, fields);
        }
        return fields;
    }

    private boolean isDataServiceConnection() {
        return DATA_SERVICES_PLUGIN_ID.equals(this.databaseMeta.getPluginId());
    }

    public IRowMeta getQueryFieldsFromPreparedStatement(String sql) throws Exception {
        Statement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1003, 1007);
            preparedStatement.setMaxRows(1);
            ResultSetMetaData rsmd = preparedStatement.getMetaData();
            IRowMeta iRowMeta = this.getRowInfo(rsmd, false, false);
            return iRowMeta;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    throw new HopDatabaseException("Unable to close prepared statement after determining SQL layout", e);
                }
            }
        }
    }

    public IRowMeta getQueryFieldsFromDatabaseMetaData() throws Exception {
        return this.getQueryFieldsFromDatabaseMetaData(null);
    }

    private IRowMeta getQueryFieldsFromDatabaseMetaData(String sql) throws Exception {
        ResultSet columns = this.connection.getMetaData().getColumns("", "", StringUtils.isNotBlank((String)sql) ? sql : this.databaseMeta.getName(), "");
        RowMeta rowMeta = new RowMeta();
        while (columns.next()) {
            ValueMetaBase valueMeta = null;
            String name = columns.getString("COLUMN_NAME");
            String comments = columns.getString("REMARKS");
            String type = columns.getString("SOURCE_DATA_TYPE");
            int size = columns.getInt("COLUMN_SIZE");
            if (type.equals("Integer") || type.equals("Long")) {
                valueMeta = new ValueMetaInteger();
            } else if (type.equals("BigDecimal") || type.equals("BigNumber")) {
                valueMeta = new ValueMetaBigNumber();
            } else if (type.equals("Double") || type.equals("Number")) {
                valueMeta = new ValueMetaNumber();
            } else if (type.equals("String")) {
                valueMeta = new ValueMetaString();
            } else if (type.equals("Date")) {
                valueMeta = new ValueMetaDate();
            } else if (type.equals("Boolean")) {
                valueMeta = new ValueMetaBoolean();
            } else if (type.equals("Binary")) {
                valueMeta = new ValueMetaBinary();
            } else if (type.equals("Timestamp")) {
                valueMeta = new ValueMetaTimestamp();
            } else if (type.equals("Internet Address")) {
                valueMeta = new ValueMetaInternetAddress();
            }
            if (valueMeta != null) {
                valueMeta.setName(name);
                valueMeta.setComments(comments);
                valueMeta.setLength(size);
                valueMeta.setOriginalColumnTypeName(type);
                valueMeta.setConversionMask(columns.getString("SOURCE_MASK"));
                valueMeta.setDecimalSymbol(columns.getString("SOURCE_DECIMAL_SYMBOL"));
                valueMeta.setGroupingSymbol(columns.getString("SOURCE_GROUPING_SYMBOL"));
                valueMeta.setCurrencySymbol(columns.getString("SOURCE_CURRENCY_SYMBOL"));
                rowMeta.addValueMeta(valueMeta);
                continue;
            }
            this.log.logBasic("Database.getQueryFields() IValueMeta mapping not resolved for the column " + name);
            rowMeta = null;
            break;
        }
        if (rowMeta != null && !rowMeta.isEmpty()) {
            return rowMeta;
        }
        throw new Exception("Error in Database.getQueryFields()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowMeta getQueryFieldsFallback(String sql, boolean param, IRowMeta inform, Object[] data) throws HopDatabaseException {
        IRowMeta fields;
        block22: {
            try {
                if (inform == null && this.databaseMeta.getIDatabase().isMsSqlServerVariant() || this.databaseMeta.getIDatabase().isSupportsResultSetMetadataRetrievalOnly()) {
                    this.selStmt = this.connection.createStatement(1003, 1007);
                    try {
                        if (this.databaseMeta.isFetchSizeSupported() && this.selStmt.getMaxRows() >= 1) {
                            if (this.databaseMeta.getIDatabase().isMySqlVariant()) {
                                this.selStmt.setFetchSize(Integer.MIN_VALUE);
                            } else {
                                this.selStmt.setFetchSize(1);
                            }
                        }
                        if (this.databaseMeta.supportsSetMaxRows()) {
                            this.selStmt.setMaxRows(1);
                        }
                        try (ResultSet r = this.selStmt.executeQuery(this.databaseMeta.stripCR(sql));){
                            fields = this.getRowInfo(r.getMetaData(), false, false);
                            break block22;
                        }
                    }
                    finally {
                        this.selStmt.close();
                        this.selStmt = null;
                    }
                }
                try (PreparedStatement ps = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));){
                    if (param) {
                        IRowMeta par = inform;
                        if (par == null || par.isEmpty()) {
                            par = this.getParameterMetaData(ps);
                        }
                        if (par == null || par.isEmpty()) {
                            par = this.getParameterMetaData(sql, inform, data);
                        }
                        this.setValues(par, data, ps);
                    }
                    try (ResultSet r = ps.executeQuery();){
                        ResultSetMetaData metadata = r.getMetaData();
                        fields = this.getRowInfo(metadata, false, false);
                    }
                }
            }
            catch (Exception ex) {
                throw new HopDatabaseException("Couldn't get field info from [" + sql + "]" + Const.CR, ex);
            }
        }
        return fields;
    }

    public void closeQuery(ResultSet res) throws HopDatabaseException {
        try {
            if (res != null) {
                res.close();
            }
            if (this.selStmt != null) {
                this.selStmt.close();
                this.selStmt = null;
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Couldn't close query: resultset or prepared statements", ex);
        }
    }

    private IRowMeta getRowInfo(ResultSetMetaData rm, boolean ignoreLength, boolean lazyConversion) throws HopDatabaseException {
        try {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_META_START, this.databaseMeta.getName(), new long[0]);
            if (rm == null) {
                throw new HopDatabaseException("No result set metadata available to retrieve row metadata!");
            }
            RowMeta rowMeta = new RowMeta();
            try {
                int nrcols = rm.getColumnCount();
                for (int i = 1; i <= nrcols; ++i) {
                    IValueMeta valueMeta = this.getValueFromSqlType(rm, i, ignoreLength, lazyConversion);
                    rowMeta.addValueMeta(valueMeta);
                }
                RowMeta rowMeta2 = rowMeta;
                return rowMeta2;
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Error getting row information from database: ", ex);
            }
        }
        finally {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_META_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    private IValueMeta getValueFromSqlType(ResultSetMetaData rm, int i, boolean ignoreLength, boolean lazyConversion) throws HopDatabaseException, SQLException {
        Object name = this.databaseMeta.isMySqlVariant() ? this.databaseMeta.getIDatabase().getLegacyColumnName(this.getDatabaseMetaData(), rm, i) : rm.getColumnName(i);
        if (Utils.isEmpty((CharSequence)name) || Const.onlySpaces((String)name)) {
            name = "Field" + (i + 1);
        }
        IValueMeta valueMeta = null;
        for (IValueMeta valueMetaClass : valueMetaPluginClasses) {
            IValueMeta v = valueMetaClass.getValueFromSqlType(this, this.databaseMeta, (String)name, rm, i, ignoreLength, lazyConversion);
            if (v == null) continue;
            valueMeta = v;
            break;
        }
        if (valueMeta != null) {
            return valueMeta;
        }
        throw new HopDatabaseException("Unable to handle database column '" + (String)name + "', on column index " + i + " : not a handled data type");
    }

    public boolean absolute(ResultSet rs, int position) throws HopDatabaseException {
        try {
            return rs.absolute(position);
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Unable to move resultset to position " + position, e);
        }
    }

    public boolean relative(ResultSet rs, int rows) throws HopDatabaseException {
        try {
            return rs.relative(rows);
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Unable to move the resultset forward " + rows + " rows", e);
        }
    }

    public void afterLast(ResultSet rs) throws HopDatabaseException {
        try {
            rs.afterLast();
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Unable to move resultset to after the last position", e);
        }
    }

    public void first(ResultSet rs) throws HopDatabaseException {
        try {
            rs.first();
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Unable to move resultset to the first position", e);
        }
    }

    public Object[] getRow(ResultSet rs) throws HopDatabaseException {
        return this.getRow(rs, false);
    }

    public Object[] getRow(ResultSet rs, boolean lazyConversion) throws HopDatabaseException {
        if (this.rowMeta == null) {
            ResultSetMetaData rsmd = null;
            try {
                rsmd = rs.getMetaData();
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Unable to retrieve metadata from resultset", e);
            }
            this.rowMeta = this.getRowInfo(rsmd, false, lazyConversion);
        }
        return this.getRow(rs, null, this.rowMeta);
    }

    public Object[] getRow(ResultSet rs, ResultSetMetaData dummy, IRowMeta rowInfo) throws HopDatabaseException {
        Object[] objectArray;
        block8: {
            long startTime = System.currentTimeMillis();
            try {
                int nrcols = rowInfo.size();
                Object[] data = RowDataUtil.allocateRowData(nrcols);
                if (rs.next()) {
                    for (int i = 0; i < nrcols; ++i) {
                        IValueMeta val = rowInfo.getValueMeta(i);
                        data[i] = this.databaseMeta.getValueFromResultSet(rs, val, i);
                    }
                } else {
                    data = null;
                }
                objectArray = data;
                if (!this.log.isGatheringMetrics()) break block8;
            }
            catch (Exception ex) {
                try {
                    throw new HopDatabaseException("Couldn't get row from result set", ex);
                }
                catch (Throwable throwable) {
                    if (this.log.isGatheringMetrics()) {
                        long time = System.currentTimeMillis() - startTime;
                        this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_SUM_TIME, this.databaseMeta.getName(), time);
                        this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_MIN_TIME, this.databaseMeta.getName(), time);
                        this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_MAX_TIME, this.databaseMeta.getName(), time);
                        this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_COUNT, this.databaseMeta.getName(), new long[0]);
                    }
                    throw throwable;
                }
            }
            long time = System.currentTimeMillis() - startTime;
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_SUM_TIME, this.databaseMeta.getName(), time);
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_MIN_TIME, this.databaseMeta.getName(), time);
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_MAX_TIME, this.databaseMeta.getName(), time);
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_ROW_COUNT, this.databaseMeta.getName(), new long[0]);
        }
        return objectArray;
    }

    public void printSqlException(SQLException ex) {
        this.log.logError("==> SQLException: ");
        while (ex != null) {
            this.log.logError("Message:   " + ex.getMessage());
            this.log.logError("SQLState:  " + ex.getSQLState());
            this.log.logError("ErrorCode: " + ex.getErrorCode());
            ex = ex.getNextException();
            this.log.logError("");
        }
    }

    public void setLookup(String table, String[] codes, String[] condition, String[] gets, String[] rename, String orderby) throws HopDatabaseException {
        this.setLookup(table, codes, condition, gets, rename, orderby, false);
    }

    public void setLookup(String schema, String table, String[] codes, String[] condition, String[] gets, String[] rename, String orderby) throws HopDatabaseException {
        this.setLookup(schema, table, codes, condition, gets, rename, orderby, false);
    }

    public void setLookup(String tableName, String[] codes, String[] condition, String[] gets, String[] rename, String orderby, boolean checkForMultipleResults) throws HopDatabaseException {
        this.setLookup(null, tableName, codes, condition, gets, rename, orderby, checkForMultipleResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookup(String schemaName, String tableName, String[] codes, String[] condition, String[] gets, String[] rename, String orderby, boolean checkForMultipleResults) throws HopDatabaseException {
        try {
            int i;
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_SET_LOOKUP_START, this.databaseMeta.getName(), new long[0]);
            String table = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, tableName);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            for (i = 0; i < gets.length; ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append(this.databaseMeta.quoteField(gets[i]));
                if (rename == null || rename[i] == null || gets[i].equalsIgnoreCase(rename[i])) continue;
                sql.append(" AS ").append(this.databaseMeta.quoteField(rename[i]));
            }
            sql.append(" FROM ").append(table).append(" WHERE ");
            for (i = 0; i < codes.length; ++i) {
                if (i != 0) {
                    sql.append(" AND ");
                }
                sql.append(this.databaseMeta.quoteField(codes[i]));
                if (CONST_BETWEEN.equalsIgnoreCase(condition[i])) {
                    sql.append(CONST_BETWEEN_AND);
                    continue;
                }
                if ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NULL".equalsIgnoreCase(condition[i])) {
                    sql.append(" ").append(condition[i]).append(" ");
                    continue;
                }
                sql.append(" ").append(condition[i]).append(" ? ");
            }
            if (!Utils.isEmpty(orderby)) {
                sql.append(" ORDER BY ").append(orderby);
            }
            try {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Setting preparedStatement to [" + String.valueOf(sql) + "]");
                }
                this.prepStatementLookup = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                if (!checkForMultipleResults && this.databaseMeta.supportsSetMaxRows()) {
                    this.prepStatementLookup.setMaxRows(1);
                }
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Unable to prepare statement for update [" + String.valueOf(sql) + "]", ex);
            }
        }
        finally {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_SET_LOOKUP_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    public boolean prepareUpdate(String table, String[] codes, String[] condition, String[] sets) {
        return this.prepareUpdate(null, table, codes, condition, sets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareUpdate(String schemaName, String tableName, String[] codes, String[] condition, String[] sets) {
        try {
            int i;
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_UPDATE_START, this.databaseMeta.getName(), new long[0]);
            StringBuilder sql = new StringBuilder(128);
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, tableName);
            sql.append(this.databaseMeta.getSqlUpdateStmt(schemaTable));
            for (i = 0; i < sets.length; ++i) {
                if (i != 0) {
                    sql.append(",   ");
                }
                sql.append(this.databaseMeta.quoteField(sets[i]));
                sql.append(" = ?").append(Const.CR);
            }
            sql.append("WHERE ");
            for (i = 0; i < codes.length; ++i) {
                if (i != 0) {
                    sql.append("AND   ");
                }
                sql.append(this.databaseMeta.quoteField(codes[i]));
                if (CONST_BETWEEN.equalsIgnoreCase(condition[i])) {
                    sql.append(CONST_BETWEEN_AND);
                    continue;
                }
                if ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NULL".equalsIgnoreCase(condition[i])) {
                    sql.append(' ').append(condition[i]).append(' ');
                    continue;
                }
                sql.append(' ').append(condition[i]).append(" ? ");
            }
            try {
                String s = sql.toString();
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Setting update preparedStatement to [" + s + "]");
                }
                this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(s));
            }
            catch (SQLException ex) {
                this.printSqlException(ex);
                boolean bl = false;
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_UPDATE_STOP, this.databaseMeta.getName(), new long[0]);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_UPDATE_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    public boolean prepareDelete(String table, String[] codes, String[] condition) {
        return this.prepareDelete(null, table, codes, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareDelete(String schemaName, String tableName, String[] codes, String[] condition) {
        try {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_DELETE_START, this.databaseMeta.getName(), new long[0]);
            StringBuilder sql = new StringBuilder();
            String table = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, tableName);
            sql.append(this.databaseMeta.getSqlDeleteStmt(table)).append(Const.CR);
            sql.append("WHERE ");
            for (int i = 0; i < codes.length; ++i) {
                if (i != 0) {
                    sql.append("AND   ");
                }
                sql.append(codes[i]);
                if (CONST_BETWEEN.equalsIgnoreCase(condition[i])) {
                    sql.append(CONST_BETWEEN_AND);
                    continue;
                }
                if ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NULL".equalsIgnoreCase(condition[i])) {
                    sql.append(" ").append(condition[i]).append(" ");
                    continue;
                }
                sql.append(" ").append(condition[i]).append(" ? ");
            }
            try {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Setting update preparedStatement to [" + String.valueOf(sql) + "]");
                }
                this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            }
            catch (SQLException ex) {
                this.printSqlException(ex);
                boolean bl = false;
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_DELETE_STOP, this.databaseMeta.getName(), new long[0]);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_DELETE_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcLookup(String proc, String[] arg, String[] argdir, int[] argtype, String returnvalue, int returntype) throws HopDatabaseException {
        try {
            int i;
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_DBPROC_START, this.databaseMeta.getName(), new long[0]);
            StringBuilder sql = new StringBuilder();
            int pos = 0;
            sql.append("{ ");
            if (!Utils.isEmpty(returnvalue)) {
                sql.append("? = ");
            }
            sql.append("call " + proc + " ");
            if (arg.length > 0) {
                sql.append("(");
            }
            for (i = 0; i < arg.length; ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append(" ?");
            }
            if (arg.length > 0) {
                sql.append(")");
            }
            sql.append("}");
            try {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("DBA setting callableStatement to [" + String.valueOf(sql) + "]");
                }
                this.cstmt = this.connection.prepareCall(sql.toString());
                pos = 1;
                if (!Utils.isEmpty(returnvalue)) {
                    switch (returntype) {
                        case 1: {
                            this.cstmt.registerOutParameter(pos, 8);
                            break;
                        }
                        case 6: {
                            this.cstmt.registerOutParameter(pos, 3);
                            break;
                        }
                        case 5: {
                            this.cstmt.registerOutParameter(pos, -5);
                            break;
                        }
                        case 2: {
                            this.cstmt.registerOutParameter(pos, 12);
                            break;
                        }
                        case 3: {
                            this.cstmt.registerOutParameter(pos, 93);
                            break;
                        }
                        case 4: {
                            this.cstmt.registerOutParameter(pos, 16);
                            break;
                        }
                    }
                    ++pos;
                }
                block22: for (i = 0; i < arg.length; ++i) {
                    if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase(CONST_INOUT)) continue;
                    switch (argtype[i]) {
                        case 1: {
                            this.cstmt.registerOutParameter(i + pos, 8);
                            continue block22;
                        }
                        case 6: {
                            this.cstmt.registerOutParameter(i + pos, 3);
                            continue block22;
                        }
                        case 5: {
                            this.cstmt.registerOutParameter(i + pos, -5);
                            continue block22;
                        }
                        case 2: {
                            this.cstmt.registerOutParameter(i + pos, 12);
                            continue block22;
                        }
                        case 3: {
                            this.cstmt.registerOutParameter(i + pos, 93);
                            continue block22;
                        }
                        case 4: {
                            this.cstmt.registerOutParameter(i + pos, 16);
                            continue block22;
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new HopDatabaseException("Unable to prepare database procedure call", ex);
            }
        }
        finally {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_PREPARE_DBPROC_STOP, this.databaseMeta.getName(), new long[0]);
        }
    }

    public Object[] getLookup() throws HopDatabaseException {
        return this.getLookup(this.prepStatementLookup, false);
    }

    public Object[] getLookup(boolean failOnMultipleResults) throws HopDatabaseException {
        return this.getLookup(failOnMultipleResults, false);
    }

    public Object[] getLookup(boolean failOnMultipleResults, boolean lazyConversion) throws HopDatabaseException {
        return this.getLookup(this.prepStatementLookup, failOnMultipleResults, lazyConversion);
    }

    public Object[] getLookup(PreparedStatement ps) throws HopDatabaseException {
        this.rowMeta = null;
        return this.getLookup(ps, false);
    }

    public Object[] getLookup(PreparedStatement ps, boolean failOnMultipleResults) throws HopDatabaseException {
        return this.getLookup(ps, failOnMultipleResults, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getLookup(PreparedStatement ps, boolean failOnMultipleResults, boolean lazyConversion) throws HopDatabaseException {
        ResultSet res = null;
        try {
            this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_LOOKUP_START, this.databaseMeta.getName(), new long[0]);
            res = ps.executeQuery();
            Object[] ret = this.getRow(res, lazyConversion);
            if (failOnMultipleResults && ret != null && res.next()) {
                throw new HopDatabaseException("Only 1 row was expected as a result of a lookup, and at least 2 were found!");
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Error looking up row in database", ex);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Unable to close resultset after looking up data", e);
            }
            finally {
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_LOOKUP_STOP, this.databaseMeta.getName(), new long[0]);
            }
        }
    }

    public DatabaseMetaData getDatabaseMetaData() throws HopDatabaseException {
        if (this.dbmd == null) {
            try {
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_DBMETA_START, this.databaseMeta.getName(), new long[0]);
                if (this.connection == null) {
                    throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.EmptyConnectionError", this.databaseMeta.getDatabaseName()));
                }
                this.dbmd = this.connection.getMetaData();
            }
            catch (Exception e) {
                throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToGetMetadata", new String[0]), e);
            }
            finally {
                this.log.snap((IMetrics)Metrics.METRIC_DATABASE_GET_DBMETA_STOP, this.databaseMeta.getName(), new long[0]);
            }
        }
        return this.dbmd;
    }

    public String getDDL(String tableName, IRowMeta fields) throws HopDatabaseException {
        return this.getDDL(tableName, fields, null, false, null, true);
    }

    public String getDDL(String tableName, IRowMeta fields, String tk, boolean useAutoIncrement, String pk) throws HopDatabaseException {
        return this.getDDL(tableName, fields, tk, useAutoIncrement, pk, true);
    }

    public String getDDL(String tableName, IRowMeta fields, String tk, boolean useAutoIncrement, String pk, boolean semicolon) throws HopDatabaseException {
        this.databaseMeta.quoteReservedWords(fields);
        String quotedTk = tk != null ? this.databaseMeta.quoteField(tk) : null;
        String retval = this.checkTableExists(tableName) ? this.getAlterTableStatement(tableName, fields, quotedTk, useAutoIncrement, pk, semicolon) : this.getCreateTableStatement(tableName, fields, quotedTk, useAutoIncrement, pk, semicolon);
        return retval;
    }

    public String getCreateTableStatement(String tableName, IRowMeta fields, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        StringBuilder retval = new StringBuilder();
        IDatabase iDatabase = this.databaseMeta.getIDatabase();
        retval.append(iDatabase.getCreateTableStatement());
        retval.append(tableName + Const.CR);
        retval.append("(").append(Const.CR);
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                retval.append(", ");
            } else {
                retval.append("  ");
            }
            IValueMeta v = fields.getValueMeta(i);
            retval.append(this.databaseMeta.getFieldDefinition(v, tk, pk, useAutoIncrement));
        }
        if (tk != null && this.databaseMeta.requiresCreateTablePrimaryKeyAppend()) {
            retval.append(", PRIMARY KEY (").append(tk).append(")").append(Const.CR);
        }
        if (pk != null && this.databaseMeta.requiresCreateTablePrimaryKeyAppend()) {
            retval.append(", PRIMARY KEY (").append(pk).append(")").append(Const.CR);
        }
        retval.append(")").append(Const.CR);
        retval.append(this.databaseMeta.getIDatabase().getDataTablespaceDDL(this.variables, this.databaseMeta));
        if (pk == null && tk == null && this.databaseMeta.getIDatabase().isNeoviewVariant()) {
            retval.append("NO PARTITION");
        }
        if (semicolon) {
            retval.append(";");
        }
        return retval.toString();
    }

    public String getAlterTableStatement(String tableName, IRowMeta fields, String tk, boolean useAutoIncrement, String pk, boolean semicolon) throws HopDatabaseException {
        int i;
        IValueMeta v;
        int i2;
        IValueMeta v2;
        int i3;
        StringBuilder retval = new StringBuilder();
        IRowMeta tabFields = this.getTableFields(tableName);
        this.databaseMeta.quoteReservedWords(tabFields);
        RowMeta missing = new RowMeta();
        for (i3 = 0; i3 < fields.size(); ++i3) {
            v2 = fields.getValueMeta(i3);
            if (tabFields.searchValueMeta(v2.getName()) != null) continue;
            missing.addValueMeta(v2);
        }
        if (!missing.isEmpty()) {
            for (i3 = 0; i3 < missing.size(); ++i3) {
                v2 = missing.getValueMeta(i3);
                retval.append(this.databaseMeta.getAddColumnStatement(tableName, v2, tk, useAutoIncrement, pk, true));
            }
        }
        RowMeta surplus = new RowMeta();
        for (i2 = 0; i2 < tabFields.size(); ++i2) {
            v = tabFields.getValueMeta(i2);
            if (fields.searchValueMeta(v.getName()) != null) continue;
            surplus.addValueMeta(v);
        }
        if (!surplus.isEmpty()) {
            for (i2 = 0; i2 < surplus.size(); ++i2) {
                v = surplus.getValueMeta(i2);
                retval.append(this.databaseMeta.getDropColumnStatement(tableName, v, tk, useAutoIncrement, pk, true));
            }
        }
        RowMeta modify = new RowMeta();
        for (i = 0; i < fields.size(); ++i) {
            String currentDDL;
            boolean mod;
            IValueMeta desiredField = fields.getValueMeta(i);
            IValueMeta currentField = tabFields.searchValueMeta(desiredField.getName());
            if (desiredField == null || currentField == null) continue;
            String desiredDDL = this.databaseMeta.getFieldDefinition(desiredField, tk, pk, useAutoIncrement);
            boolean bl = mod = !desiredDDL.equalsIgnoreCase(currentDDL = this.databaseMeta.getFieldDefinition(currentField, tk, pk, useAutoIncrement));
            if (!mod) continue;
            modify.addValueMeta(desiredField);
        }
        if (!modify.isEmpty()) {
            for (i = 0; i < modify.size(); ++i) {
                IValueMeta v3 = modify.getValueMeta(i);
                retval.append(this.databaseMeta.getModifyColumnStatement(tableName, v3, tk, useAutoIncrement, pk, true));
            }
        }
        return retval.toString();
    }

    public void truncateTable(String tableName) throws HopDatabaseException {
        if (Utils.isEmpty(this.connectionGroup)) {
            String truncateStatement = this.databaseMeta.getTruncateTableStatement(this, null, tableName);
            if (truncateStatement == null) {
                throw new HopDatabaseException(CONST_TRUNCATE_NOT_SUPPORTED + this.databaseMeta.getIDatabase().getPluginName());
            }
            this.execStatement(truncateStatement);
        } else {
            this.execStatement(this.databaseMeta.getSqlDeleteStmt(this.databaseMeta.quoteField(tableName)));
        }
    }

    public void truncateTable(String schema, String tableName) throws HopDatabaseException {
        if (Utils.isEmpty(this.connectionGroup)) {
            String truncateStatement = this.databaseMeta.getTruncateTableStatement(this, schema, tableName);
            if (truncateStatement == null) {
                throw new HopDatabaseException(CONST_TRUNCATE_NOT_SUPPORTED + this.databaseMeta.getIDatabase().getPluginName());
            }
            this.execStatement(truncateStatement);
        } else {
            this.execStatement(this.databaseMeta.getSqlDeleteStmt(this.databaseMeta.getQuotedSchemaTableCombination(this, schema, tableName)));
        }
    }

    public RowMetaAndData getOneRow(String sql) throws HopDatabaseException {
        ResultSet rs = this.openQuery(sql);
        if (rs != null) {
            Object[] row = this.getRow(rs);
            try {
                rs.close();
            }
            catch (Exception e) {
                throw new HopDatabaseException("Unable to close resultset", e);
            }
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (Exception e) {
                    throw new HopDatabaseException("Unable to close prepared statement pstmt", e);
                }
                this.pstmt = null;
            }
            if (this.selStmt != null) {
                try {
                    this.selStmt.close();
                }
                catch (Exception e) {
                    throw new HopDatabaseException("Unable to close prepared statement sel_stmt", e);
                }
                this.selStmt = null;
            }
            return new RowMetaAndData(this.rowMeta, row);
        }
        throw new HopDatabaseException("error opening resultset for query: " + sql);
    }

    public RowMeta getMetaFromRow(Object[] row, ResultSetMetaData md) throws SQLException, HopDatabaseException {
        RowMeta meta = new RowMeta();
        for (int i = 0; i < md.getColumnCount(); ++i) {
            IValueMeta valueMeta = this.getValueFromSqlType(md, i + 1, true, false);
            meta.addValueMeta(valueMeta);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowMetaAndData getOneRow(String sql, IRowMeta param, Object[] data) throws HopDatabaseException {
        ResultSet rs = this.openQuery(sql, param, data);
        if (rs != null) {
            Object[] row = this.getRow(rs);
            this.rowMeta = null;
            RowMeta tmpMeta = null;
            try {
                ResultSetMetaData md = rs.getMetaData();
                tmpMeta = this.getMetaFromRow(row, md);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.log.logError("Unable to close resultset", e);
                }
                if (this.pstmt != null) {
                    try {
                        this.pstmt.close();
                    }
                    catch (Exception e) {
                        this.log.logError("Unable to close prepared statement pstmt", e);
                    }
                    this.pstmt = null;
                }
                if (this.selStmt != null) {
                    try {
                        this.selStmt.close();
                    }
                    catch (Exception e) {
                        this.log.logError("Unable to close prepared statement sel_stmt", e);
                    }
                    this.selStmt = null;
                }
            }
            return new RowMetaAndData(tmpMeta, row);
        }
        return null;
    }

    public IRowMeta getParameterMetaData(PreparedStatement ps) {
        RowMeta par = new RowMeta();
        try {
            ParameterMetaData pmd = ps.getParameterMetaData();
            for (int i = 1; i <= pmd.getParameterCount(); ++i) {
                String name = "par" + i;
                int sqltype = pmd.getParameterType(i);
                int length = pmd.getPrecision(i);
                int precision = pmd.getScale(i);
                ValueMetaBase val = switch (sqltype) {
                    case 1, 12 -> new ValueMetaString(name);
                    case -6, -5, 2, 4, 5 -> new ValueMetaInteger(name);
                    case 3, 6, 7, 8 -> new ValueMetaNumber(name);
                    case 91, 92, 93 -> new ValueMetaDate(name);
                    case -7, 16 -> new ValueMetaBoolean(name);
                    default -> new ValueMetaNone(name);
                };
                if (val.isNumeric() && (length > 18 || precision > 18)) {
                    val = new ValueMetaBigNumber(name);
                }
                par.addValueMeta(val);
            }
        }
        catch (AbstractMethodError | Exception e) {
            return null;
        }
        return par;
    }

    public int countParameters(String sql) {
        int q = 0;
        boolean quoteOpened = false;
        boolean dquoteOpened = false;
        block5: for (int x = 0; x < sql.length(); ++x) {
            char c = sql.charAt(x);
            switch (c) {
                case '\'': {
                    quoteOpened = !quoteOpened;
                    continue block5;
                }
                case '\"': {
                    dquoteOpened = !dquoteOpened;
                    continue block5;
                }
                case '?': {
                    if (quoteOpened || dquoteOpened) continue block5;
                    ++q;
                    continue block5;
                }
            }
        }
        return q;
    }

    public IRowMeta getParameterMetaData(String sql, IRowMeta inform, Object[] data) {
        int q = this.countParameters(sql);
        RowMeta par = new RowMeta();
        if (inform != null && q == inform.size()) {
            for (int i = 0; i < q; ++i) {
                IValueMeta inf = inform.getValueMeta(i);
                IValueMeta v = inf.clone();
                par.addValueMeta(v);
            }
        } else {
            for (int i = 0; i < q; ++i) {
                ValueMetaNumber v = new ValueMetaNumber("name" + i);
                par.addValueMeta(v);
            }
        }
        return par;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Long getNextValue(String schemaName, String tableName, String valKey) throws HopDatabaseException {
        long previous;
        Long nextValue = null;
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, tableName);
        String lookup = schemaTable + "." + this.databaseMeta.quoteField(valKey);
        Counter counter = Counters.getInstance().getCounter(lookup);
        if (counter != null) return counter.getAndNext();
        RowMetaAndData rmad = this.getOneRow("SELECT MAX(" + this.databaseMeta.quoteField(valKey) + ") FROM " + schemaTable);
        if (rmad == null) throw new HopDatabaseException("Couldn't find maximum key value from table " + schemaTable);
        try {
            Long tmp = rmad.getRowMeta().getInteger(rmad.getData(), 0);
            previous = tmp != null ? tmp : 0L;
        }
        catch (HopValueException e) {
            throw new HopDatabaseException("Error getting the first long value from the max value returned from table : " + schemaTable);
        }
        counter = new Counter(previous + 1L, 1L);
        nextValue = counter.getAndNext();
        Counters.getInstance().setCounter(lookup, counter);
        return nextValue;
    }

    public String toString() {
        if (this.databaseMeta != null) {
            return this.databaseMeta.getName();
        }
        return "-";
    }

    public boolean isSystemTable(String tableName) {
        return this.databaseMeta.isSystemTable(tableName);
    }

    public List<Object[]> getRows(String sql, int limit) throws HopDatabaseException {
        return this.getRows(sql, limit, null);
    }

    public List<Object[]> getRows(String sql, int limit, IProgressMonitor monitor) throws HopDatabaseException {
        return this.getRows(sql, null, null, 1000, false, limit, monitor);
    }

    public List<Object[]> getRows(String sql, IRowMeta params, Object[] data, int fetchMode, boolean lazyConversion, int limit, IProgressMonitor monitor) throws HopDatabaseException {
        if (monitor != null) {
            monitor.setTaskName("Opening query...");
        }
        ResultSet rset = this.openQuery(sql, params, data, fetchMode, lazyConversion);
        return this.getRows(rset, limit, monitor);
    }

    public List<Object[]> getRows(ResultSet rset, int limit, IProgressMonitor monitor) throws HopDatabaseException {
        try {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            boolean stop = false;
            int i = 0;
            if (rset != null) {
                if (monitor != null && limit > 0) {
                    monitor.beginTask("Reading rows...", limit);
                }
                while (!(limit > 0 && i >= limit || stop)) {
                    Object[] row = this.getRow(rset);
                    if (row != null) {
                        result.add(row);
                        ++i;
                    } else {
                        stop = true;
                    }
                    if (monitor != null && limit > 0) {
                        monitor.worked(1);
                    }
                    if (monitor == null || !monitor.isCanceled()) continue;
                    break;
                }
                this.closeQuery(rset);
                if (monitor != null) {
                    monitor.done();
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unable to get list of rows from ResultSet : ", e);
        }
    }

    public List<Object[]> getFirstRows(String tableName, int limit) throws HopDatabaseException {
        return this.getFirstRows(tableName, limit, null);
    }

    public List<Object[]> getFirstRows(String tableName, int limit, IProgressMonitor monitor) throws HopDatabaseException {
        Object sql = "SELECT";
        if (this.databaseMeta.getIDatabase().isNeoviewVariant()) {
            sql = (String)sql + " [FIRST " + limit + "]";
        } else if (this.databaseMeta.getIDatabase().isSybaseIQVariant()) {
            sql = (String)sql + " TOP " + limit + " ";
        }
        sql = (String)sql + " * FROM " + tableName;
        if (limit > 0) {
            sql = (String)sql + this.databaseMeta.getLimitClause(limit);
        }
        return this.getRows((String)sql, limit, monitor);
    }

    public IRowMeta getReturnRowMeta() {
        return this.rowMeta;
    }

    public String[] getTableTypes() throws HopDatabaseException {
        try {
            ArrayList<String> types = new ArrayList<String>();
            ResultSet rstt = this.getDatabaseMetaData().getTableTypes();
            while (rstt.next()) {
                String ttype = rstt.getString("TABLE_TYPE");
                types.add(ttype);
            }
            return types.toArray(new String[types.size()]);
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Unable to get table types from database!", e);
        }
    }

    public String[] getTablenames() throws HopDatabaseException {
        return this.getTablenames(false);
    }

    public String[] getTablenames(boolean includeSchema) throws HopDatabaseException {
        return this.getTablenames(null, includeSchema);
    }

    public String[] getTablenames(String schemanamein, boolean includeSchema) throws HopDatabaseException {
        return this.getTablenames(schemanamein, includeSchema, null);
    }

    public String[] getTablenames(String schemanamein, boolean includeSchema, Map<String, String> props) throws HopDatabaseException {
        Map<String, Collection<String>> tableMap = this.getTableMap(schemanamein, props);
        ArrayList<String> res = new ArrayList<String>();
        for (String schema : tableMap.keySet()) {
            Collection<String> tables = tableMap.get(schema);
            for (String table : tables) {
                if (includeSchema) {
                    res.add(this.databaseMeta.getQuotedSchemaTableCombination(this, schema, table));
                    continue;
                }
                res.add(this.databaseMeta.getQuotedSchemaTableCombination(this, null, table));
            }
        }
        res.sort(String.CASE_INSENSITIVE_ORDER);
        return res.toArray(new String[res.size()]);
    }

    public Map<String, Collection<String>> getTableMap() throws HopDatabaseException {
        return this.getTableMap(null);
    }

    public Map<String, Collection<String>> getTableMap(String schemanamein) throws HopDatabaseException {
        return this.getTableMap(schemanamein, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Collection<String>> getTableMap(String schemanamein, Map<String, String> props) throws HopDatabaseException {
        String schemaname = schemanamein;
        if (schemaname == null && this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.resolve(this.databaseMeta.getUsername()).toUpperCase();
        }
        HashMap<String, Collection<String>> tableMap = new HashMap<String, Collection<String>>();
        ResultSet alltables = null;
        try {
            alltables = this.getDatabaseMetaData().getTables(null, schemaname, null, this.databaseMeta.getTableTypes());
            while (alltables.next()) {
                String schema;
                String cat;
                block24: {
                    block23: {
                        cat = "";
                        try {
                            cat = alltables.getString(CONST_TABLE_CAT);
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block23;
                            this.log.logDebug("Error getting tables for field TABLE_CAT (ignored): " + String.valueOf(e));
                        }
                    }
                    schema = "";
                    try {
                        schema = alltables.getString(CONST_TABLE_SCHEM);
                    }
                    catch (Exception e) {
                        if (!this.log.isDebug()) break block24;
                        this.log.logDebug("Error getting tables for field TABLE_SCHEM (ignored): " + String.valueOf(e));
                    }
                }
                if (Utils.isEmpty(schema)) {
                    schema = cat;
                }
                String table = alltables.getString(TABLES_META_DATA_TABLE_NAME);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), "got table from meta-data: " + this.databaseMeta.getQuotedSchemaTableCombination(this, schema, table));
                }
                if (!Utils.isEmpty(props)) {
                    for (Map.Entry<String, String> prop : props.entrySet()) {
                        String propValue;
                        String propName = prop.getKey();
                        String tableProperty = alltables.getString(propName);
                        if (tableProperty == null || !tableProperty.equals(propValue = prop.getValue())) continue;
                        this.multimapPut(schema, table, tableMap);
                    }
                    continue;
                }
                this.multimapPut(schema, table, tableMap);
            }
        }
        catch (SQLException e) {
            this.log.logError("Error getting tablenames from schema [" + schemaname + "]");
        }
        finally {
            try {
                if (alltables != null) {
                    alltables.close();
                }
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", e);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(CONST_READ + this.multimapSize(tableMap) + " table names from db meta-data.");
        }
        return tableMap;
    }

    public String[] getViews() throws HopDatabaseException {
        return this.getViews(false);
    }

    public String[] getViews(boolean includeSchema) throws HopDatabaseException {
        return this.getViews(null, includeSchema);
    }

    public String[] getViews(String schemanamein, boolean includeSchema) throws HopDatabaseException {
        Map<String, Collection<String>> viewMap = this.getViewMap(schemanamein);
        ArrayList<String> res = new ArrayList<String>();
        for (String schema : viewMap.keySet()) {
            Collection<String> views = viewMap.get(schema);
            for (String view : views) {
                if (includeSchema) {
                    res.add(this.databaseMeta.getQuotedSchemaTableCombination(this, schema, view));
                    continue;
                }
                res.add(view);
            }
        }
        res.sort(String.CASE_INSENSITIVE_ORDER);
        return res.toArray(new String[res.size()]);
    }

    public Map<String, Collection<String>> getViewMap() throws HopDatabaseException {
        return this.getViewMap(null);
    }

    public Map<String, Collection<String>> getViewMap(String schemanamein) throws HopDatabaseException {
        if (!this.databaseMeta.supportsViews()) {
            return Collections.emptyMap();
        }
        String schemaname = schemanamein;
        if (schemaname == null && this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.resolve(this.databaseMeta.getUsername()).toUpperCase();
        }
        HashMap<String, Collection<String>> viewMap = new HashMap<String, Collection<String>>();
        ResultSet allviews = null;
        try {
            allviews = this.getDatabaseMetaData().getTables(null, schemaname, null, this.databaseMeta.getViewTypes());
            while (allviews.next()) {
                String schema;
                String cat;
                block21: {
                    block20: {
                        cat = "";
                        try {
                            cat = allviews.getString(CONST_TABLE_CAT);
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block20;
                            this.log.logDebug("Error getting views for field TABLE_CAT (ignored): " + String.valueOf(e));
                        }
                    }
                    schema = "";
                    try {
                        schema = allviews.getString(CONST_TABLE_SCHEM);
                    }
                    catch (Exception e) {
                        if (!this.log.isDebug()) break block21;
                        this.log.logDebug("Error getting views for field TABLE_SCHEM (ignored): " + String.valueOf(e));
                    }
                }
                if (Utils.isEmpty(schema)) {
                    schema = cat;
                }
                String table = allviews.getString(TABLES_META_DATA_TABLE_NAME);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), "got view from meta-data: " + this.databaseMeta.getQuotedSchemaTableCombination(this, schema, table));
                }
                this.multimapPut(schema, table, viewMap);
            }
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Error getting views from schema [" + schemaname + "]", e);
        }
        finally {
            try {
                if (allviews != null) {
                    allviews.close();
                }
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", e);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(CONST_READ + this.multimapSize(viewMap) + " views from db meta-data.");
        }
        return viewMap;
    }

    public String[] getSynonyms() throws HopDatabaseException {
        return this.getSynonyms(false);
    }

    public String[] getSynonyms(boolean includeSchema) throws HopDatabaseException {
        return this.getSynonyms(null, includeSchema);
    }

    public String[] getSynonyms(String schemanamein, boolean includeSchema) throws HopDatabaseException {
        Map<String, Collection<String>> synonymMap = this.getSynonymMap(schemanamein);
        ArrayList<String> res = new ArrayList<String>();
        for (String schema : synonymMap.keySet()) {
            Collection<String> synonyms = synonymMap.get(schema);
            for (String synonym : synonyms) {
                if (includeSchema) {
                    res.add(this.databaseMeta.getQuotedSchemaTableCombination(this, schema, synonym));
                    continue;
                }
                res.add(synonym);
            }
        }
        res.sort(String.CASE_INSENSITIVE_ORDER);
        return res.toArray(new String[res.size()]);
    }

    public Map<String, Collection<String>> getSynonymMap() throws HopDatabaseException {
        return this.getSynonymMap(null);
    }

    public Map<String, Collection<String>> getSynonymMap(String schemanamein) throws HopDatabaseException {
        if (!this.databaseMeta.supportsSynonyms()) {
            return Collections.emptyMap();
        }
        String schemaname = schemanamein;
        if (schemaname == null && this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.resolve(this.databaseMeta.getUsername()).toUpperCase();
        }
        HashMap<String, Collection<String>> synonymMap = new HashMap<String, Collection<String>>();
        ResultSet alltables = null;
        try {
            alltables = this.getDatabaseMetaData().getTables(null, schemaname, null, this.databaseMeta.getSynonymTypes());
            while (alltables.next()) {
                String schema;
                String cat;
                block21: {
                    block20: {
                        cat = "";
                        try {
                            cat = alltables.getString(CONST_TABLE_CAT);
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block20;
                            this.log.logDebug("Error getting synonyms for field TABLE_CAT (ignored): " + String.valueOf(e));
                        }
                    }
                    schema = "";
                    try {
                        schema = alltables.getString(CONST_TABLE_SCHEM);
                    }
                    catch (Exception e) {
                        if (!this.log.isDebug()) break block21;
                        this.log.logDebug("Error getting synonyms for field TABLE_SCHEM (ignored): " + String.valueOf(e));
                    }
                }
                if (Utils.isEmpty(schema)) {
                    schema = cat;
                }
                String table = alltables.getString(TABLES_META_DATA_TABLE_NAME);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), "got synonym from meta-data: " + this.databaseMeta.getQuotedSchemaTableCombination(this, schema, table));
                }
                this.multimapPut(schema, table, synonymMap);
            }
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Error getting synonyms from schema [" + schemaname + "]", e);
        }
        finally {
            try {
                if (alltables != null) {
                    alltables.close();
                }
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Error closing resultset after getting synonyms from schema [" + schemaname + "]", e);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(CONST_READ + this.multimapSize(synonymMap) + " synonyms from db meta-data.");
        }
        return synonymMap;
    }

    private <K, V> void multimapPut(K key, V value, Map<K, Collection<V>> map) {
        Collection<V> valueCollection = map.get(key);
        if (valueCollection == null) {
            valueCollection = new HashSet<V>();
        }
        valueCollection.add(value);
        map.put(key, valueCollection);
    }

    private <K, V> int multimapSize(Map<K, Collection<V>> map) {
        int count = 0;
        for (Collection<V> valueCollection : map.values()) {
            count += valueCollection.size();
        }
        return count;
    }

    public String[] getSchemas() throws HopDatabaseException {
        ArrayList<String> catalogList = new ArrayList<String>();
        ResultSet catalogResultSet = null;
        try {
            catalogResultSet = this.getDatabaseMetaData().getSchemas();
            while (catalogResultSet != null && catalogResultSet.next()) {
                catalogList.add(catalogResultSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Error getting schemas!", e);
        }
        finally {
            try {
                if (catalogResultSet != null) {
                    catalogResultSet.close();
                }
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Error closing resultset after getting schemas!", e);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(CONST_READ + catalogList.size() + " schemas from db meta-data.");
        }
        return catalogList.toArray(new String[catalogList.size()]);
    }

    public String[] getCatalogs() throws HopDatabaseException {
        ArrayList<String> catalogList = new ArrayList<String>();
        ResultSet catalogResultSet = null;
        try {
            catalogResultSet = this.getDatabaseMetaData().getCatalogs();
            while (catalogResultSet != null && catalogResultSet.next()) {
                catalogList.add(catalogResultSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Error getting catalogs!", e);
        }
        finally {
            try {
                if (catalogResultSet != null) {
                    catalogResultSet.close();
                }
            }
            catch (SQLException e) {
                throw new HopDatabaseException("Error closing resultset after getting catalogs!", e);
            }
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(CONST_READ + catalogList.size() + " catalogs from db meta-data.");
        }
        return catalogList.toArray(new String[catalogList.size()]);
    }

    public String[] getProcedures() throws HopDatabaseException {
        String sql = this.databaseMeta.getSqlListOfProcedures();
        if (sql != null) {
            List<Object[]> procs = this.getRows(sql, 1000);
            String[] str = new String[procs.size()];
            for (int i = 0; i < procs.size(); ++i) {
                str[i] = procs.get(i)[0].toString();
            }
            return str;
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = this.getDatabaseMetaData();
            rs = dbmd.getProcedures(null, null, null);
            List<Object[]> rows = this.getRows(rs, 0, null);
            String[] result = new String[rows.size()];
            for (int i = 0; i < rows.size(); ++i) {
                Object[] row = rows.get(i);
                String procCatalog = this.rowMeta.getString(row, "PROCEDURE_CAT", null);
                String procSchema = this.rowMeta.getString(row, "PROCEDURE_SCHEM", null);
                String procName = this.rowMeta.getString(row, "PROCEDURE_NAME", "");
                StringBuilder name = new StringBuilder();
                if (procCatalog != null) {
                    name.append(procCatalog).append(".");
                }
                if (procSchema != null) {
                    name.append(procSchema).append(".");
                }
                name.append(procName);
                result[i] = name.toString();
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unable to get list of procedures from database meta-data: ", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isAutoCommit() {
        return this.commitsize <= 0;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void lockTables(String[] tableNames) throws HopDatabaseException {
        if (Utils.isEmpty(tableNames)) {
            return;
        }
        String sql = this.databaseMeta.getSqlLockTables(tableNames);
        if (sql != null) {
            this.execStatements(sql);
        }
    }

    public void unlockTables(String[] tableNames) throws HopDatabaseException {
        if (Utils.isEmpty(tableNames)) {
            return;
        }
        String[] quotedTableNames = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            quotedTableNames[i] = this.databaseMeta.getQuotedSchemaTableCombination(this, null, tableNames[i]);
        }
        String sql = this.databaseMeta.getSqlUnlockTables(quotedTableNames);
        if (sql != null) {
            this.execStatement(sql);
        }
    }

    public int getOpened() {
        return this.opened;
    }

    public synchronized void setOpened(int opened) {
        this.opened = opened;
    }

    public String getConnectionGroup() {
        return this.connectionGroup;
    }

    public void setConnectionGroup(String connectionGroup) {
        this.connectionGroup = connectionGroup;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }

    public int getCopy() {
        return this.copy;
    }

    public synchronized void setCopy(int copy) {
        this.copy = copy;
    }

    @Override
    public void copyFrom(IVariables variables) {
        variables.copyFrom(variables);
    }

    @Override
    public String resolve(String aString) {
        return this.variables.resolve(aString);
    }

    @Override
    public String[] resolve(String[] aString) {
        return this.variables.resolve(aString);
    }

    @Override
    public String resolve(String aString, IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        return this.variables.resolve(aString, rowMeta, rowData);
    }

    @Override
    public IVariables getParentVariables() {
        return this.variables.getParentVariables();
    }

    @Override
    public void setParentVariables(IVariables parent) {
        this.variables.setParentVariables(parent);
    }

    @Override
    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    @Override
    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    @Override
    public boolean getVariableBoolean(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty(variableName) && !Utils.isEmpty(value = this.resolve(variableName))) {
            return ValueMetaBase.convertStringToBoolean(value);
        }
        return defaultValue;
    }

    @Override
    public void initializeFrom(IVariables parent) {
        this.variables.initializeFrom(parent);
    }

    @Override
    public String[] getVariableNames() {
        return this.variables.getVariableNames();
    }

    @Override
    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    @Override
    public void shareWith(IVariables variables) {
        this.variables = variables;
    }

    @Override
    public void setVariables(Map<String, String> map) {
        this.variables.setVariables(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowMetaAndData callProcedure(String[] arg, String[] argdir, int[] argtype, String resultname, int resulttype) throws HopDatabaseException {
        try {
            boolean moreResults = this.cstmt.execute();
            RowMetaAndData ret = new RowMetaAndData();
            int pos = 1;
            if (!Utils.isEmpty(resultname)) {
                IValueMeta vMeta = ValueMetaFactory.createValueMeta(resultname, resulttype);
                Object v = null;
                switch (resulttype) {
                    case 4: {
                        v = this.cstmt.getBoolean(pos);
                        break;
                    }
                    case 1: {
                        v = this.cstmt.getDouble(pos);
                        break;
                    }
                    case 6: {
                        v = this.cstmt.getBigDecimal(pos);
                        break;
                    }
                    case 5: {
                        v = this.cstmt.getLong(pos);
                        break;
                    }
                    case 2: {
                        v = this.cstmt.getString(pos);
                        break;
                    }
                    case 8: {
                        if (this.databaseMeta.supportsGetBlob()) {
                            Blob blob = this.cstmt.getBlob(pos);
                            if (blob != null) {
                                v = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            v = null;
                            break;
                        }
                        v = this.cstmt.getBytes(pos);
                        break;
                    }
                    case 3: {
                        if (this.databaseMeta.supportsTimeStampToDateConversion()) {
                            v = this.cstmt.getTimestamp(pos);
                            break;
                        }
                        v = this.cstmt.getDate(pos);
                        break;
                    }
                }
                ret.addValue(vMeta, v);
                ++pos;
            }
            for (int i = 0; i < arg.length; ++i) {
                if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase(CONST_INOUT)) continue;
                IValueMeta vMeta = ValueMetaFactory.createValueMeta(arg[i], argtype[i]);
                Object v = null;
                switch (argtype[i]) {
                    case 4: {
                        v = this.cstmt.getBoolean(pos + i);
                        break;
                    }
                    case 1: {
                        v = this.cstmt.getDouble(pos + i);
                        break;
                    }
                    case 6: {
                        v = this.cstmt.getBigDecimal(pos + i);
                        break;
                    }
                    case 5: {
                        v = this.cstmt.getLong(pos + i);
                        break;
                    }
                    case 2: {
                        v = this.cstmt.getString(pos + i);
                        break;
                    }
                    case 8: {
                        if (this.databaseMeta.supportsGetBlob()) {
                            Blob blob = this.cstmt.getBlob(pos + i);
                            if (blob != null) {
                                v = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            v = null;
                            break;
                        }
                        v = this.cstmt.getBytes(pos + i);
                        break;
                    }
                    case 3: {
                        if (this.databaseMeta.supportsTimeStampToDateConversion()) {
                            v = this.cstmt.getTimestamp(pos + i);
                            break;
                        }
                        v = this.cstmt.getDate(pos + i);
                        break;
                    }
                }
                ret.addValue(vMeta, v);
            }
            ResultSet rs = null;
            int updateCount = -1;
            do {
                rs = null;
                try {
                    if (moreResults) {
                        rs = this.cstmt.getResultSet();
                    } else {
                        updateCount = this.cstmt.getUpdateCount();
                    }
                    moreResults = this.cstmt.getMoreResults();
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
            } while (moreResults || updateCount > -1);
            return ret;
        }
        catch (Exception ex) {
            throw new HopDatabaseException("Unable to call procedure", ex);
        }
    }

    public void closeProcedureStatement() throws HopDatabaseException {
        try {
            if (this.cstmt != null) {
                this.cstmt.close();
                this.cstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.ErrorClosingCallableStatement", new String[0]), ex);
        }
    }

    public String getDDLCreationTable(String tableName, IRowMeta fields) {
        this.databaseMeta.quoteReservedWords(fields);
        String quotedTk = this.databaseMeta.quoteField(null);
        String retval = this.getCreateTableStatement(tableName, fields, quotedTk, false, null, true);
        return retval;
    }

    public String getDDLTruncateTable(String schema, String tableName) throws HopDatabaseException {
        if (Utils.isEmpty(this.connectionGroup)) {
            String truncateStatement = this.databaseMeta.getTruncateTableStatement(this, schema, tableName);
            if (truncateStatement == null) {
                throw new HopDatabaseException(CONST_TRUNCATE_NOT_SUPPORTED + this.databaseMeta.getIDatabase().getPluginName());
            }
            return truncateStatement;
        }
        return this.databaseMeta.getSqlDeleteStmt(this.databaseMeta.getQuotedSchemaTableCombination(this, schema, tableName));
    }

    public String getSqlOutput(String schemaName, String tableName, IRowMeta fields, Object[] r, String dateFormat) throws HopDatabaseException {
        StringBuilder ins = new StringBuilder(128);
        try {
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this, schemaName, tableName);
            ins.append("INSERT INTO ").append(schemaTable).append('(');
            for (int i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    ins.append(", ");
                }
                String name = fields.getValueMeta(i).getName();
                ins.append(this.databaseMeta.quoteField(name));
            }
            ins.append(") VALUES (");
            SimpleDateFormat[] fieldDateFormatters = new SimpleDateFormat[fields.size()];
            block9: for (int i = 0; i < fields.size(); ++i) {
                IValueMeta valueMeta = fields.getValueMeta(i);
                Object valueData = r[i];
                if (i > 0) {
                    ins.append(",");
                }
                if (valueMeta.isNull(valueData)) {
                    ins.append("null");
                    continue;
                }
                switch (valueMeta.getType()) {
                    case 2: 
                    case 4: {
                        String string = valueMeta.getString(valueData);
                        string = this.databaseMeta.quoteSqlString(string);
                        ins.append(string);
                        continue block9;
                    }
                    case 3: {
                        Date date = fields.getDate(r, i);
                        if (Utils.isEmpty(dateFormat)) {
                            if (this.databaseMeta.getIDatabase().isOracleVariant()) {
                                if (fieldDateFormatters[i] == null) {
                                    fieldDateFormatters[i] = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                }
                                ins.append("TO_DATE('").append(fieldDateFormatters[i].format(date)).append("', 'YYYY/MM/DD HH24:MI:SS')");
                                continue block9;
                            }
                            ins.append("'").append(fields.getString(r, i)).append("'");
                            continue block9;
                        }
                        try {
                            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                            ins.append("'").append(formatter.format(fields.getDate(r, i))).append("'");
                            continue block9;
                        }
                        catch (Exception e) {
                            throw new HopDatabaseException("Error : ", e);
                        }
                    }
                    default: {
                        ins.append(fields.getString(r, i));
                    }
                }
            }
            ins.append(')');
        }
        catch (Exception e) {
            throw new HopDatabaseException(e);
        }
        return ins.toString();
    }

    public Savepoint setSavepoint() throws HopDatabaseException {
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException e) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToSetSavepoint", new String[0]), e);
        }
    }

    public Savepoint setSavepoint(String savePointName) throws HopDatabaseException {
        try {
            return this.connection.setSavepoint(savePointName);
        }
        catch (SQLException e) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToSetSavepointName", savePointName), e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws HopDatabaseException {
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToReleaseSavepoint", new String[0]), e);
        }
    }

    public void rollback(Savepoint savepoint) throws HopDatabaseException {
        try {
            this.connection.rollback(savepoint);
        }
        catch (SQLException e) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, "Database.Exception.UnableToRollbackToSavepoint", new String[0]), e);
        }
    }

    public Object getParentObject() {
        return this.parentLoggingObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPrimaryKeyColumnNames(String tableName) throws HopDatabaseException {
        ArrayList<String> names = new ArrayList<String>();
        ResultSet allkeys = null;
        try {
            allkeys = this.getDatabaseMetaData().getPrimaryKeys(null, null, tableName);
            while (allkeys.next()) {
                String keyname = allkeys.getString("PK_NAME");
                String colName = allkeys.getString("COLUMN_NAME");
                if (!names.contains(colName)) {
                    names.add(colName);
                }
                if (!this.log.isRowLevel()) continue;
                this.log.logRowlevel(this.toString(), "getting key : " + keyname + " on column " + colName);
            }
        }
        catch (SQLException e) {
            this.log.logError(this.toString(), "Error getting primary keys columns from table [" + tableName + "]");
        }
        finally {
            try {
                if (allkeys != null) {
                    allkeys.close();
                }
            }
            catch (SQLException e) {
                this.log.logError("Error closing connection while searching primary keys in table [" + tableName + "]", e);
            }
        }
        return names.toArray(new String[0]);
    }

    public String[] getSequences() throws HopDatabaseException {
        if (this.databaseMeta.supportsSequences()) {
            String sql = this.databaseMeta.getSqlListOfSequences();
            if (sql != null) {
                List<Object[]> seqs = this.getRows(sql, 0);
                String[] str = new String[seqs.size()];
                for (int i = 0; i < seqs.size(); ++i) {
                    str[i] = seqs.get(i)[0].toString();
                }
                return str;
            }
        } else {
            throw new HopDatabaseException("Sequences are only available for Oracle databases.");
        }
        return null;
    }

    @Override
    public String getFilename() {
        return null;
    }

    @Override
    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    @Override
    public String getObjectName() {
        return this.databaseMeta.getName();
    }

    @Override
    public String getObjectCopy() {
        return null;
    }

    @Override
    public LoggingObjectType getObjectType() {
        return LoggingObjectType.DATABASE;
    }

    @Override
    public ILoggingObject getParent() {
        return this.parentLoggingObject;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.log.setLogLevel(logLevel);
    }

    @Override
    public String getContainerId() {
        return this.containerObjectId;
    }

    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    @Override
    public Date getRegistrationDate() {
        return null;
    }

    public int getNrExecutedCommits() {
        return this.nrExecutedCommits;
    }

    public void setNrExecutedCommits(int nrExecutedCommits) {
        this.nrExecutedCommits = nrExecutedCommits;
    }

    public Result execStatementsFromFile(String filename, boolean sendSinglestatement) throws HopException {
        Result result;
        FileObject sqlFile = null;
        InputStream is = null;
        InputStreamReader bis = null;
        try {
            if (Utils.isEmpty(filename)) {
                throw new HopException("Filename is missing!");
            }
            sqlFile = HopVfs.getFileObject(filename);
            if (!sqlFile.exists()) {
                throw new HopException("We can not find file [" + filename + "]!");
            }
            is = HopVfs.getInputStream(sqlFile);
            bis = new InputStreamReader(new BufferedInputStream(is, 500));
            StringBuilder lineStringBuilder = new StringBuilder(256);
            lineStringBuilder.setLength(0);
            BufferedReader buff = new BufferedReader(bis);
            String sLine = null;
            StringBuilder sql = new StringBuilder();
            sql.append(Const.CR);
            while ((sLine = buff.readLine()) != null) {
                if (Utils.isEmpty(sLine)) {
                    sql.append(Const.CR);
                    continue;
                }
                sql.append(Const.CR).append(sLine);
            }
            if (sendSinglestatement) {
                Result result2 = this.execStatement(sql.toString());
                return result2;
            }
            result = this.execStatements(sql.toString());
        }
        catch (Exception e) {
            throw new HopException(e);
        }
        finally {
            try {
                if (sqlFile != null) {
                    sqlFile.close();
                }
                if (is != null) {
                    is.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public boolean isGatheringMetrics() {
        return this.log != null && this.log.isGatheringMetrics();
    }

    @Override
    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.log != null) {
            this.log.setGatheringMetrics(gatheringMetrics);
        }
    }

    @Override
    public boolean isForcingSeparateLogging() {
        return this.log != null && this.log.isForcingSeparateLogging();
    }

    @Override
    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.log != null) {
            this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    static {
        try {
            valueMetaPluginClasses = ValueMetaFactory.getValueMetaPluginClasses();
            Collections.sort(valueMetaPluginClasses, (o1, o2) -> Integer.valueOf(o1.getType()).compareTo(o2.getType()) * -1);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get list of instantiated value meta plugin classes", e);
        }
    }
}

