/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.setvariables;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopWorkflowException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@Action(id="SET_VARIABLES", name="i18n::ActionSetVariables.Name", description="i18n::ActionSetVariables.Description", image="SetVariables.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionSetVariables.keyword"}, documentationUrl="/workflow/actions/setvariables.html")
public class ActionSetVariables
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSetVariables.class;
    @HopMetadataProperty(key="replacevars")
    private boolean replaceVars;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<VariableDefinition> variableDefinitions;
    @HopMetadataProperty(key="filename")
    private String filename;
    @HopMetadataProperty(key="file_variable_type")
    private VariableType fileVariableType;

    public ActionSetVariables(String n) {
        super(n, "");
        this.replaceVars = true;
        this.fileVariableType = VariableType.CURRENT_WORKFLOW;
        this.variableDefinitions = new ArrayList<VariableDefinition>();
    }

    public ActionSetVariables() {
        this("");
    }

    public ActionSetVariables(ActionSetVariables other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
        this.filename = other.getFilename();
        this.fileVariableType = other.getFileVariableType();
        this.replaceVars = other.isReplaceVars();
        this.variableDefinitions = other.getVariableDefinitions();
    }

    public Object clone() {
        return new ActionSetVariables(this);
    }

    public Result execute(Result result, int nr) throws HopException {
        result.setResult(true);
        result.setNrErrors(0L);
        try {
            ArrayList<VariableDefinition> definitions = new ArrayList<VariableDefinition>();
            String realFilename = this.resolve(this.filename);
            if (!Utils.isEmpty((CharSequence)realFilename)) {
                try (InputStream is = HopVfs.getInputStream((String)realFilename);
                     InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                     BufferedReader reader = new BufferedReader(isr);){
                    Properties properties = new Properties();
                    properties.load(reader);
                    for (Object key : properties.keySet()) {
                        definitions.add(new VariableDefinition((String)key, (String)properties.get(key), this.fileVariableType));
                    }
                }
                catch (Exception e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionSetVariables.Error.UnableReadPropertiesFile", (String[])new String[]{realFilename}));
                }
            }
            definitions.addAll(this.variableDefinitions);
            if (this.parentWorkflow != null) {
                for (String key : this.getEntryTransformSetVariablesMap().keySet()) {
                    String parameterValue = this.parentWorkflow.getParameterValue(key);
                    if (parameterValue == null) {
                        this.parentWorkflow.setVariable(key, "");
                        this.setVariable(key, "");
                        continue;
                    }
                    this.parentWorkflow.setVariable(key, this.getEntryTransformSetVariable(key));
                    this.setVariable(key, this.getEntryTransformSetVariable(key));
                }
            }
            for (VariableDefinition definition : definitions) {
                String name = definition.getName();
                String value = definition.getValue();
                if (this.replaceVars) {
                    name = this.resolve(name);
                    value = this.resolve(value);
                }
                switch (definition.getType()) {
                    case JVM: {
                        if (value != null) {
                            System.setProperty(name, value);
                        } else {
                            System.clearProperty(name);
                        }
                        this.setVariable(name, value);
                        for (IWorkflowEngine parentWorkflowTraverse = this.parentWorkflow; parentWorkflowTraverse != null; parentWorkflowTraverse = parentWorkflowTraverse.getParentWorkflow()) {
                            parentWorkflowTraverse.setVariable(name, value);
                        }
                        break;
                    }
                    case ROOT_WORKFLOW: {
                        this.setVariable(name, value);
                        for (IWorkflowEngine rootWorkflow = this.parentWorkflow; rootWorkflow != null; rootWorkflow = rootWorkflow.getParentWorkflow()) {
                            rootWorkflow.setVariable(name, value);
                        }
                        break;
                    }
                    case CURRENT_WORKFLOW: {
                        this.setVariable(name, value);
                        if (this.parentWorkflow != null) {
                            String parameterValue = this.parentWorkflow.getParameterValue(name);
                            if (parameterValue == null) {
                                this.setEntryTransformSetVariable(name, value);
                            } else if (parameterValue != null && !parameterValue.equals(value) && !this.entryTransformSetVariablesMap.containsKey(name)) {
                                this.setEntryTransformSetVariable(name, parameterValue);
                            }
                            this.parentWorkflow.setVariable(name, value);
                            break;
                        }
                        throw new HopWorkflowException(BaseMessages.getString(PKG, (String)"ActionSetVariables.Error.UnableSetVariableCurrentWorkflow", (String[])new String[]{name}));
                    }
                    case PARENT_WORKFLOW: {
                        this.setVariable(name, value);
                        if (this.parentWorkflow != null) {
                            this.parentWorkflow.setVariable(name, value);
                            IWorkflowEngine gpWorkflow = this.parentWorkflow.getParentWorkflow();
                            if (gpWorkflow != null) {
                                gpWorkflow.setVariable(name, value);
                                break;
                            }
                            throw new HopWorkflowException(BaseMessages.getString(PKG, (String)"ActionSetVariables.Error.UnableSetVariableParentWorkflow", (String[])new String[]{name}));
                        }
                        throw new HopWorkflowException(BaseMessages.getString(PKG, (String)"ActionSetVariables.Error.UnableSetVariableCurrentWorkflow", (String[])new String[]{name}));
                    }
                }
                if (!this.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSetVariables.Log.SetVariableToValue", (String[])new String[]{name, value}));
            }
        }
        catch (Exception e) {
            result.setResult(false);
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"ActionSetVariables.UnExcpectedError", (String[])new String[]{e.getMessage()}));
        }
        return result;
    }

    public void setReplaceVars(boolean replaceVars) {
        this.replaceVars = replaceVars;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isReplaceVars() {
        return this.replaceVars;
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    public void setVariableDefinitions(List<VariableDefinition> variableDefinitions) {
        this.variableDefinitions = variableDefinitions;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "variableName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        String realFilename = this.resolve(this.filename);
        if (!Utils.isEmpty((CharSequence)realFilename)) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            references.add(reference);
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public VariableType getFileVariableType() {
        return this.fileVariableType;
    }

    public void setFileVariableType(VariableType scope) {
        this.fileVariableType = scope;
    }

    public static enum VariableType implements IEnumHasCodeAndDescription
    {
        JVM(BaseMessages.getString(PKG, (String)"ActionSetVariables.VariableType.JVM", (String[])new String[0])),
        CURRENT_WORKFLOW(BaseMessages.getString(PKG, (String)"ActionSetVariables.VariableType.CurrentWorkflow", (String[])new String[0])),
        PARENT_WORKFLOW(BaseMessages.getString(PKG, (String)"ActionSetVariables.VariableType.ParentWorkflow", (String[])new String[0])),
        ROOT_WORKFLOW(BaseMessages.getString(PKG, (String)"ActionSetVariables.VariableType.RootWorkflow", (String[])new String[0]));

        private final String description;

        private VariableType(String description) {
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(VariableType.class);
        }

        public static VariableType lookupDescription(String description) {
            return (VariableType)IEnumHasCodeAndDescription.lookupDescription(VariableType.class, (String)description, (IEnumHasCodeAndDescription)JVM);
        }

        public static VariableType lookupCode(String code) {
            return (VariableType)IEnumHasCode.lookupCode(VariableType.class, (String)code, (IEnumHasCode)JVM);
        }

        public String getCode() {
            return this.name();
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static final class VariableDefinition {
        @HopMetadataProperty(key="variable_name")
        private String name;
        @HopMetadataProperty(key="variable_value")
        private String value;
        @HopMetadataProperty(key="variable_type")
        private VariableType type;

        public VariableDefinition() {
        }

        public VariableDefinition(String name, String value, VariableType type) {
            this.name = name;
            this.value = value;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public VariableType getType() {
            return this.type;
        }

        public void setType(VariableType type) {
            this.type = type;
        }
    }
}

