/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInput;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputData;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputField;
import org.apache.hop.pipeline.transforms.excelinput.SpreadSheetType;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.staticschema.metadata.SchemaDefinition;
import org.apache.hop.staticschema.util.SchemaDefinitionUtil;

@Transform(id="ExcelInput", image="excelinput.svg", name="i18n::ExcelInput.Name", description="i18n::ExcelInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::ExcelInputMeta.keyword"}, documentationUrl="/pipeline/transforms/excelinput.html")
public class ExcelInputMeta
extends BaseTransformMeta<ExcelInput, ExcelInputData> {
    private static final Class<?> PKG = ExcelInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    @HopMetadataProperty(key="file", injectionGroupKey="FILENAME_LINES", injectionGroupDescription="ExcelInput.Injection.FILENAME_LINES", inlineListTags={"name", "filemask", "exclude_filemask", "file_required", "include_subfolders"})
    private List<EIFile> files;
    @HopMetadataProperty(key="filefield")
    private String fileField;
    @HopMetadataProperty(groupKey="sheets", key="sheet", injectionKey="SHEET", injectionKeyDescription="ExcelInput.Injection.SHEET", injectionGroupKey="SHEETS", injectionGroupDescription="ExcelInput.Injection.SHEETS")
    private List<EISheet> sheets;
    @HopMetadataProperty(key="sheetfield", injectionKeyDescription="Sheet name field")
    private String sheetField;
    @HopMetadataProperty(key="header", injectionKeyDescription="The cell-range starts with a header-row?")
    private boolean startsWithHeader;
    @HopMetadataProperty(key="schema_definition", injectionKeyDescription="The fields schema definition", hopMetadataPropertyType=HopMetadataPropertyType.STATIC_SCHEMA_DEFINITION)
    private String schemaDefinition;
    @HopMetadataProperty(key="ignore_fields", injectionKeyDescription="Ignore manual fields")
    private boolean ignoreFields;
    @HopMetadataProperty(key="stoponempty", injectionKeyDescription="Stop reading when you hit an empty row")
    private boolean stopOnEmpty;
    @HopMetadataProperty(key="noempty", injectionKeyDescription="Avoid empty rows in the result")
    private boolean ignoreEmptyRows;
    @HopMetadataProperty(key="rownumfield", injectionKeyDescription="The field name containing the row number.")
    private String rowNumberField;
    @HopMetadataProperty(key="sheetrownumfield", injectionKeyDescription="The field name containing the sheet row number")
    private String sheetRowNumberField;
    @HopMetadataProperty(key="limit", injectionKeyDescription="The maximum number of rows that this transform writes to the next transform")
    private long rowLimit;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionGroupDescription="ExcelInput.Injection.FIELDS")
    private List<ExcelInputField> fields = new ArrayList<ExcelInputField>();
    @HopMetadataProperty(key="strict_types", injectionKeyDescription="Strict types : data conversion errors are thrown")
    private boolean strictTypes;
    @HopMetadataProperty(key="error_ignored", injectionKeyDescription="Turn errors into warnings, ignoring them")
    private boolean errorIgnored;
    @HopMetadataProperty(key="error_line_skipped", injectionKeyDescription="Skip error lines?")
    private boolean errorLineSkipped;
    @HopMetadataProperty(key="bad_line_files_destination_directory", injectionKeyDescription="The directory that will contain warning files")
    private String warningFilesDestinationDirectory;
    @HopMetadataProperty(key="bad_line_files_extension", injectionKeyDescription="The extension of warning files")
    private String warningFilesExtension;
    @HopMetadataProperty(key="error_line_files_destination_directory", injectionKeyDescription="The directory that will contain error files")
    private String errorFilesDestinationDirectory;
    @HopMetadataProperty(key="error_line_files_extension", injectionKeyDescription="The extension of error files")
    private String errorFilesExtension;
    @HopMetadataProperty(key="line_number_files_destination_directory", injectionKeyDescription="The directory that will contain line number files")
    private String lineNumberFilesDestinationDirectory;
    @HopMetadataProperty(key="line_number_files_extension", injectionKeyDescription="The extension of line number files")
    private String lineNumberFilesExtension;
    @HopMetadataProperty(key="accept_filenames", injectionKeyDescription="Are we accepting filenames in input rows?")
    private boolean acceptingFilenames;
    @HopMetadataProperty(key="accept_field", injectionKeyDescription="The field in which the filename is placed")
    private String acceptingField;
    @HopMetadataProperty(key="accept_transform_name", injectionKeyDescription="The transform name to accept filenames from")
    private String acceptingTransformName;
    @HopMetadataProperty(key="encoding", injectionKeyDescription="The encoding to use for reading: null or empty string means system default encoding")
    private String encoding;
    @HopMetadataProperty(key="add_to_result_filenames", injectionKeyDescription="Add filenames to result?")
    private boolean addFilenamesToResult;
    @HopMetadataProperty(key="shortFileFieldName", injectionKeyDescription="Extra output: short file field name")
    private String shortFileFieldName;
    @HopMetadataProperty(key="pathFieldName", injectionKeyDescription="Extra output: path field name")
    private String pathFieldName;
    @HopMetadataProperty(key="hiddenFieldName", injectionKeyDescription="Extra output: hidden flag field name")
    private String hiddenFieldName;
    @HopMetadataProperty(key="lastModificationTimeFieldName", injectionKeyDescription="Extra output: last modification time field name")
    private String lastModificationTimeFieldName;
    @HopMetadataProperty(key="uriNameFieldName", injectionKeyDescription="Extra output: URI field name")
    private String uriNameFieldName;
    @HopMetadataProperty(key="rootUriNameFieldName", injectionKeyDescription="Extra output: root URI field name")
    private String rootUriNameFieldName;
    @HopMetadataProperty(key="extensionFieldName", injectionKeyDescription="Extra output: extension field name")
    private String extensionFieldName;
    @HopMetadataProperty(key="sizeFieldName", injectionKeyDescription="Extra output: file size field name")
    private String sizeFieldName;
    @HopMetadataProperty(enumNameWhenNotFound="POI", key="spreadsheet_type", injectionKey="SPREADSHEET_TYPE", injectionKeyDescription="ExcelInput.Injection.SPREADSHEET_TYPE")
    private SpreadSheetType spreadSheetType;

    public ExcelInputMeta() {
        this.files = new ArrayList<EIFile>();
        this.sheets = new ArrayList<EISheet>();
    }

    public ExcelInputMeta(ExcelInputMeta m) {
        this();
        m.fields.forEach(f -> this.fields.add(new ExcelInputField((ExcelInputField)f)));
        m.sheets.forEach(s -> this.sheets.add(new EISheet((EISheet)s)));
        m.files.forEach(f -> this.files.add(new EIFile((EIFile)f)));
        this.fileField = m.fileField;
        this.sheetField = m.sheetField;
        this.startsWithHeader = m.startsWithHeader;
        this.schemaDefinition = m.schemaDefinition;
        this.ignoreFields = m.ignoreFields;
        this.stopOnEmpty = m.stopOnEmpty;
        this.ignoreEmptyRows = m.ignoreEmptyRows;
        this.rowNumberField = m.rowNumberField;
        this.sheetRowNumberField = m.sheetRowNumberField;
        this.rowLimit = m.rowLimit;
        this.strictTypes = m.strictTypes;
        this.errorIgnored = m.errorIgnored;
        this.errorLineSkipped = m.errorLineSkipped;
        this.warningFilesDestinationDirectory = m.warningFilesDestinationDirectory;
        this.warningFilesExtension = m.warningFilesExtension;
        this.errorFilesDestinationDirectory = m.errorFilesDestinationDirectory;
        this.errorFilesExtension = m.errorFilesExtension;
        this.lineNumberFilesDestinationDirectory = m.lineNumberFilesDestinationDirectory;
        this.lineNumberFilesExtension = m.lineNumberFilesExtension;
        this.acceptingFilenames = m.acceptingFilenames;
        this.acceptingField = m.acceptingField;
        this.acceptingTransformName = m.acceptingTransformName;
        this.encoding = m.encoding;
        this.addFilenamesToResult = m.addFilenamesToResult;
        this.shortFileFieldName = m.shortFileFieldName;
        this.pathFieldName = m.pathFieldName;
        this.hiddenFieldName = m.hiddenFieldName;
        this.lastModificationTimeFieldName = m.lastModificationTimeFieldName;
        this.uriNameFieldName = m.uriNameFieldName;
        this.rootUriNameFieldName = m.rootUriNameFieldName;
        this.extensionFieldName = m.extensionFieldName;
        this.sizeFieldName = m.sizeFieldName;
        this.spreadSheetType = m.spreadSheetType;
    }

    public ExcelInputMeta clone() {
        return new ExcelInputMeta(this);
    }

    public void setDefault() {
        this.startsWithHeader = true;
        this.ignoreEmptyRows = true;
        this.rowNumberField = "";
        this.sheetRowNumberField = "";
        this.addFilenamesToResult = true;
        this.rowLimit = 0L;
        this.strictTypes = false;
        this.errorIgnored = false;
        this.errorLineSkipped = false;
        this.warningFilesDestinationDirectory = null;
        this.warningFilesExtension = "warning";
        this.errorFilesDestinationDirectory = null;
        this.errorFilesExtension = "error";
        this.lineNumberFilesDestinationDirectory = null;
        this.lineNumberFilesExtension = "line";
        this.spreadSheetType = SpreadSheetType.SAX_POI;
    }

    /*
     * Unable to fully structure code
     */
    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        row.clear();
        if (this.ignoreFields) {
            try {
                loadedSchemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(metadataProvider, this.getSchemaDefinition());
                if (loadedSchemaDefinition == null || (r = loadedSchemaDefinition.getRowMeta()) == null) ** GOTO lbl29
                for (i = 0; i < r.size(); ++i) {
                    row.addValueMeta(r.getValueMeta(i));
                }
            }
            catch (HopPluginException | HopTransformException loadedSchemaDefinition) {}
        } else {
            for (ExcelInputField field : this.fields) {
                type = field.getHopType();
                if (type == 0) {
                    type = 2;
                }
                try {
                    v = ValueMetaFactory.createValueMeta((String)field.getName(), (int)type);
                    v.setLength(field.getLength());
                    v.setPrecision(field.getPrecision());
                    v.setOrigin(name);
                    v.setConversionMask(field.getFormat());
                    v.setDecimalSymbol(field.getDecimalSymbol());
                    v.setGroupingSymbol(field.getGroupSymbol());
                    v.setCurrencySymbol(field.getCurrencySymbol());
                    row.addValueMeta(v);
                }
                catch (Exception e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
        }
lbl29:
        // 4 sources

        if (!Utils.isEmpty((CharSequence)this.fileField)) {
            v = new ValueMetaString(this.fileField);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.sheetField)) {
            v = new ValueMetaString(this.sheetField);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.sheetRowNumberField)) {
            v = new ValueMetaInteger(this.sheetRowNumberField);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.rowNumberField)) {
            v = new ValueMetaInteger(this.rowNumberField);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getShortFileFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getShortFileFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getExtensionFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getExtensionFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getPathFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getPathFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getSizeFieldName())) {
            v = new ValueMetaInteger(variables.resolve(this.getSizeFieldName()));
            v.setOrigin(name);
            v.setLength(9);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getHiddenFieldName())) {
            v = new ValueMetaBoolean(variables.resolve(this.getHiddenFieldName()));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getLastModificationTimeFieldName())) {
            v = new ValueMetaDate(variables.resolve(this.getLastModificationTimeFieldName()));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getUriNameFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getUriNameFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getRootUriNameFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getRootUriNameFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    private String[] getFilesNames() {
        String[] fileName = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            EIFile file = this.files.get(i);
            fileName[i] = file.getName();
        }
        return fileName;
    }

    private String[] getFilesMasks() {
        String[] fileMask = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            EIFile file = this.files.get(i);
            fileMask[i] = file.getMask();
        }
        return fileMask;
    }

    private String[] getFilesExcludeMasks() {
        String[] excludeFileMask = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            EIFile file = this.files.get(i);
            excludeFileMask[i] = file.getExcludeMask();
        }
        return excludeFileMask;
    }

    private String[] getFilesRequired() {
        String[] fileRequired = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            EIFile file = this.files.get(i);
            fileRequired[i] = file.getRequired();
        }
        return fileRequired;
    }

    private boolean[] getFilesIncludeSubFolders() {
        boolean[] includeSub = new boolean[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            EIFile file = this.files.get(i);
            includeSub[i] = Const.toBoolean((String)file.getIncludeSubFolders());
        }
        return includeSub;
    }

    public String[] getFilePaths(IVariables variables) {
        return FileInputList.createFilePathList((IVariables)variables, (String[])this.getFilesNames(), (String[])this.getFilesMasks(), (String[])this.getFilesExcludeMasks(), (String[])this.getFilesRequired(), (boolean[])this.getFilesIncludeSubFolders());
    }

    public FileInputList getFileList(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.getFilesNames(), (String[])this.getFilesMasks(), (String[])this.getFilesExcludeMasks(), (String[])this.getFilesRequired(), (boolean[])this.getFilesIncludeSubFolders());
    }

    public String[] getInfoTransforms() {
        return null;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.AcceptFilenamesOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.NoInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        FileInputList fileList = this.getFileList(variables);
        if (fileList.nrOfFiles() == 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + fileList.nrOfFiles()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getEmptyFields(IHopMetadataProvider metadataProvider) {
        RowMeta row = new RowMeta();
        if (this.ignoreFields) {
            try {
                IRowMeta r;
                SchemaDefinition loadedSchemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(metadataProvider, this.getSchemaDefinition());
                if (loadedSchemaDefinition == null || (r = loadedSchemaDefinition.getRowMeta()) == null) return row;
                for (int i = 0; i < r.size(); ++i) {
                    row.addValueMeta(r.getValueMeta(i));
                }
                return row;
            }
            catch (HopPluginException | HopTransformException throwable) {
                return row;
            }
        }
        for (ExcelInputField field : this.fields) {
            IValueMeta v;
            try {
                v = ValueMetaFactory.createValueMeta((String)field.getName(), (int)field.getHopType());
            }
            catch (HopPluginException e) {
                v = new ValueMetaNone(field.getName());
            }
            row.addValueMeta(v);
        }
        return row;
    }

    public String getBadLineFilesExtension() {
        return this.warningFilesExtension;
    }

    public void setBadLineFilesExtension(String badLineFilesExtension) {
        this.warningFilesExtension = badLineFilesExtension;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.addFilenamesToResult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.addFilenamesToResult;
    }

    public boolean readAllSheets() {
        return this.sheets.isEmpty() || this.sheets.size() == 1 && StringUtils.isEmpty((String)this.sheets.get(0).getName());
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.acceptingFilenames) {
                for (EIFile file : this.files) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(file.getName()), (IVariables)variables);
                    file.setName(iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)file.getMask())));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public String[] getSheetsNames() {
        String[] names = new String[this.sheets.size()];
        for (int i = 0; i < this.sheets.size(); ++i) {
            names[i] = this.sheets.get(i).getName();
        }
        return names;
    }

    public int[] getSheetsStartColumns() {
        int[] columns = new int[this.sheets.size()];
        for (int i = 0; i < this.sheets.size(); ++i) {
            columns[i] = this.sheets.get(i).getStartColumn();
        }
        return columns;
    }

    public int[] getSheetsStartRows() {
        int[] rows = new int[this.sheets.size()];
        for (int i = 0; i < this.sheets.size(); ++i) {
            rows[i] = this.sheets.get(i).getStartRow();
        }
        return rows;
    }

    @Generated
    public List<EIFile> getFiles() {
        return this.files;
    }

    @Generated
    public String getFileField() {
        return this.fileField;
    }

    @Generated
    public List<EISheet> getSheets() {
        return this.sheets;
    }

    @Generated
    public String getSheetField() {
        return this.sheetField;
    }

    @Generated
    public boolean isStartsWithHeader() {
        return this.startsWithHeader;
    }

    @Generated
    public String getSchemaDefinition() {
        return this.schemaDefinition;
    }

    @Generated
    public boolean isIgnoreFields() {
        return this.ignoreFields;
    }

    @Generated
    public boolean isStopOnEmpty() {
        return this.stopOnEmpty;
    }

    @Generated
    public boolean isIgnoreEmptyRows() {
        return this.ignoreEmptyRows;
    }

    @Generated
    public String getRowNumberField() {
        return this.rowNumberField;
    }

    @Generated
    public String getSheetRowNumberField() {
        return this.sheetRowNumberField;
    }

    @Generated
    public long getRowLimit() {
        return this.rowLimit;
    }

    @Generated
    public List<ExcelInputField> getFields() {
        return this.fields;
    }

    @Generated
    public boolean isStrictTypes() {
        return this.strictTypes;
    }

    @Generated
    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    @Generated
    public boolean isErrorLineSkipped() {
        return this.errorLineSkipped;
    }

    @Generated
    public String getWarningFilesDestinationDirectory() {
        return this.warningFilesDestinationDirectory;
    }

    @Generated
    public String getWarningFilesExtension() {
        return this.warningFilesExtension;
    }

    @Generated
    public String getErrorFilesDestinationDirectory() {
        return this.errorFilesDestinationDirectory;
    }

    @Generated
    public String getErrorFilesExtension() {
        return this.errorFilesExtension;
    }

    @Generated
    public String getLineNumberFilesDestinationDirectory() {
        return this.lineNumberFilesDestinationDirectory;
    }

    @Generated
    public String getLineNumberFilesExtension() {
        return this.lineNumberFilesExtension;
    }

    @Generated
    public boolean isAcceptingFilenames() {
        return this.acceptingFilenames;
    }

    @Generated
    public String getAcceptingField() {
        return this.acceptingField;
    }

    @Generated
    public String getAcceptingTransformName() {
        return this.acceptingTransformName;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public boolean isAddFilenamesToResult() {
        return this.addFilenamesToResult;
    }

    @Generated
    public String getShortFileFieldName() {
        return this.shortFileFieldName;
    }

    @Generated
    public String getPathFieldName() {
        return this.pathFieldName;
    }

    @Generated
    public String getHiddenFieldName() {
        return this.hiddenFieldName;
    }

    @Generated
    public String getLastModificationTimeFieldName() {
        return this.lastModificationTimeFieldName;
    }

    @Generated
    public String getUriNameFieldName() {
        return this.uriNameFieldName;
    }

    @Generated
    public String getRootUriNameFieldName() {
        return this.rootUriNameFieldName;
    }

    @Generated
    public String getExtensionFieldName() {
        return this.extensionFieldName;
    }

    @Generated
    public String getSizeFieldName() {
        return this.sizeFieldName;
    }

    @Generated
    public SpreadSheetType getSpreadSheetType() {
        return this.spreadSheetType;
    }

    @Generated
    public void setFiles(List<EIFile> files) {
        this.files = files;
    }

    @Generated
    public void setFileField(String fileField) {
        this.fileField = fileField;
    }

    @Generated
    public void setSheets(List<EISheet> sheets) {
        this.sheets = sheets;
    }

    @Generated
    public void setSheetField(String sheetField) {
        this.sheetField = sheetField;
    }

    @Generated
    public void setStartsWithHeader(boolean startsWithHeader) {
        this.startsWithHeader = startsWithHeader;
    }

    @Generated
    public void setSchemaDefinition(String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
    }

    @Generated
    public void setIgnoreFields(boolean ignoreFields) {
        this.ignoreFields = ignoreFields;
    }

    @Generated
    public void setStopOnEmpty(boolean stopOnEmpty) {
        this.stopOnEmpty = stopOnEmpty;
    }

    @Generated
    public void setIgnoreEmptyRows(boolean ignoreEmptyRows) {
        this.ignoreEmptyRows = ignoreEmptyRows;
    }

    @Generated
    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Generated
    public void setSheetRowNumberField(String sheetRowNumberField) {
        this.sheetRowNumberField = sheetRowNumberField;
    }

    @Generated
    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Generated
    public void setFields(List<ExcelInputField> fields) {
        this.fields = fields;
    }

    @Generated
    public void setStrictTypes(boolean strictTypes) {
        this.strictTypes = strictTypes;
    }

    @Generated
    public void setErrorIgnored(boolean errorIgnored) {
        this.errorIgnored = errorIgnored;
    }

    @Generated
    public void setErrorLineSkipped(boolean errorLineSkipped) {
        this.errorLineSkipped = errorLineSkipped;
    }

    @Generated
    public void setWarningFilesDestinationDirectory(String warningFilesDestinationDirectory) {
        this.warningFilesDestinationDirectory = warningFilesDestinationDirectory;
    }

    @Generated
    public void setWarningFilesExtension(String warningFilesExtension) {
        this.warningFilesExtension = warningFilesExtension;
    }

    @Generated
    public void setErrorFilesDestinationDirectory(String errorFilesDestinationDirectory) {
        this.errorFilesDestinationDirectory = errorFilesDestinationDirectory;
    }

    @Generated
    public void setErrorFilesExtension(String errorFilesExtension) {
        this.errorFilesExtension = errorFilesExtension;
    }

    @Generated
    public void setLineNumberFilesDestinationDirectory(String lineNumberFilesDestinationDirectory) {
        this.lineNumberFilesDestinationDirectory = lineNumberFilesDestinationDirectory;
    }

    @Generated
    public void setLineNumberFilesExtension(String lineNumberFilesExtension) {
        this.lineNumberFilesExtension = lineNumberFilesExtension;
    }

    @Generated
    public void setAcceptingFilenames(boolean acceptingFilenames) {
        this.acceptingFilenames = acceptingFilenames;
    }

    @Generated
    public void setAcceptingField(String acceptingField) {
        this.acceptingField = acceptingField;
    }

    @Generated
    public void setAcceptingTransformName(String acceptingTransformName) {
        this.acceptingTransformName = acceptingTransformName;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setAddFilenamesToResult(boolean addFilenamesToResult) {
        this.addFilenamesToResult = addFilenamesToResult;
    }

    @Generated
    public void setShortFileFieldName(String shortFileFieldName) {
        this.shortFileFieldName = shortFileFieldName;
    }

    @Generated
    public void setPathFieldName(String pathFieldName) {
        this.pathFieldName = pathFieldName;
    }

    @Generated
    public void setHiddenFieldName(String hiddenFieldName) {
        this.hiddenFieldName = hiddenFieldName;
    }

    @Generated
    public void setLastModificationTimeFieldName(String lastModificationTimeFieldName) {
        this.lastModificationTimeFieldName = lastModificationTimeFieldName;
    }

    @Generated
    public void setUriNameFieldName(String uriNameFieldName) {
        this.uriNameFieldName = uriNameFieldName;
    }

    @Generated
    public void setRootUriNameFieldName(String rootUriNameFieldName) {
        this.rootUriNameFieldName = rootUriNameFieldName;
    }

    @Generated
    public void setExtensionFieldName(String extensionFieldName) {
        this.extensionFieldName = extensionFieldName;
    }

    @Generated
    public void setSizeFieldName(String sizeFieldName) {
        this.sizeFieldName = sizeFieldName;
    }

    @Generated
    public void setSpreadSheetType(SpreadSheetType spreadSheetType) {
        this.spreadSheetType = spreadSheetType;
    }

    public static class EIFile {
        @HopMetadataProperty(key="name", injectionKey="FILENAME", injectionKeyDescription="ExcelInput.Injection.FILENAME")
        private String name;
        @HopMetadataProperty(key="filemask", injectionKey="FILEMASK", injectionKeyDescription="ExcelInput.Injection.FILEMASK")
        private String mask;
        @HopMetadataProperty(key="exclude_filemask", injectionKey="EXCLUDE_FILEMASK", injectionKeyDescription="ExcelInput.Injection.EXCLUDE_FILEMASK")
        private String excludeMask;
        @HopMetadataProperty(key="file_required", injectionKey="FILE_REQUIRED", injectionKeyDescription="ExcelInput.Injection.FILE_REQUIRED")
        private String required;
        @HopMetadataProperty(key="include_subfolders", injectionKey="INCLUDE_SUBFOLDERS", injectionKeyDescription="ExcelInput.Injection.INCLUDE_SUBFOLDERS")
        private String includeSubFolders;

        public EIFile() {
        }

        public EIFile(EIFile f) {
            this();
            this.name = f.name;
            this.mask = f.mask;
            this.excludeMask = f.excludeMask;
            this.required = f.required;
            this.includeSubFolders = f.includeSubFolders;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getMask() {
            return this.mask;
        }

        @Generated
        public String getExcludeMask() {
            return this.excludeMask;
        }

        @Generated
        public String getRequired() {
            return this.required;
        }

        @Generated
        public String getIncludeSubFolders() {
            return this.includeSubFolders;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setMask(String mask) {
            this.mask = mask;
        }

        @Generated
        public void setExcludeMask(String excludeMask) {
            this.excludeMask = excludeMask;
        }

        @Generated
        public void setRequired(String required) {
            this.required = required;
        }

        @Generated
        public void setIncludeSubFolders(String includeSubFolders) {
            this.includeSubFolders = includeSubFolders;
        }
    }

    public static class EISheet {
        @HopMetadataProperty(key="name", injectionKey="SHEET_NAME", injectionKeyDescription="ExcelInput.Injection.SHEET_NAME")
        private String name;
        @HopMetadataProperty(key="startrow", injectionKey="SHEET_START_ROW", injectionKeyDescription="ExcelInput.Injection.SHEET_START_ROW")
        private int startRow;
        @HopMetadataProperty(key="startcol", injectionKey="SHEET_START_COL", injectionKeyDescription="ExcelInput.Injection.SHEET_START_COL")
        private int startColumn;

        public EISheet() {
        }

        public EISheet(EISheet s) {
            this.name = s.name;
            this.startRow = s.startRow;
            this.startColumn = s.startColumn;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public int getStartRow() {
            return this.startRow;
        }

        @Generated
        public int getStartColumn() {
            return this.startColumn;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setStartRow(int startRow) {
            this.startRow = startRow;
        }

        @Generated
        public void setStartColumn(int startColumn) {
            this.startColumn = startColumn;
        }
    }
}

