/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapinput;

import java.util.Collection;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.truststore.CustomSocketFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transforms.ldapinput.ILdapMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapProtocol;

public class LdapSslProtocol
extends LdapProtocol {
    private final boolean trustAllCertificates;
    private final String trustStorePath;
    private final String trustStorePassword;

    public LdapSslProtocol(ILogChannel log, IVariables variables, ILdapMeta meta, Collection<String> binaryAttributes) {
        super(log, variables, meta, binaryAttributes);
        if (meta.isUseCertificate()) {
            this.trustStorePath = variables.resolve(meta.getTrustStorePath());
            this.trustStorePassword = Utils.resolvePassword((IVariables)variables, (String)meta.getTrustStorePassword());
            this.trustAllCertificates = meta.isTrustAllCertificates();
        } else {
            this.trustAllCertificates = false;
            this.trustStorePath = null;
            this.trustStorePassword = null;
        }
    }

    @Override
    protected String getConnectionPrefix() {
        return "ldaps://";
    }

    public static String getName() {
        return "LDAP SSL";
    }

    protected void configureSslEnvironment(Map<String, String> env) {
        env.put("java.naming.security.protocol", "ssl");
        env.put("java.naming.ldap.factory.socket", CustomSocketFactory.class.getCanonicalName());
    }

    @Override
    protected void setupEnvironment(Map<String, String> env, String username, String password) throws HopException {
        super.setupEnvironment(env, username, password);
        this.configureSslEnvironment(env);
        this.configureSocketFactory(this.trustAllCertificates, this.trustStorePath, this.trustStorePassword);
    }

    protected void configureSocketFactory(boolean trustAllCertificates, String trustStorePath, String trustStorePassword) throws HopException {
        if (trustAllCertificates) {
            CustomSocketFactory.configure();
        } else {
            CustomSocketFactory.configure((String)trustStorePath, (String)trustStorePassword);
        }
    }
}

