/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class PaperDocExportResult {
    @Nonnull
    protected final String owner;
    @Nonnull
    protected final String title;
    protected final long revision;
    @Nonnull
    protected final String mimeType;

    public PaperDocExportResult(@Nonnull String owner, @Nonnull String title, long revision, @Nonnull String mimeType) {
        if (owner == null) {
            throw new IllegalArgumentException("Required value for 'owner' is null");
        }
        this.owner = owner;
        if (title == null) {
            throw new IllegalArgumentException("Required value for 'title' is null");
        }
        this.title = title;
        this.revision = revision;
        if (mimeType == null) {
            throw new IllegalArgumentException("Required value for 'mimeType' is null");
        }
        this.mimeType = mimeType;
    }

    @Nonnull
    public String getOwner() {
        return this.owner;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public long getRevision() {
        return this.revision;
    }

    @Nonnull
    public String getMimeType() {
        return this.mimeType;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.owner, this.title, this.revision, this.mimeType});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PaperDocExportResult other = (PaperDocExportResult)obj;
            return !(this.owner != other.owner && !this.owner.equals(other.owner) || this.title != other.title && !this.title.equals(other.title) || this.revision != other.revision || this.mimeType != other.mimeType && !this.mimeType.equals(other.mimeType));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PaperDocExportResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperDocExportResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("owner");
            StoneSerializers.string().serialize(value.owner, g);
            g.writeFieldName("title");
            StoneSerializers.string().serialize(value.title, g);
            g.writeFieldName("revision");
            StoneSerializers.int64().serialize((Long)value.revision, g);
            g.writeFieldName("mime_type");
            StoneSerializers.string().serialize(value.mimeType, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PaperDocExportResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_mimeType;
            Long f_revision;
            String f_title;
            String f_owner;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_owner = null;
                f_title = null;
                f_revision = null;
                f_mimeType = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("owner".equals(field)) {
                        f_owner = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("title".equals(field)) {
                        f_title = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("revision".equals(field)) {
                        f_revision = StoneSerializers.int64().deserialize(p);
                        continue;
                    }
                    if ("mime_type".equals(field)) {
                        f_mimeType = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_owner == null) {
                    throw new JsonParseException(p, "Required field \"owner\" missing.");
                }
                if (f_title == null) {
                    throw new JsonParseException(p, "Required field \"title\" missing.");
                }
                if (f_revision == null) {
                    throw new JsonParseException(p, "Required field \"revision\" missing.");
                }
                if (f_mimeType == null) {
                    throw new JsonParseException(p, "Required field \"mime_type\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PaperDocExportResult value = new PaperDocExportResult(f_owner, f_title, f_revision, f_mimeType);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

