/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v1;

import com.dropbox.core.BadRequestException;
import com.dropbox.core.BadResponseException;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.DbxStreamWriter;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.NoThrowOutputStream;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonArrayReader;
import com.dropbox.core.json.JsonDateReader;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.Collector;
import com.dropbox.core.util.CountingOutputStream;
import com.dropbox.core.util.DumpWriter;
import com.dropbox.core.util.Dumpable;
import com.dropbox.core.util.IOUtil;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.util.Maybe;
import com.dropbox.core.util.StringUtil;
import com.dropbox.core.v1.DbxAccountInfo;
import com.dropbox.core.v1.DbxDelta;
import com.dropbox.core.v1.DbxDeltaC;
import com.dropbox.core.v1.DbxEntry;
import com.dropbox.core.v1.DbxLongpollDeltaResult;
import com.dropbox.core.v1.DbxPathV1;
import com.dropbox.core.v1.DbxThumbnailFormat;
import com.dropbox.core.v1.DbxThumbnailSize;
import com.dropbox.core.v1.DbxUrlWithExpiration;
import com.dropbox.core.v1.DbxWriteMode;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class DbxClientV1 {
    public static final String USER_AGENT_ID = "Dropbox-Java-SDK";
    private final DbxRequestConfig requestConfig;
    private final String accessToken;
    private final DbxHost host;
    private static final long ChunkedUploadThreshold = 0x800000L;
    private static final int ChunkedUploadChunkSize = 0x400000;
    private static JsonReader<String> LatestCursorReader = new JsonReader<String>(){

        @Override
        public String read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            String cursorId = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                parser.nextToken();
                try {
                    if (fieldName.equals("cursor")) {
                        cursorId = JsonReader.StringReader.readField(parser, fieldName, cursorId);
                        continue;
                    }
                    JsonReader.skipValue(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (cursorId == null) {
                throw new JsonReadException("missing field \"cursor\"", top);
            }
            return cursorId;
        }
    };

    public DbxClientV1(DbxRequestConfig requestConfig, String accessToken) {
        this(requestConfig, accessToken, DbxHost.DEFAULT);
    }

    public DbxClientV1(DbxRequestConfig requestConfig, String accessToken, DbxHost host) {
        if (requestConfig == null) {
            throw new IllegalArgumentException("'requestConfig' is null");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("'accessToken' is null");
        }
        if (host == null) {
            throw new IllegalArgumentException("'host' is null");
        }
        this.requestConfig = requestConfig;
        this.accessToken = accessToken;
        this.host = host;
    }

    public DbxRequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public DbxHost getHost() {
        return this.host;
    }

    public DbxEntry getMetadata(String path, boolean includeMediaInfo) throws DbxException {
        DbxPathV1.checkArg("path", path);
        String host = this.host.getApi();
        String apiPath = "1/metadata/auto" + path;
        String[] params = new String[]{"list", "false", "include_media_info", includeMediaInfo ? "true" : null};
        return this.doGet(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<DbxEntry>(){

            @Override
            public DbxEntry handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 404) {
                    return null;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.ReaderMaybeDeleted, response);
            }
        });
    }

    public DbxEntry getMetadata(String path) throws DbxException {
        return this.getMetadata(path, false);
    }

    public DbxEntry.WithChildren getMetadataWithChildren(String path, boolean includeMediaInfo) throws DbxException {
        return this.getMetadataWithChildrenBase(path, includeMediaInfo, DbxEntry.WithChildren.ReaderMaybeDeleted);
    }

    public DbxEntry.WithChildren getMetadataWithChildren(String path) throws DbxException {
        return this.getMetadataWithChildren(path, false);
    }

    public <C> DbxEntry.WithChildrenC<C> getMetadataWithChildrenC(String path, boolean includeMediaInfo, Collector<DbxEntry, ? extends C> collector) throws DbxException {
        return (DbxEntry.WithChildrenC)this.getMetadataWithChildrenBase(path, includeMediaInfo, new DbxEntry.WithChildrenC.ReaderMaybeDeleted<C>(collector));
    }

    public <C> DbxEntry.WithChildrenC<C> getMetadataWithChildrenC(String path, Collector<DbxEntry, ? extends C> collector) throws DbxException {
        return this.getMetadataWithChildrenC(path, false, collector);
    }

    private <T> T getMetadataWithChildrenBase(String path, boolean includeMediaInfo, final JsonReader<? extends T> reader) throws DbxException {
        DbxPathV1.checkArg("path", path);
        String host = this.host.getApi();
        String apiPath = "1/metadata/auto" + path;
        String[] params = new String[]{"list", "true", "file_limit", "25000", "include_media_info", includeMediaInfo ? "true" : null};
        return this.doGet(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<T>(){

            @Override
            public T handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 404) {
                    return null;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(reader, response);
            }
        });
    }

    public Maybe<DbxEntry.WithChildren> getMetadataWithChildrenIfChanged(String path, boolean includeMediaInfo, String previousFolderHash) throws DbxException {
        return this.getMetadataWithChildrenIfChangedBase(path, includeMediaInfo, previousFolderHash, DbxEntry.WithChildren.ReaderMaybeDeleted);
    }

    public Maybe<DbxEntry.WithChildren> getMetadataWithChildrenIfChanged(String path, String previousFolderHash) throws DbxException {
        return this.getMetadataWithChildrenIfChanged(path, false, previousFolderHash);
    }

    public <C> Maybe<DbxEntry.WithChildrenC<C>> getMetadataWithChildrenIfChangedC(String path, boolean includeMediaInfo, String previousFolderHash, Collector<DbxEntry, ? extends C> collector) throws DbxException {
        return this.getMetadataWithChildrenIfChangedBase(path, includeMediaInfo, previousFolderHash, new DbxEntry.WithChildrenC.ReaderMaybeDeleted<C>(collector));
    }

    public <C> Maybe<DbxEntry.WithChildrenC<C>> getMetadataWithChildrenIfChangedC(String path, String previousFolderHash, Collector<DbxEntry, ? extends C> collector) throws DbxException {
        return this.getMetadataWithChildrenIfChangedC(path, false, previousFolderHash, collector);
    }

    private <T> Maybe<T> getMetadataWithChildrenIfChangedBase(String path, boolean includeMediaInfo, String previousFolderHash, final JsonReader<T> reader) throws DbxException {
        if (previousFolderHash == null) {
            throw new IllegalArgumentException("'previousFolderHash' must not be null");
        }
        if (previousFolderHash.length() == 0) {
            throw new IllegalArgumentException("'previousFolderHash' must not be empty");
        }
        DbxPathV1.checkArg("path", path);
        String host = this.host.getApi();
        String apiPath = "1/metadata/auto" + path;
        String[] params = new String[]{"list", "true", "file_limit", "25000", "hash", previousFolderHash, "include_media_info", includeMediaInfo ? "true" : null};
        return (Maybe)this.doGet(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<Maybe<T>>(){

            @Override
            public Maybe<T> handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 404) {
                    return Maybe.Just(null);
                }
                if (response.getStatusCode() == 304) {
                    return Maybe.Nothing();
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return Maybe.Just(DbxRequestUtil.readJsonFromResponse(reader, response));
            }
        });
    }

    public DbxAccountInfo getAccountInfo() throws DbxException {
        String host = this.host.getApi();
        String apiPath = "1/account/info";
        return this.doGet(host, apiPath, null, null, new DbxRequestUtil.ResponseHandler<DbxAccountInfo>(){

            @Override
            public DbxAccountInfo handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxAccountInfo.Reader, response);
            }
        });
    }

    public void disableAccessToken() throws DbxException {
        String host = this.host.getApi();
        String apiPath = "1/disable_access_token";
        this.doPost(host, apiPath, null, null, new DbxRequestUtil.ResponseHandler<Void>(){

            @Override
            public Void handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    String requestId = DbxRequestUtil.getRequestId(response);
                    throw new BadResponseException(requestId, "unexpected response code: " + response.getStatusCode());
                }
                return null;
            }
        });
    }

    public DbxEntry.File getFile(String path, String rev, OutputStream target) throws DbxException, IOException {
        Downloader downloader = this.startGetFile(path, rev);
        if (downloader == null) {
            return null;
        }
        return downloader.copyBodyAndClose(target);
    }

    public Downloader startGetFile(String path, String rev) throws DbxException {
        DbxPathV1.checkArgNonRoot("path", path);
        String apiPath = "1/files/auto" + path;
        String[] params = new String[]{"rev", rev};
        return this.startGetSomething(apiPath, params);
    }

    private Downloader startGetSomething(final String apiPath, final String[] params) throws DbxException {
        final String host = this.host.getContent();
        return DbxRequestUtil.runAndRetry(this.requestConfig.getMaxRetries(), new DbxRequestUtil.RequestMaker<Downloader, DbxException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Downloader run() throws DbxException {
                DbxEntry.File metadata;
                HttpRequestor.Response response = DbxRequestUtil.startGet(DbxClientV1.this.requestConfig, DbxClientV1.this.accessToken, DbxClientV1.USER_AGENT_ID, host, apiPath, params, null);
                boolean passedOwnershipOfStream = false;
                if (response.getStatusCode() == 404) {
                    Downloader downloader = null;
                    return downloader;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                String metadataString = DbxRequestUtil.getFirstHeader(response, "x-dropbox-metadata");
                try {
                    metadata = DbxEntry.File.Reader.readFully(metadataString);
                }
                catch (JsonReadException ex) {
                    String requestId = DbxRequestUtil.getRequestId(response);
                    throw new BadResponseException(requestId, "Bad JSON in X-Dropbox-Metadata header: " + ex.getMessage(), ex);
                }
                Downloader result = new Downloader(metadata, response.getBody());
                passedOwnershipOfStream = true;
                Downloader downloader = result;
                return downloader;
                finally {
                    if (!passedOwnershipOfStream) {
                        try {
                            response.getBody().close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }

    public DbxEntry.File uploadFile(String targetPath, DbxWriteMode writeMode, long numBytes, InputStream contents) throws DbxException, IOException {
        return this.uploadFile(targetPath, writeMode, numBytes, new DbxStreamWriter.InputStreamCopier(contents));
    }

    public <E extends Throwable> DbxEntry.File uploadFile(String targetPath, DbxWriteMode writeMode, long numBytes, DbxStreamWriter<E> writer) throws DbxException, E {
        Uploader uploader = this.startUploadFile(targetPath, writeMode, numBytes);
        return this.finishUploadFile(uploader, writer);
    }

    public Uploader startUploadFile(String targetPath, DbxWriteMode writeMode, long numBytes) throws DbxException {
        if (numBytes < 0L) {
            if (numBytes != -1L) {
                throw new IllegalArgumentException("numBytes must be -1 or greater; given " + numBytes);
            }
            return this.startUploadFileChunked(targetPath, writeMode, numBytes);
        }
        if (numBytes > 0x800000L) {
            return this.startUploadFileChunked(targetPath, writeMode, numBytes);
        }
        return this.startUploadFileSingle(targetPath, writeMode, numBytes);
    }

    public <E extends Throwable> DbxEntry.File finishUploadFile(Uploader uploader, DbxStreamWriter<E> writer) throws DbxException, E {
        NoThrowOutputStream streamWrapper = new NoThrowOutputStream(uploader.getBody());
        try {
            writer.write(streamWrapper);
            DbxEntry.File file = uploader.finish();
            return file;
        }
        catch (NoThrowOutputStream.HiddenException ex) {
            if (ex.owner == streamWrapper) {
                throw new NetworkIOException(ex.getCause());
            }
            throw ex;
        }
        finally {
            uploader.close();
        }
    }

    public Uploader startUploadFileSingle(String targetPath, DbxWriteMode writeMode, long numBytes) throws DbxException {
        DbxPathV1.checkArg("targetPath", targetPath);
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes must be zero or greater");
        }
        String host = this.host.getContent();
        String apiPath = "1/files_put/auto" + targetPath;
        ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        headers.add(new HttpRequestor.Header("Content-Type", "application/octet-stream"));
        headers.add(new HttpRequestor.Header("Content-Length", Long.toString(numBytes)));
        HttpRequestor.Uploader uploader = DbxRequestUtil.startPut(this.requestConfig, this.accessToken, USER_AGENT_ID, host, apiPath, writeMode.params, headers);
        return new SingleUploader(uploader, numBytes);
    }

    public <E extends Throwable> DbxEntry.File uploadFileSingle(String targetPath, DbxWriteMode writeMode, long numBytes, DbxStreamWriter<E> writer) throws DbxException, E {
        Uploader uploader = this.startUploadFileSingle(targetPath, writeMode, numBytes);
        return this.finishUploadFile(uploader, writer);
    }

    private <E extends Throwable> HttpRequestor.Response chunkedUploadCommon(String[] params, long chunkSize, DbxStreamWriter<E> writer) throws DbxException, E {
        String apiPath = "1/chunked_upload";
        ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        headers.add(new HttpRequestor.Header("Content-Type", "application/octet-stream"));
        headers.add(new HttpRequestor.Header("Content-Length", Long.toString(chunkSize)));
        try (HttpRequestor.Uploader uploader = DbxRequestUtil.startPut(this.requestConfig, this.accessToken, USER_AGENT_ID, this.host.getContent(), apiPath, params, headers);){
            NoThrowOutputStream nt = new NoThrowOutputStream(uploader.getBody());
            try {
                writer.write(nt);
            }
            catch (NoThrowOutputStream.HiddenException ex) {
                if (ex.owner == nt) {
                    throw new NetworkIOException(ex.getCause());
                }
                throw ex;
            }
            long bytesWritten = nt.getBytesWritten();
            if (bytesWritten != chunkSize) {
                throw new IllegalStateException("'chunkSize' is " + chunkSize + ", but 'writer' only wrote " + bytesWritten + " bytes");
            }
            try {
                HttpRequestor.Response response = uploader.finish();
                return response;
            }
            catch (IOException ex) {
                throw new NetworkIOException(ex);
            }
        }
    }

    private ChunkedUploadState chunkedUploadCheckForOffsetCorrection(HttpRequestor.Response response) throws DbxException {
        if (response.getStatusCode() != 400) {
            return null;
        }
        byte[] data = DbxRequestUtil.loadErrorBody(response);
        try {
            return ChunkedUploadState.Reader.readFully(data);
        }
        catch (JsonReadException ex) {
            String requestId = DbxRequestUtil.getRequestId(response);
            throw new BadRequestException(requestId, DbxRequestUtil.parseErrorBody(requestId, 400, data));
        }
    }

    private ChunkedUploadState chunkedUploadParse200(HttpRequestor.Response response) throws BadResponseException, NetworkIOException {
        assert (response.getStatusCode() == 200) : response.getStatusCode();
        return DbxRequestUtil.readJsonFromResponse(ChunkedUploadState.Reader, response);
    }

    public String chunkedUploadFirst(byte[] data) throws DbxException {
        return this.chunkedUploadFirst(data, 0, data.length);
    }

    public String chunkedUploadFirst(byte[] data, int dataOffset, int dataLength) throws DbxException {
        return this.chunkedUploadFirst(dataLength, new DbxStreamWriter.ByteArrayCopier(data, dataOffset, dataLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> String chunkedUploadFirst(int chunkSize, DbxStreamWriter<E> writer) throws DbxException, E {
        HttpRequestor.Response response = this.chunkedUploadCommon(new String[0], chunkSize, writer);
        try {
            ChunkedUploadState correctedState = this.chunkedUploadCheckForOffsetCorrection(response);
            if (correctedState != null) {
                String requestId = DbxRequestUtil.getRequestId(response);
                throw new BadResponseException(requestId, "Got offset correction response on first chunk.");
            }
            if (response.getStatusCode() == 404) {
                String requestId = DbxRequestUtil.getRequestId(response);
                throw new BadResponseException(requestId, "Got a 404, but we didn't send an upload_id");
            }
            if (response.getStatusCode() != 200) {
                throw DbxRequestUtil.unexpectedStatus(response);
            }
            ChunkedUploadState returnedState = this.chunkedUploadParse200(response);
            if (returnedState.offset != (long)chunkSize) {
                String requestId = DbxRequestUtil.getRequestId(response);
                throw new BadResponseException(requestId, "Sent " + chunkSize + " bytes, but returned offset is " + returnedState.offset);
            }
            String string = returnedState.uploadId;
            return string;
        }
        finally {
            IOUtil.closeInput(response.getBody());
        }
    }

    public long chunkedUploadAppend(String uploadId, long uploadOffset, byte[] data) throws DbxException {
        return this.chunkedUploadAppend(uploadId, uploadOffset, data, 0, data.length);
    }

    public long chunkedUploadAppend(String uploadId, long uploadOffset, byte[] data, int dataOffset, int dataLength) throws DbxException {
        return this.chunkedUploadAppend(uploadId, uploadOffset, dataLength, new DbxStreamWriter.ByteArrayCopier(data, dataOffset, dataLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> long chunkedUploadAppend(String uploadId, long uploadOffset, long chunkSize, DbxStreamWriter<E> writer) throws DbxException, E {
        if (uploadId == null) {
            throw new IllegalArgumentException("'uploadId' can't be null");
        }
        if (uploadId.length() == 0) {
            throw new IllegalArgumentException("'uploadId' can't be empty");
        }
        if (uploadOffset < 0L) {
            throw new IllegalArgumentException("'offset' can't be negative");
        }
        String[] params = new String[]{"upload_id", uploadId, "offset", Long.toString(uploadOffset)};
        HttpRequestor.Response response = this.chunkedUploadCommon(params, chunkSize, writer);
        String requestId = DbxRequestUtil.getRequestId(response);
        try {
            ChunkedUploadState correctedState = this.chunkedUploadCheckForOffsetCorrection(response);
            long expectedOffset = uploadOffset + chunkSize;
            if (correctedState != null) {
                if (!correctedState.uploadId.equals(uploadId)) {
                    throw new BadResponseException(requestId, "uploadId mismatch: us=" + StringUtil.jq(uploadId) + ", server=" + StringUtil.jq(correctedState.uploadId));
                }
                if (correctedState.offset == uploadOffset) {
                    throw new BadResponseException(requestId, "Corrected offset is same as given: " + uploadOffset);
                }
                if (correctedState.offset < uploadOffset) {
                    throw new BadResponseException(requestId, "we were at offset " + uploadOffset + ", server said " + correctedState.offset);
                }
                if (correctedState.offset > expectedOffset) {
                    throw new BadResponseException(requestId, "we were at offset " + uploadOffset + ", server said " + correctedState.offset);
                }
                assert (correctedState.offset != expectedOffset);
                long l = correctedState.offset;
                return l;
            }
            if (response.getStatusCode() != 200) {
                throw DbxRequestUtil.unexpectedStatus(response);
            }
            ChunkedUploadState returnedState = this.chunkedUploadParse200(response);
            if (returnedState.offset != expectedOffset) {
                throw new BadResponseException(requestId, "Expected offset " + expectedOffset + " bytes, but returned offset is " + returnedState.offset);
            }
            long l = -1L;
            return l;
        }
        finally {
            IOUtil.closeInput(response.getBody());
        }
    }

    public DbxEntry.File chunkedUploadFinish(String targetPath, DbxWriteMode writeMode, String uploadId) throws DbxException {
        DbxPathV1.checkArgNonRoot("targetPath", targetPath);
        String apiPath = "1/commit_chunked_upload/auto" + targetPath;
        String[] params = new String[]{"upload_id", uploadId};
        params = LangUtil.arrayConcat(params, writeMode.params);
        return this.doPost(this.host.getContent(), apiPath, params, null, new DbxRequestUtil.ResponseHandler<DbxEntry.File>(){

            @Override
            public DbxEntry.File handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.File.Reader, response);
            }
        });
    }

    public Uploader startUploadFileChunked(String targetPath, DbxWriteMode writeMode, long numBytes) {
        return this.startUploadFileChunked(0x400000, targetPath, writeMode, numBytes);
    }

    public Uploader startUploadFileChunked(int chunkSize, String targetPath, DbxWriteMode writeMode, long numBytes) {
        DbxPathV1.checkArg("targetPath", targetPath);
        if (writeMode == null) {
            throw new IllegalArgumentException("'writeMode' can't be null");
        }
        return new ChunkedUploader(targetPath, writeMode, numBytes, new ChunkedUploadOutputStream(chunkSize));
    }

    public <E extends Throwable> DbxEntry.File uploadFileChunked(String targetPath, DbxWriteMode writeMode, long numBytes, DbxStreamWriter<E> writer) throws DbxException, E {
        Uploader uploader = this.startUploadFileChunked(targetPath, writeMode, numBytes);
        return this.finishUploadFile(uploader, writer);
    }

    public <E extends Throwable> DbxEntry.File uploadFileChunked(int chunkSize, String targetPath, DbxWriteMode writeMode, long numBytes, DbxStreamWriter<E> writer) throws DbxException, E {
        Uploader uploader = this.startUploadFileChunked(chunkSize, targetPath, writeMode, numBytes);
        return this.finishUploadFile(uploader, writer);
    }

    public DbxDelta<DbxEntry> getDelta(String cursor, boolean includeMediaInfo) throws DbxException {
        return this._getDelta(cursor, null, includeMediaInfo);
    }

    public DbxDelta<DbxEntry> getDelta(String cursor) throws DbxException {
        return this.getDelta(cursor, false);
    }

    public <C> DbxDeltaC<C> getDeltaC(Collector<DbxDeltaC.Entry<DbxEntry>, C> collector, String cursor, boolean includeMediaInfo) throws DbxException {
        return this._getDeltaC(collector, cursor, null, includeMediaInfo);
    }

    public <C> DbxDeltaC<C> getDeltaC(Collector<DbxDeltaC.Entry<DbxEntry>, C> collector, String cursor) throws DbxException {
        return this.getDeltaC(collector, cursor, false);
    }

    public DbxDelta<DbxEntry> getDeltaWithPathPrefix(String cursor, String pathPrefix, boolean includeMediaInfo) throws DbxException {
        DbxPathV1.checkArg("path", pathPrefix);
        return this._getDelta(cursor, pathPrefix, includeMediaInfo);
    }

    public DbxDelta<DbxEntry> getDeltaWithPathPrefix(String cursor, String pathPrefix) throws DbxException {
        DbxPathV1.checkArg("path", pathPrefix);
        return this._getDelta(cursor, pathPrefix, false);
    }

    public <C> DbxDeltaC<C> getDeltaCWithPathPrefix(Collector<DbxDeltaC.Entry<DbxEntry>, C> collector, String cursor, String pathPrefix, boolean includeMediaInfo) throws DbxException {
        DbxPathV1.checkArg("path", pathPrefix);
        return this._getDeltaC(collector, cursor, pathPrefix, includeMediaInfo);
    }

    public <C> DbxDeltaC<C> getDeltaCWithPathPrefix(Collector<DbxDeltaC.Entry<DbxEntry>, C> collector, String cursor, String pathPrefix) throws DbxException {
        return this.getDeltaCWithPathPrefix(collector, cursor, pathPrefix, false);
    }

    private DbxDelta<DbxEntry> _getDelta(String cursor, String pathPrefix, boolean includeMediaInfo) throws DbxException {
        String host = this.host.getApi();
        String apiPath = "1/delta";
        String[] params = new String[]{"cursor", cursor, "path_prefix", pathPrefix, "include_media_info", includeMediaInfo ? "true" : null};
        return this.doPost(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<DbxDelta<DbxEntry>>(){

            @Override
            public DbxDelta<DbxEntry> handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return (DbxDelta)((Object)DbxRequestUtil.readJsonFromResponse(new DbxDelta.Reader<DbxEntry>(DbxEntry.Reader), response));
            }
        });
    }

    private <C> DbxDeltaC<C> _getDeltaC(final Collector<DbxDeltaC.Entry<DbxEntry>, C> collector, String cursor, String pathPrefix, boolean includeMediaInfo) throws DbxException {
        String host = this.host.getApi();
        String apiPath = "1/delta";
        String[] params = new String[]{"cursor", cursor, "path_prefix", pathPrefix, "include_media_info", includeMediaInfo ? "true" : null};
        return (DbxDeltaC)this.doPost(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<DbxDeltaC<C>>(){

            @Override
            public DbxDeltaC<C> handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return (DbxDeltaC)DbxRequestUtil.readJsonFromResponse(new DbxDeltaC.Reader(DbxEntry.Reader, collector), response);
            }
        });
    }

    public String getDeltaLatestCursor(boolean includeMediaInfo) throws DbxException {
        return this._getDeltaLatestCursor(null, includeMediaInfo);
    }

    public String getDeltaLatestCursor() throws DbxException {
        return this._getDeltaLatestCursor(null, false);
    }

    public String getDeltaLatestCursorWithPathPrefix(String pathPrefix, boolean includeMediaInfo) throws DbxException {
        DbxPathV1.checkArg("path", pathPrefix);
        return this._getDeltaLatestCursor(pathPrefix, includeMediaInfo);
    }

    public String getDeltaLatestCursorWithPathPrefix(String pathPrefix) throws DbxException {
        return this.getDeltaLatestCursorWithPathPrefix(pathPrefix, false);
    }

    private String _getDeltaLatestCursor(String pathPrefix, boolean includeMediaInfo) throws DbxException {
        String host = this.host.getApi();
        String apiPath = "1/delta/latest_cursor";
        String[] params = new String[]{"path_prefix", pathPrefix, "include_media_info", includeMediaInfo ? "true" : null};
        return this.doPost(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<String>(){

            @Override
            public String handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return (String)DbxRequestUtil.readJsonFromResponse(LatestCursorReader, response);
            }
        });
    }

    public DbxLongpollDeltaResult getLongpollDelta(String cursor, int timeout) throws DbxException {
        if (cursor == null) {
            throw new IllegalArgumentException("'cursor' can't be null");
        }
        if (timeout < 30 || timeout > 480) {
            throw new IllegalArgumentException("'timeout' must be >=30 and <= 480");
        }
        String[] params = new String[]{"cursor", cursor, "timeout", Integer.toString(timeout)};
        return DbxRequestUtil.doGet(this.getRequestConfig(), this.getAccessToken(), USER_AGENT_ID, this.host.getNotify(), "1/longpoll_delta", params, null, new DbxRequestUtil.ResponseHandler<DbxLongpollDeltaResult>(){

            @Override
            public DbxLongpollDeltaResult handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxLongpollDeltaResult.Reader, response);
            }
        });
    }

    public DbxEntry.File getThumbnail(DbxThumbnailSize sizeBound, DbxThumbnailFormat format, String path, String rev, OutputStream target) throws DbxException, IOException {
        if (target == null) {
            throw new IllegalArgumentException("'target' can't be null");
        }
        Downloader downloader = this.startGetThumbnail(sizeBound, format, path, rev);
        if (downloader == null) {
            return null;
        }
        return downloader.copyBodyAndClose(target);
    }

    public Downloader startGetThumbnail(DbxThumbnailSize sizeBound, DbxThumbnailFormat format, String path, String rev) throws DbxException {
        DbxPathV1.checkArgNonRoot("path", path);
        if (sizeBound == null) {
            throw new IllegalArgumentException("'size' can't be null");
        }
        if (format == null) {
            throw new IllegalArgumentException("'format' can't be null");
        }
        String apiPath = "1/thumbnails/auto" + path;
        String[] params = new String[]{"size", sizeBound.ident, "format", format.ident, "rev", rev};
        return this.startGetSomething(apiPath, params);
    }

    public List<DbxEntry.File> getRevisions(String path) throws DbxException {
        DbxPathV1.checkArgNonRoot("path", path);
        String apiPath = "1/revisions/auto" + path;
        return this.doGet(this.host.getApi(), apiPath, null, null, new DbxRequestUtil.ResponseHandler<List<DbxEntry.File>>(){

            @Override
            public List<DbxEntry.File> handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                Collector collector = Collector.NullSkipper.mk(new Collector.ArrayListCollector());
                return (List)DbxRequestUtil.readJsonFromResponse(JsonArrayReader.mk(DbxEntry.File.ReaderMaybeDeleted, collector), response);
            }
        });
    }

    public DbxEntry.File restoreFile(String path, String rev) throws DbxException {
        DbxPathV1.checkArgNonRoot("path", path);
        if (rev == null) {
            throw new IllegalArgumentException("'rev' can't be null");
        }
        if (rev.length() == 0) {
            throw new IllegalArgumentException("'rev' can't be empty");
        }
        String apiPath = "1/restore/auto" + path;
        String[] params = new String[]{"rev", rev};
        return this.doGet(this.host.getApi(), apiPath, params, null, new DbxRequestUtil.ResponseHandler<DbxEntry.File>(){

            @Override
            public DbxEntry.File handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 404) {
                    return null;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.File.Reader, response);
            }
        });
    }

    public List<DbxEntry> searchFileAndFolderNames(String basePath, String query) throws DbxException {
        DbxPathV1.checkArg("basePath", basePath);
        if (query == null) {
            throw new IllegalArgumentException("'query' can't be null");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("'query' can't be empty");
        }
        String apiPath = "1/search/auto" + basePath;
        String[] params = new String[]{"query", query};
        return this.doPost(this.host.getApi(), apiPath, params, null, new DbxRequestUtil.ResponseHandler<List<DbxEntry>>(){

            @Override
            public List<DbxEntry> handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return (List)DbxRequestUtil.readJsonFromResponse(JsonArrayReader.mk(DbxEntry.Reader), response);
            }
        });
    }

    public String createShareableUrl(String path) throws DbxException {
        DbxPathV1.checkArg("path", path);
        String apiPath = "1/shares/auto" + path;
        String[] params = new String[]{"short_url", "false"};
        return this.doPost(this.host.getApi(), apiPath, params, null, new DbxRequestUtil.ResponseHandler<String>(){

            @Override
            public String handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 404) {
                    return null;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                DbxUrlWithExpiration uwe = DbxRequestUtil.readJsonFromResponse(DbxUrlWithExpiration.Reader, response);
                return uwe.url;
            }
        });
    }

    public DbxUrlWithExpiration createTemporaryDirectUrl(String path) throws DbxException {
        DbxPathV1.checkArgNonRoot("path", path);
        String apiPath = "1/media/auto" + path;
        return this.doPost(this.host.getApi(), apiPath, null, null, new DbxRequestUtil.ResponseHandler<DbxUrlWithExpiration>(){

            @Override
            public DbxUrlWithExpiration handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 404) {
                    return null;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxUrlWithExpiration.Reader, response);
            }
        });
    }

    public String createCopyRef(String path) throws DbxException {
        DbxPathV1.checkArgNonRoot("path", path);
        String apiPath = "1/copy_ref/auto" + path;
        return this.doPost(this.host.getApi(), apiPath, null, null, new DbxRequestUtil.ResponseHandler<String>(){

            @Override
            public String handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 404) {
                    return null;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                CopyRef copyRef = DbxRequestUtil.readJsonFromResponse(CopyRef.Reader, response);
                return copyRef.id;
            }
        });
    }

    public DbxEntry copy(String fromPath, String toPath) throws DbxException {
        DbxPathV1.checkArg("fromPath", fromPath);
        DbxPathV1.checkArgNonRoot("toPath", toPath);
        String[] params = new String[]{"root", "auto", "from_path", fromPath, "to_path", toPath};
        return this.doPost(this.host.getApi(), "1/fileops/copy", params, null, new DbxRequestUtil.ResponseHandler<DbxEntry>(){

            @Override
            public DbxEntry handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 403) {
                    return null;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                DbxEntry.WithChildren dwc = DbxRequestUtil.readJsonFromResponse(DbxEntry.WithChildren.Reader, response);
                if (dwc == null) {
                    return null;
                }
                return dwc.entry;
            }
        });
    }

    public DbxEntry copyFromCopyRef(String copyRef, String toPath) throws DbxException {
        if (copyRef == null) {
            throw new IllegalArgumentException("'copyRef' can't be null");
        }
        if (copyRef.length() == 0) {
            throw new IllegalArgumentException("'copyRef' can't be empty");
        }
        DbxPathV1.checkArgNonRoot("toPath", toPath);
        String[] params = new String[]{"root", "auto", "from_copy_ref", copyRef, "to_path", toPath};
        return this.doPost(this.host.getApi(), "1/fileops/copy", params, null, new DbxRequestUtil.ResponseHandler<DbxEntry>(){

            @Override
            public DbxEntry handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                DbxEntry.WithChildren dwc = DbxRequestUtil.readJsonFromResponse(DbxEntry.WithChildren.Reader, response);
                if (dwc == null) {
                    return null;
                }
                return dwc.entry;
            }
        });
    }

    public DbxEntry.Folder createFolder(String path) throws DbxException {
        DbxPathV1.checkArgNonRoot("path", path);
        String[] params = new String[]{"root", "auto", "path", path};
        return this.doPost(this.host.getApi(), "1/fileops/create_folder", params, null, new DbxRequestUtil.ResponseHandler<DbxEntry.Folder>(){

            @Override
            public DbxEntry.Folder handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 403) {
                    return null;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.Folder.Reader, response);
            }
        });
    }

    public void delete(String path) throws DbxException {
        DbxPathV1.checkArgNonRoot("path", path);
        String[] params = new String[]{"root", "auto", "path", path};
        this.doPost(this.host.getApi(), "1/fileops/delete", params, null, new DbxRequestUtil.ResponseHandler<Void>(){

            @Override
            public Void handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return null;
            }
        });
    }

    public DbxEntry move(String fromPath, String toPath) throws DbxException {
        DbxPathV1.checkArgNonRoot("fromPath", fromPath);
        DbxPathV1.checkArgNonRoot("toPath", toPath);
        String[] params = new String[]{"root", "auto", "from_path", fromPath, "to_path", toPath};
        return this.doPost(this.host.getApi(), "1/fileops/move", params, null, new DbxRequestUtil.ResponseHandler<DbxEntry>(){

            @Override
            public DbxEntry handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() == 403) {
                    return null;
                }
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                DbxEntry.WithChildren dwc = DbxRequestUtil.readJsonFromResponse(DbxEntry.WithChildren.Reader, response);
                if (dwc == null) {
                    return null;
                }
                return dwc.entry;
            }
        });
    }

    private <T> T doGet(String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers, DbxRequestUtil.ResponseHandler<T> handler) throws DbxException {
        return DbxRequestUtil.doGet(this.requestConfig, this.accessToken, USER_AGENT_ID, host, path, params, headers, handler);
    }

    public <T> T doPost(String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers, DbxRequestUtil.ResponseHandler<T> handler) throws DbxException {
        return DbxRequestUtil.doPost(this.requestConfig, this.accessToken, USER_AGENT_ID, host, path, params, headers, handler);
    }

    public static abstract class Uploader {
        public abstract OutputStream getBody();

        public abstract void abort();

        public abstract void close();

        public abstract DbxEntry.File finish() throws DbxException;
    }

    private static final class CopyRef {
        public final String id;
        public final Date expires;
        public static final JsonReader<CopyRef> Reader = new JsonReader<CopyRef>(){

            @Override
            public CopyRef read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = JsonReader.expectObjectStart(parser);
                String id = null;
                Date expires = null;
                while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    parser.nextToken();
                    try {
                        if (fieldName.equals("copy_ref")) {
                            id = JsonReader.StringReader.readField(parser, fieldName, id);
                            continue;
                        }
                        if (fieldName.equals("expires")) {
                            expires = JsonDateReader.Dropbox.readField(parser, fieldName, expires);
                            continue;
                        }
                        JsonReader.skipValue(parser);
                    }
                    catch (JsonReadException ex) {
                        throw ex.addFieldContext(fieldName);
                    }
                }
                JsonReader.expectObjectEnd(parser);
                if (id == null) {
                    throw new JsonReadException("missing field \"copy_ref\"", top);
                }
                if (expires == null) {
                    throw new JsonReadException("missing field \"expires\"", top);
                }
                return new CopyRef(id, expires);
            }
        };

        private CopyRef(String id, Date expires) {
            this.id = id;
            this.expires = expires;
        }
    }

    public static final class IODbxException
    extends IOException {
        private static final long serialVersionUID = 0L;
        public final DbxException underlying;

        public IODbxException(DbxException underlying) {
            super(underlying);
            this.underlying = underlying;
        }
    }

    private final class ChunkedUploadOutputStream
    extends OutputStream {
        private final byte[] chunk;
        private int chunkPos = 0;
        private String uploadId;
        private long uploadOffset;

        private ChunkedUploadOutputStream(int chunkSize) {
            this.chunk = new byte[chunkSize];
            this.chunkPos = 0;
        }

        @Override
        public void write(int i) throws IOException {
            this.chunk[this.chunkPos++] = (byte)i;
            try {
                this.finishChunkIfNecessary();
            }
            catch (DbxException ex) {
                throw new IODbxException(ex);
            }
        }

        private void finishChunkIfNecessary() throws DbxException {
            assert (this.chunkPos <= this.chunk.length);
            if (this.chunkPos == this.chunk.length) {
                this.finishChunk();
            }
        }

        private void finishChunk() throws DbxException {
            if (this.chunkPos == 0) {
                return;
            }
            if (this.uploadId == null) {
                this.uploadId = DbxRequestUtil.runAndRetry(3, new DbxRequestUtil.RequestMaker<String, RuntimeException>(){

                    @Override
                    public String run() throws DbxException {
                        return DbxClientV1.this.chunkedUploadFirst(ChunkedUploadOutputStream.this.chunk, 0, ChunkedUploadOutputStream.this.chunkPos);
                    }
                });
                this.uploadOffset = this.chunkPos;
            } else {
                final String uploadId = this.uploadId;
                int arrayOffset = 0;
                while (true) {
                    final int arrayOffsetFinal = arrayOffset;
                    long correctedOffset = DbxRequestUtil.runAndRetry(3, new DbxRequestUtil.RequestMaker<Long, RuntimeException>(){

                        @Override
                        public Long run() throws DbxException {
                            return DbxClientV1.this.chunkedUploadAppend(uploadId, ChunkedUploadOutputStream.this.uploadOffset, ChunkedUploadOutputStream.this.chunk, arrayOffsetFinal, ChunkedUploadOutputStream.this.chunkPos - arrayOffsetFinal);
                        }
                    });
                    long expectedOffset = this.uploadOffset + (long)this.chunkPos;
                    if (correctedOffset == -1L) {
                        this.uploadOffset = expectedOffset;
                        break;
                    }
                    int adjustAmount = (int)(correctedOffset - this.uploadOffset);
                    arrayOffset += adjustAmount;
                }
            }
            this.chunkPos = 0;
        }

        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            int bytesToCopy;
            int inputEnd = offset + length;
            for (int inputPos = offset; inputPos < inputEnd; inputPos += bytesToCopy) {
                int spaceInChunk = this.chunk.length - this.chunkPos;
                int leftToWrite = inputEnd - inputPos;
                bytesToCopy = Math.min(leftToWrite, spaceInChunk);
                System.arraycopy(bytes, inputPos, this.chunk, this.chunkPos, bytesToCopy);
                this.chunkPos += bytesToCopy;
                try {
                    this.finishChunkIfNecessary();
                    continue;
                }
                catch (DbxException ex) {
                    throw new IODbxException(ex);
                }
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    private final class ChunkedUploader
    extends Uploader {
        private final String targetPath;
        private final DbxWriteMode writeMode;
        private final long numBytes;
        private final ChunkedUploadOutputStream body;

        private ChunkedUploader(String targetPath, DbxWriteMode writeMode, long numBytes, ChunkedUploadOutputStream body) {
            this.targetPath = targetPath;
            this.writeMode = writeMode;
            this.numBytes = numBytes;
            this.body = body;
        }

        @Override
        public OutputStream getBody() {
            return this.body;
        }

        @Override
        public void abort() {
        }

        @Override
        public DbxEntry.File finish() throws DbxException {
            if (this.body.uploadId == null) {
                return DbxClientV1.this.uploadFileSingle(this.targetPath, this.writeMode, this.body.chunkPos, new DbxStreamWriter.ByteArrayCopier(this.body.chunk, 0, this.body.chunkPos));
            }
            final String uploadId = this.body.uploadId;
            this.body.finishChunk();
            if (this.numBytes != -1L && this.numBytes != this.body.uploadOffset) {
                throw new IllegalStateException("'numBytes' is " + this.numBytes + " but you wrote " + this.body.uploadOffset + " bytes");
            }
            return DbxRequestUtil.runAndRetry(3, new DbxRequestUtil.RequestMaker<DbxEntry.File, RuntimeException>(){

                @Override
                public DbxEntry.File run() throws DbxException {
                    return DbxClientV1.this.chunkedUploadFinish(ChunkedUploader.this.targetPath, ChunkedUploader.this.writeMode, uploadId);
                }
            });
        }

        @Override
        public void close() {
        }
    }

    private static final class ChunkedUploadState
    extends Dumpable {
        public final String uploadId;
        public final long offset;
        public static final JsonReader<ChunkedUploadState> Reader = new JsonReader<ChunkedUploadState>(){

            @Override
            public ChunkedUploadState read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = JsonReader.expectObjectStart(parser);
                String uploadId = null;
                long bytesComplete = -1L;
                while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    parser.nextToken();
                    try {
                        if (fieldName.equals("upload_id")) {
                            uploadId = JsonReader.StringReader.readField(parser, fieldName, uploadId);
                            continue;
                        }
                        if (fieldName.equals("offset")) {
                            bytesComplete = JsonReader.readUnsignedLongField(parser, fieldName, bytesComplete);
                            continue;
                        }
                        JsonReader.skipValue(parser);
                    }
                    catch (JsonReadException ex) {
                        throw ex.addFieldContext(fieldName);
                    }
                }
                JsonReader.expectObjectEnd(parser);
                if (uploadId == null) {
                    throw new JsonReadException("missing field \"upload_id\"", top);
                }
                if (bytesComplete == -1L) {
                    throw new JsonReadException("missing field \"offset\"", top);
                }
                return new ChunkedUploadState(uploadId, bytesComplete);
            }
        };

        public ChunkedUploadState(String uploadId, long offset) {
            if (uploadId == null) {
                throw new IllegalArgumentException("'uploadId' can't be null");
            }
            if (uploadId.length() == 0) {
                throw new IllegalArgumentException("'uploadId' can't be empty");
            }
            if (offset < 0L) {
                throw new IllegalArgumentException("'offset' can't be negative");
            }
            this.uploadId = uploadId;
            this.offset = offset;
        }

        @Override
        protected void dumpFields(DumpWriter w) {
            w.f("uploadId").v(this.uploadId);
            w.f("offset").v(this.offset);
        }
    }

    private static final class SingleUploader
    extends Uploader {
        private HttpRequestor.Uploader httpUploader;
        private final long claimedBytes;
        private final CountingOutputStream body;

        public SingleUploader(HttpRequestor.Uploader httpUploader, long claimedBytes) {
            if (claimedBytes < 0L) {
                throw new IllegalArgumentException("'numBytes' must be greater than or equal to 0");
            }
            this.httpUploader = httpUploader;
            this.claimedBytes = claimedBytes;
            this.body = new CountingOutputStream(httpUploader.getBody());
        }

        @Override
        public OutputStream getBody() {
            return this.body;
        }

        @Override
        public void abort() {
            if (this.httpUploader == null) {
                throw new IllegalStateException("already called 'finish', 'abort', or 'close'");
            }
            HttpRequestor.Uploader p = this.httpUploader;
            this.httpUploader = null;
            p.abort();
        }

        @Override
        public void close() {
            if (this.httpUploader == null) {
                return;
            }
            this.abort();
        }

        @Override
        public DbxEntry.File finish() throws DbxException {
            HttpRequestor.Response response;
            long bytesWritten;
            if (this.httpUploader == null) {
                throw new IllegalStateException("already called 'finish', 'abort', or 'close'");
            }
            this.httpUploader = null;
            try (HttpRequestor.Uploader u = this.httpUploader;){
                bytesWritten = this.body.getBytesWritten();
                if (this.claimedBytes != bytesWritten) {
                    u.abort();
                    throw new IllegalStateException("You said you were going to upload " + this.claimedBytes + " bytes, but you wrote " + bytesWritten + " bytes to the Uploader's 'body' stream.");
                }
                response = u.finish();
            }
            HttpRequestor.Response nonNullResponse = response;
            return DbxRequestUtil.finishResponse(nonNullResponse, new DbxRequestUtil.ResponseHandler<DbxEntry.File>(){

                @Override
                public DbxEntry.File handle(HttpRequestor.Response response) throws DbxException {
                    if (response.getStatusCode() != 200) {
                        throw DbxRequestUtil.unexpectedStatus(response);
                    }
                    DbxEntry.File f = DbxRequestUtil.readJsonFromResponse(DbxEntry.File.Reader, response);
                    if (f.numBytes != bytesWritten) {
                        String requestId = DbxRequestUtil.getRequestId(response);
                        throw new BadResponseException(requestId, "we uploaded " + bytesWritten + ", but server returned metadata entry with file size " + f.numBytes);
                    }
                    return f;
                }
            });
        }
    }

    public static final class Downloader {
        public final DbxEntry.File metadata;
        public final InputStream body;

        public Downloader(DbxEntry.File metadata, InputStream body) {
            this.metadata = metadata;
            this.body = body;
        }

        DbxEntry.File copyBodyAndClose(OutputStream target) throws DbxException, IOException {
            try {
                IOUtil.copyStreamToStream(this.body, target);
            }
            catch (IOUtil.ReadException ex) {
                throw new NetworkIOException(ex.getCause());
            }
            catch (IOUtil.WriteException ex) {
                throw ex.getCause();
            }
            finally {
                this.close();
            }
            return this.metadata;
        }

        public void close() {
            IOUtil.closeInput(this.body);
        }
    }
}

