/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ConfirmedAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;

class QueuedMessageRemoveAction
extends ConfirmedAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String confirmTitleText_ = ResourceLoader.getText("DLG_CONFIRM_REMOVE_TITLE");
    private static final String confirmMessageText_ = ResourceLoader.getText("DLG_CONFIRM_REMOVE");
    private static final String text_ = ResourceLoader.getText("ACTION_REMOVE");
    private QueuedMessage message_ = null;
    private MessageQueue queue_ = null;

    public QueuedMessageRemoveAction(VObject object, QueuedMessage message, MessageQueue queue) {
        super(object, confirmTitleText_, confirmMessageText_);
        this.message_ = message;
        this.queue_ = queue;
    }

    @Override
    public String getText() {
        return text_;
    }

    @Override
    public void perform2(VActionContext context) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Removing queued message [" + this.message_.getID() + "] from message queue [" + this.queue_ + "].");
        }
        this.fireStartWorking();
        boolean deleted = false;
        try {
            this.queue_.remove(this.message_.getKey());
            deleted = true;
        }
        catch (AS400Exception e) {
            this.fireError(e);
            if (e.getAS400Message().getID().equals("CPF2410")) {
                deleted = true;
            }
        }
        catch (Exception e) {
            this.fireError(e);
        }
        this.fireStopWorking();
        if (deleted) {
            this.fireObjectDeleted();
        }
    }
}

