/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlDocument;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.RfmlRecordFormat;
import com.ibm.as400.data.XmlException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;

class RfmlDocument
extends PcmlDocument {
    static final long serialVersionUID = 5L;
    private static final String[] RFML_ATTRIBUTES = new String[]{"version", "ccsid"};
    private static final int DEFAULT_CCSID = 65535;
    private String m_Ccsid;
    private int m_CcsidInt;

    RfmlDocument(PcmlAttributeList attrs, String docName) {
        super(attrs, docName);
        this.setNodeType(5);
        this.setCcsid(this.getAttributeValue("ccsid"));
    }

    @Override
    String[] getAttributeList() {
        return RFML_ATTRIBUTES;
    }

    public final String getCcsid() {
        return this.m_Ccsid;
    }

    public final int getCcsidInt() {
        if (this.m_CcsidInt == 0) {
            return 65535;
        }
        return this.m_CcsidInt;
    }

    @Override
    protected AS400DataType getConverter(int dataType, int dataLength, int dataPrecision, int ccsid, String dateFormat, String dateSeparator, String timeFormat, String timeSeparator) throws PcmlException {
        if (dataType == 1) {
            if (ccsid != this.m_CcsidInt) {
                return new AS400Text(dataLength, ccsid);
            }
            switch (dataLength) {
                case 1: {
                    if (this.m_Text_1 == null) {
                        this.m_Text_1 = new AS400Text(dataLength, ccsid);
                    }
                    return this.m_Text_1;
                }
                case 10: {
                    if (this.m_Text_10 == null) {
                        this.m_Text_10 = new AS400Text(dataLength, ccsid);
                    }
                    return this.m_Text_10;
                }
            }
            return new AS400Text(dataLength, ccsid);
        }
        return super.getConverter(dataType, dataLength, dataPrecision, ccsid, dateFormat, dateSeparator, timeFormat, timeSeparator);
    }

    synchronized double getDoubleValue(String name) throws PcmlException {
        return this.getDoubleValue(name, new PcmlDimensions());
    }

    synchronized double getDoubleValue(String name, PcmlDimensions indices) throws PcmlException {
        Object value = this.getValue(name, indices);
        if (value == null) {
            throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{name});
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new PcmlException("STRING_OR_NUMBER", new Object[]{value.getClass().getName(), name});
    }

    RfmlRecordFormat getRecordFormatNode(String formatName) throws XmlException {
        PcmlNode node = this.getElement(formatName);
        if (node instanceof RfmlRecordFormat) {
            return (RfmlRecordFormat)node;
        }
        if (node == null) {
            throw new XmlException("ELEMENT_NOT_FOUND", new Object[]{formatName, "<recordformat>"});
        }
        throw new XmlException("WRONG_ELEMENT_TYPE", new Object[]{formatName, "<recordformat>"});
    }

    protected void setCcsid(String ccsid) {
        if (ccsid == null || ccsid.equals("")) {
            this.m_Ccsid = null;
            this.m_CcsidInt = 0;
            return;
        }
        try {
            this.m_Ccsid = ccsid;
            this.m_CcsidInt = Integer.parseInt(ccsid);
        }
        catch (NumberFormatException e) {
            this.m_Ccsid = null;
            this.m_CcsidInt = 0;
        }
    }

    public void toXml(OutputStream outStream) throws IOException, XmlException {
        try (PrintWriter xmlFile = null;){
            xmlFile = new PrintWriter(outStream);
            xmlFile.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            xmlFile.println("<!DOCTYPE rfml SYSTEM \"rfml.dtd\">");
            RfmlDocument.toXml(this, xmlFile, "");
            if (xmlFile.checkError()) {
                Trace.log(2, "Error when writing RFML to OutputStream.");
            }
        }
    }

    private static void toXml(PcmlDocNode node, PrintWriter writer, String indent) throws IOException, XmlException {
        writer.print(indent + "<" + node.getTagName());
        String[] attrs = node.getAttributeList();
        for (int i = 0; i < attrs.length; ++i) {
            if (node.getAttributeValue(attrs[i]) == null) continue;
            writer.print(" " + attrs[i] + "=\"" + node.getAttributeValue(attrs[i]) + "\"");
        }
        if ((node.getNodeType() != 4 || !node.getAttributeValue("type").equals("struct")) && node.hasChildren()) {
            writer.println(">");
            Enumeration children = node.getChildren();
            while (children.hasMoreElements()) {
                PcmlDocNode child = (PcmlDocNode)children.nextElement();
                RfmlDocument.toXml(child, writer, indent + "  ");
            }
            writer.println(indent + "</" + node.getTagName() + ">");
        } else {
            writer.println("/>");
        }
        writer.flush();
    }
}

