/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.data.PcmlDocRoot;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

abstract class PcmlNode
implements Serializable,
Cloneable {
    static final long serialVersionUID = -2955209136470053178L;
    private static Hashtable separatorsMap_;
    private PcmlNode parent = null;
    private PcmlNode prevSibling = null;
    private PcmlNode nextSibling = null;
    private PcmlNode firstChild = null;
    private PcmlNode lastChild = null;
    private int nbrChildren = 0;
    static final Character AMPERSAND;
    static final Character BLANK;
    static final Character COLON;
    static final Character COMMA;
    static final Character HYPHEN;
    static final Character PERIOD;
    static final Character SLASH;

    PcmlNode() {
    }

    public Object clone() {
        PcmlNode node = null;
        Object child = null;
        Object newChild = null;
        try {
            node = (PcmlNode)super.clone();
            node.parent = null;
            node.firstChild = null;
            node.lastChild = null;
            node.prevSibling = null;
            node.nextSibling = null;
            node.nbrChildren = 0;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return node;
    }

    void readObjectPostprocessing() {
        if (this.getNbrChildren() == 0) {
            return;
        }
        Enumeration items = this.getChildren();
        while (items.hasMoreElements()) {
            PcmlNode child = (PcmlNode)items.nextElement();
            child.readObjectPostprocessing();
        }
    }

    public abstract String getName();

    public abstract String getQualifiedName();

    protected final PcmlNode getParent() {
        return this.parent;
    }

    private final void setParent(PcmlNode node) {
        this.parent = node;
    }

    protected final PcmlNode getNextSibling() {
        return this.nextSibling;
    }

    private final void setNextSibling(PcmlNode node) {
        this.nextSibling = node;
    }

    protected final PcmlNode getPrevSibling() {
        return this.prevSibling;
    }

    private final void setPrevSibling(PcmlNode node) {
        this.prevSibling = node;
    }

    protected Enumeration getChildren() {
        Vector<PcmlNode> v = new Vector<PcmlNode>(this.nbrChildren);
        for (PcmlNode child = this.firstChild; child != null; child = child.getNextSibling()) {
            v.addElement(child);
        }
        return v.elements();
    }

    protected final int getNbrChildren() {
        return this.nbrChildren;
    }

    protected final int getChildNbr() {
        int birthOrder = 0;
        PcmlNode p = this;
        while (p.getPrevSibling() != null) {
            ++birthOrder;
            p = p.getPrevSibling();
        }
        return birthOrder;
    }

    protected final boolean hasChildren() {
        return this.nbrChildren > 0;
    }

    protected void addChild(PcmlNode node) {
        if (!this.hasChildren()) {
            this.firstChild = node;
        } else {
            this.lastChild.setNextSibling(node);
            node.setPrevSibling(this.lastChild);
        }
        this.lastChild = node;
        node.setParent(this);
        ++this.nbrChildren;
    }

    protected PcmlDocRoot getRootNode() {
        PcmlNode p = this;
        PcmlNode q = this.parent;
        while (q != null) {
            p = q;
            q = p.getParent();
        }
        if (p instanceof PcmlDocRoot) {
            return (PcmlDocRoot)p;
        }
        return null;
    }

    protected void printTree(PcmlNode p, int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
        System.out.println(p.toString());
        Enumeration items = p.getChildren();
        if (items == null) {
            return;
        }
        while (items.hasMoreElements()) {
            PcmlNode child = (PcmlNode)items.nextElement();
            this.printTree(child, level + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Hashtable getSeparatorsMap() {
        if (separatorsMap_ != null) return separatorsMap_;
        Class<PcmlNode> clazz = PcmlNode.class;
        synchronized (PcmlNode.class) {
            if (separatorsMap_ != null) return separatorsMap_;
            separatorsMap_ = new Hashtable(12);
            separatorsMap_.put("ampersand", AMPERSAND);
            separatorsMap_.put("blank", BLANK);
            separatorsMap_.put("colon", COLON);
            separatorsMap_.put("comma", COMMA);
            separatorsMap_.put("hyphen", HYPHEN);
            separatorsMap_.put("period", PERIOD);
            separatorsMap_.put("slash", SLASH);
            // ** MonitorExit[var0] (shouldn't be in output)
            return separatorsMap_;
        }
    }

    static boolean isValidSeparatorName(String separatorName) {
        boolean found = PcmlNode.getSeparatorsMap().containsKey(separatorName);
        if (found) {
            return true;
        }
        return separatorName.equals("none");
    }

    static Character separatorAsChar(String separatorName) {
        return (Character)PcmlNode.getSeparatorsMap().get(separatorName);
    }

    static {
        AMPERSAND = Character.valueOf('&');
        BLANK = Character.valueOf(' ');
        COLON = Character.valueOf(':');
        COMMA = Character.valueOf(',');
        HYPHEN = Character.valueOf('-');
        PERIOD = Character.valueOf('.');
        SLASH = Character.valueOf('/');
    }
}

