/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.ReturnCodeException;

public class ProxyException
extends RuntimeException
implements ReturnCodeException {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private int returnCode_;
    public static final int CONNECTION_NOT_ESTABLISHED = 1;
    public static final int CONNECTION_DROPPED = 2;
    public static final int CONNECTION_REJECTED = 3;
    public static final int VERSION_MISMATCH = 4;

    ProxyException(int returnCode, String message) {
        super(message);
        this.returnCode_ = returnCode;
    }

    ProxyException(int returnCode) {
        super(ResourceBundleLoader.getText(ProxyException.getMRIKey(returnCode)));
        this.returnCode_ = returnCode;
    }

    ProxyException(int returnCode, Throwable e) {
        super(ResourceBundleLoader.getText(ProxyException.getMRIKey(returnCode)), e);
        this.returnCode_ = returnCode;
    }

    private static String getMRIKey(int returnCode) {
        switch (returnCode) {
            case 1: {
                return "EXC_PROXY_CONNECTION_NOT_ESTABLISHED";
            }
            case 2: {
                return "EXC_PROXY_CONNECTION_DROPPED";
            }
            case 3: {
                return "EXC_PROXY_CONNECTION_REJECTED";
            }
            case 4: {
                return "EXC_PROXY_VERSION_MISMATCH";
            }
        }
        return "EXC_UNKNOWN";
    }

    @Override
    public int getReturnCode() {
        return this.returnCode_;
    }
}

