/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import java.io.Serializable;

final class IFSObjAttrs2
implements Serializable {
    static final long serialVersionUID = 4L;
    private byte[] data_;

    IFSObjAttrs2(byte[] data) {
        this.data_ = data;
    }

    final int getCCSID(int datastreamLevel) {
        int offsetToField = IFSObjAttrs2.determineCCSIDOffset(datastreamLevel);
        return BinaryConverter.byteArrayToShort(this.data_, offsetToField) & 0xFFFF;
    }

    final void setCCSID(int ccsid, int datastreamLevel) {
        int offsetToField = IFSObjAttrs2.determineCCSIDOffset(datastreamLevel);
        byte[] ccsidBytes = BinaryConverter.shortToByteArray((short)ccsid);
        System.arraycopy(ccsidBytes, 0, this.data_, offsetToField, 2);
    }

    final byte[] getData() {
        return this.data_;
    }

    final int getLength() {
        return this.data_.length;
    }

    final long getOwnerUID() {
        return (long)BinaryConverter.byteArrayToInt(this.data_, 64) & 0xFFFFFFFFL;
    }

    static final int determineCCSIDOffset(int datastreamLevel) {
        int offset_into_OA;
        switch (datastreamLevel) {
            case 0: {
                offset_into_OA = 126;
                break;
            }
            case 62708: {
                offset_into_OA = 142;
                break;
            }
            default: {
                offset_into_OA = 134;
            }
        }
        return offset_into_OA;
    }

    final int length() {
        return this.data_.length;
    }
}

