/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.io.UnsupportedEncodingException;

class DDMRecordCache {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final int BACKWARD = 1;
    static final int FORWARD = 0;
    int currentDirection_ = 0;
    private int currentPosition_;
    private boolean containsFirstRecord_;
    private boolean containsLastRecord_;
    private boolean isEmpty_;
    private Record[] records_ = new Record[0];
    private int size_;

    DDMRecordCache() {
        this.setIsEmpty();
    }

    DDMRecordCache(Record[] records, int direction, boolean firstRecord, boolean lastRecord) {
        this.refresh(records, direction, firstRecord, lastRecord);
    }

    void add(Record record, boolean end) {
        Record[] newRecords = new Record[this.records_.length + 1];
        if (end) {
            System.arraycopy(this.records_, 0, newRecords, 0, this.records_.length);
            newRecords[this.records_.length] = record;
        } else {
            System.arraycopy(this.records_, 0, newRecords, 1, this.records_.length);
            newRecords[0] = record;
            ++this.currentPosition_;
        }
        this.records_ = newRecords;
        this.size_ = this.records_.length;
        this.isEmpty_ = false;
    }

    boolean compareKeys(Object[] key, Object[] recKey) {
        if (key.length > recKey.length) {
            return false;
        }
        boolean match = true;
        int keyIndex = 0;
        int recKeyIndex = 0;
        RecordFormat rf = this.records_[0].getRecordFormat();
        block0: for (int j = 0; j < key.length && match; ++j) {
            if (key[j] instanceof byte[] && recKey[j] instanceof byte[]) {
                if (((byte[])key[j]).length != ((byte[])recKey[j]).length) {
                    match = false;
                    continue;
                }
                for (int k = 0; k < ((byte[])key[j]).length; ++k) {
                    if (((byte[])key[j])[k] == ((byte[])recKey[j])[k]) continue;
                    match = false;
                    continue block0;
                }
                continue;
            }
            if (rf.getKeyFieldDescription(j) instanceof VariableLengthFieldDescription) {
                if (((String)key[j]).equals("") && ((String)recKey[j]).equals("")) continue;
                keyIndex = ((String)key[j]).length() - 1;
                while (((String)key[j]).charAt(keyIndex) == ' ') {
                    --keyIndex;
                }
                recKeyIndex = ((String)recKey[j]).length() - 1;
                while (((String)recKey[j]).charAt(recKeyIndex) == ' ') {
                    --recKeyIndex;
                }
                if (((String)key[j]).substring(0, keyIndex + 1).equals(((String)recKey[j]).substring(0, recKeyIndex + 1))) continue;
                match = false;
                continue;
            }
            if (key[j].equals(recKey[j])) continue;
            match = false;
        }
        return match;
    }

    boolean containsFirstRecord() {
        return this.containsFirstRecord_;
    }

    boolean containsLastRecord() {
        return this.containsLastRecord_;
    }

    void dump() {
        System.out.println("Dumping cache:");
        for (int i = 0; i < this.records_.length; ++i) {
            System.out.println(this.records_[i]);
        }
    }

    int findRecord(int recordNumber) {
        for (int i = 0; i < this.size_; ++i) {
            if (this.records_[i].getRecordNumber() != recordNumber) continue;
            return i;
        }
        return -1;
    }

    int findRecordLong(long recordNumber) {
        for (int i = 0; i < this.size_; ++i) {
            if (this.records_[i].getRecordNumberLong() != recordNumber) continue;
            return i;
        }
        return -1;
    }

    int findRecord(Object[] key, boolean searchForward) throws UnsupportedEncodingException {
        if (key.length > this.records_[0].getKeyFields().length) {
            return -1;
        }
        if (searchForward) {
            for (int i = this.currentPosition_ + 1; i < this.size_; ++i) {
                boolean match = this.compareKeys(key, this.records_[i].getKeyFields());
                if (!match) continue;
                return i;
            }
        } else {
            for (int i = this.currentPosition_ - 1; i > -1; --i) {
                boolean match = this.compareKeys(key, this.records_[i].getKeyFields());
                if (!match) continue;
                return i;
            }
        }
        return -1;
    }

    Record getCurrent() {
        return this.currentPosition_ > -1 && this.currentPosition_ < this.size_ ? this.records_[this.currentPosition_] : null;
    }

    Record getFirst() {
        if (this.isEmpty_) {
            return null;
        }
        this.currentPosition_ = 0;
        return this.records_[this.currentPosition_];
    }

    Record getLast() {
        if (this.isEmpty_) {
            return null;
        }
        this.currentPosition_ = this.size_ - 1;
        return this.records_[this.currentPosition_];
    }

    Record getNext() {
        if (this.isEmpty_) {
            return null;
        }
        return this.currentPosition_ < this.size_ - 1 ? this.records_[++this.currentPosition_] : null;
    }

    Record getPrevious() {
        if (this.isEmpty_) {
            return null;
        }
        return this.currentPosition_ != 0 ? this.records_[--this.currentPosition_] : null;
    }

    Record getRecord(int recordNumber) {
        if (this.isEmpty_) {
            return null;
        }
        int index = this.findRecord(recordNumber);
        if (index != -1) {
            this.currentPosition_ = index;
            return this.records_[index];
        }
        return null;
    }

    Record getNextEqualRecord(Object[] key) throws UnsupportedEncodingException {
        if (this.isEmpty_) {
            return null;
        }
        int index = this.findRecord(key, true);
        if (index != -1) {
            this.currentPosition_ = index;
            return this.records_[index];
        }
        return null;
    }

    Record getPreviousEqualRecord(Object[] key) throws UnsupportedEncodingException {
        if (this.isEmpty_) {
            return null;
        }
        int index = this.findRecord(key, false);
        if (index != -1) {
            this.currentPosition_ = index;
            return this.records_[index];
        }
        return null;
    }

    boolean isAfterLast() {
        return this.isEmpty_ ? false : this.currentPosition_ == this.size_;
    }

    boolean isBeforeFirst() {
        return this.isEmpty_ ? false : this.currentPosition_ == -1;
    }

    boolean isBeginningOfCache() {
        return this.currentPosition_ <= 0;
    }

    boolean isEmpty() {
        return this.isEmpty_;
    }

    boolean isEndOfCache() {
        return this.currentPosition_ >= this.size_ - 1;
    }

    void refresh(Record[] records, int direction, boolean firstRecord, boolean lastRecord) {
        int i;
        this.currentDirection_ = direction;
        if (records == null || records.length == 0) {
            this.isEmpty_ = true;
            this.containsFirstRecord_ = false;
            this.containsLastRecord_ = false;
            this.currentPosition_ = -1;
            this.size_ = 0;
        } else {
            if (direction == 0) {
                this.records_ = records;
            } else {
                this.records_ = new Record[records.length];
                i = records.length - 1;
                int j = 0;
                while (i >= 0) {
                    this.records_[j] = records[i];
                    --i;
                    ++j;
                }
            }
            this.containsFirstRecord_ = firstRecord;
            this.containsLastRecord_ = lastRecord;
            this.currentPosition_ = direction == 0 ? 0 : records.length - 1;
            this.size_ = this.records_.length;
            this.isEmpty_ = false;
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Record cache refreshed:");
            for (i = 0; i < this.records_.length; ++i) {
                Trace.log(3, this.records_[i].toString());
            }
        }
    }

    void setIsEmpty() {
        this.isEmpty_ = true;
        this.containsFirstRecord_ = false;
        this.containsLastRecord_ = false;
        this.currentPosition_ = -1;
        this.size_ = 0;
    }

    boolean setPosition(int recordNumber) {
        if (this.isEmpty_) {
            return false;
        }
        int i = this.findRecord(recordNumber);
        if (i > -1) {
            this.currentPosition_ = i;
        }
        return i > -1;
    }

    boolean setPositionLong(long recordNumber) {
        if (this.isEmpty_) {
            return false;
        }
        int i = this.findRecordLong(recordNumber);
        if (i > -1) {
            this.currentPosition_ = i;
        }
        return i > -1;
    }

    boolean setPosition(Object[] key) throws UnsupportedEncodingException {
        if (this.isEmpty_) {
            return false;
        }
        int i = this.findRecord(key, true);
        if (i > -1) {
            this.currentPosition_ = i;
        }
        return i > -1;
    }

    void setPositionAfterLast() {
        if (!this.isEmpty_) {
            this.currentPosition_ = this.size_;
        }
    }

    void setPositionBeforeFirst() {
        if (!this.isEmpty_) {
            this.currentPosition_ = -1;
        }
    }

    void setPositionFirst() {
        if (!this.isEmpty_) {
            this.currentPosition_ = 0;
        }
    }

    void setPositionLast() {
        if (!this.isEmpty_) {
            this.currentPosition_ = this.size_ - 1;
        }
    }

    void setPositionNext() {
        if (!this.isEmpty_ && this.currentPosition_ < this.size_) {
            ++this.currentPosition_;
        }
    }

    void setPositionPrevious() {
        if (!this.isEmpty_ && this.currentPosition_ > -1) {
            --this.currentPosition_;
        }
    }
}

