/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.nodelabels.FileSystemNodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.NodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.RMNodeLabel;
import org.apache.hadoop.yarn.nodelabels.event.NodeLabelsStoreEvent;
import org.apache.hadoop.yarn.nodelabels.event.NodeLabelsStoreEventType;
import org.apache.hadoop.yarn.nodelabels.event.RemoveClusterNodeLabels;
import org.apache.hadoop.yarn.nodelabels.event.StoreNewClusterNodeLabels;
import org.apache.hadoop.yarn.nodelabels.event.UpdateNodeToLabelsMappingsEvent;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
public class CommonNodeLabelsManager
extends AbstractService {
    protected static final Log LOG = LogFactory.getLog(CommonNodeLabelsManager.class);
    private static final int MAX_LABEL_LENGTH = 255;
    public static final Set<String> EMPTY_STRING_SET = Collections.unmodifiableSet(new HashSet(0));
    public static final Set<NodeLabel> EMPTY_NODELABEL_SET = Collections.unmodifiableSet(new HashSet(0));
    public static final String ANY = "*";
    public static final Set<String> ACCESS_ANY_LABEL_SET = ImmutableSet.of((Object)"*");
    private static final Pattern LABEL_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_]*");
    public static final int WILDCARD_PORT = 0;
    private boolean initNodeLabelStoreInProgress = false;
    @VisibleForTesting
    public static final String NODE_LABELS_NOT_ENABLED_ERR = "Node-label-based scheduling is disabled. Please check yarn.node-labels.enabled";
    public static final String NO_LABEL = "";
    protected Dispatcher dispatcher;
    protected ConcurrentMap<String, RMNodeLabel> labelCollections = new ConcurrentHashMap<String, RMNodeLabel>();
    protected ConcurrentMap<String, Host> nodeCollections = new ConcurrentHashMap<String, Host>();
    protected RMNodeLabel noNodeLabel;
    protected final ReentrantReadWriteLock.ReadLock readLock;
    protected final ReentrantReadWriteLock.WriteLock writeLock;
    protected NodeLabelsStore store;
    private boolean nodeLabelsEnabled = false;
    private boolean isCentralizedNodeLabelConfiguration = true;

    protected void handleStoreEvent(NodeLabelsStoreEvent event) {
        try {
            switch ((NodeLabelsStoreEventType)((Object)event.getType())) {
                case ADD_LABELS: {
                    StoreNewClusterNodeLabels storeNewClusterNodeLabelsEvent = (StoreNewClusterNodeLabels)event;
                    this.store.storeNewClusterNodeLabels(storeNewClusterNodeLabelsEvent.getLabels());
                    break;
                }
                case REMOVE_LABELS: {
                    RemoveClusterNodeLabels removeClusterNodeLabelsEvent = (RemoveClusterNodeLabels)event;
                    this.store.removeClusterNodeLabels(removeClusterNodeLabelsEvent.getLabels());
                    break;
                }
                case STORE_NODE_TO_LABELS: {
                    UpdateNodeToLabelsMappingsEvent updateNodeToLabelsMappingsEvent = (UpdateNodeToLabelsMappingsEvent)event;
                    this.store.updateNodeToLabelsMappings(updateNodeToLabelsMappingsEvent.getNodeToLabels());
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to store label modification to storage");
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public CommonNodeLabelsManager() {
        super(CommonNodeLabelsManager.class.getName());
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    protected void initDispatcher(Configuration conf) {
        this.dispatcher = new AsyncDispatcher("NodeLabelManager dispatcher");
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        asyncDispatcher.init(conf);
        asyncDispatcher.setDrainEventsOnStop();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.nodeLabelsEnabled = YarnConfiguration.areNodeLabelsEnabled((Configuration)conf);
        this.isCentralizedNodeLabelConfiguration = YarnConfiguration.isCentralizedNodeLabelConfiguration((Configuration)conf);
        this.noNodeLabel = new RMNodeLabel(NO_LABEL);
        this.labelCollections.put(NO_LABEL, this.noNodeLabel);
    }

    protected boolean isInitNodeLabelStoreInProgress() {
        return this.initNodeLabelStoreInProgress;
    }

    boolean isCentralizedConfiguration() {
        return this.isCentralizedNodeLabelConfiguration;
    }

    protected void initNodeLabelStore(Configuration conf) throws Exception {
        this.store = (NodeLabelsStore)ReflectionUtils.newInstance((Class)conf.getClass("yarn.node-labels.fs-store.impl.class", FileSystemNodeLabelsStore.class, NodeLabelsStore.class), (Configuration)conf);
        this.store.setNodeLabelsManager(this);
        this.store.init(conf);
        this.store.recover();
    }

    protected void startDispatcher() {
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        asyncDispatcher.start();
    }

    protected void serviceStart() throws Exception {
        if (this.nodeLabelsEnabled) {
            this.setInitNodeLabelStoreInProgress(true);
            this.initNodeLabelStore(this.getConfig());
            this.setInitNodeLabelStoreInProgress(false);
        }
        this.initDispatcher(this.getConfig());
        if (null != this.dispatcher) {
            this.dispatcher.register(NodeLabelsStoreEventType.class, new ForwardingEventHandler());
        }
        this.startDispatcher();
    }

    protected void stopDispatcher() {
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        if (null != asyncDispatcher) {
            asyncDispatcher.stop();
        }
    }

    protected void serviceStop() throws Exception {
        this.stopDispatcher();
        if (null != this.store) {
            this.store.close();
        }
    }

    public void addToCluserNodeLabels(Collection<NodeLabel> labels) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error((Object)NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        if (null == labels || labels.isEmpty()) {
            return;
        }
        ArrayList<NodeLabel> newLabels = new ArrayList<NodeLabel>();
        this.normalizeNodeLabels(labels);
        this.checkExclusivityMatch(labels);
        for (NodeLabel label : labels) {
            CommonNodeLabelsManager.checkAndThrowLabelName(label.getName());
        }
        for (NodeLabel label : labels) {
            if (this.labelCollections.get(label.getName()) != null) continue;
            this.labelCollections.put(label.getName(), new RMNodeLabel(label));
            newLabels.add(label);
        }
        if (null != this.dispatcher && !newLabels.isEmpty()) {
            this.dispatcher.getEventHandler().handle(new StoreNewClusterNodeLabels((List<NodeLabel>)newLabels));
        }
        LOG.info((Object)("Add labels: [" + StringUtils.join(labels.iterator(), (String)",") + "]"));
    }

    @VisibleForTesting
    public void addToCluserNodeLabelsWithDefaultExclusivity(Set<String> labels) throws IOException {
        HashSet<NodeLabel> nodeLabels = new HashSet<NodeLabel>();
        for (String label : labels) {
            nodeLabels.add(NodeLabel.newInstance((String)label));
        }
        this.addToCluserNodeLabels(nodeLabels);
    }

    protected void checkAddLabelsToNode(Map<NodeId, Set<String>> addedLabelsToNode) throws IOException {
        if (null == addedLabelsToNode || addedLabelsToNode.isEmpty()) {
            return;
        }
        Set knownLabels = this.labelCollections.keySet();
        for (Map.Entry<NodeId, Set<String>> entry : addedLabelsToNode.entrySet()) {
            NodeId nodeId = entry.getKey();
            Set<String> labels = entry.getValue();
            if (!knownLabels.containsAll(labels)) {
                String msg = "Not all labels being added contained by known label collections, please check, added labels=[" + StringUtils.join(labels, (String)",") + "]";
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
            if (labels.isEmpty()) continue;
            HashSet<String> newLabels = new HashSet<String>(this.getLabelsByNode(nodeId));
            newLabels.addAll(labels);
            if (newLabels.size() <= 1) continue;
            String msg = String.format("%d labels specified on host=%s after add labels to node, please note that we do not support specifying multiple labels on a single host for now.", newLabels.size(), nodeId.getHost());
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    public void addLabelsToNode(Map<NodeId, Set<String>> addedLabelsToNode) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error((Object)NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        addedLabelsToNode = this.normalizeNodeIdToLabels(addedLabelsToNode);
        this.checkAddLabelsToNode(addedLabelsToNode);
        this.internalUpdateLabelsOnNodes(addedLabelsToNode, NodeLabelUpdateOperation.ADD);
    }

    protected void checkRemoveFromClusterNodeLabels(Collection<String> labelsToRemove) throws IOException {
        if (null == labelsToRemove || labelsToRemove.isEmpty()) {
            return;
        }
        for (String label : labelsToRemove) {
            if ((label = this.normalizeLabel(label)) == null || label.isEmpty()) {
                throw new IOException("Label to be removed is null or empty");
            }
            if (this.labelCollections.containsKey(label)) continue;
            throw new IOException("Node label=" + label + " to be removed doesn't existed in cluster node labels collection.");
        }
    }

    protected void internalRemoveFromClusterNodeLabels(Collection<String> labelsToRemove) {
        for (Map.Entry nodeEntry : this.nodeCollections.entrySet()) {
            Host host = (Host)nodeEntry.getValue();
            if (null == host) continue;
            host.labels.removeAll(labelsToRemove);
            for (Node nm : host.nms.values()) {
                if (nm.labels == null) continue;
                nm.labels.removeAll(labelsToRemove);
            }
        }
        for (String label : labelsToRemove) {
            this.labelCollections.remove(label);
        }
        if (null != this.dispatcher) {
            this.dispatcher.getEventHandler().handle(new RemoveClusterNodeLabels(labelsToRemove));
        }
        LOG.info((Object)("Remove labels: [" + StringUtils.join(labelsToRemove.iterator(), (String)",") + "]"));
    }

    public void removeFromClusterNodeLabels(Collection<String> labelsToRemove) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error((Object)NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        labelsToRemove = this.normalizeLabels(labelsToRemove);
        this.checkRemoveFromClusterNodeLabels(labelsToRemove);
        this.internalRemoveFromClusterNodeLabels(labelsToRemove);
    }

    protected void checkRemoveLabelsFromNode(Map<NodeId, Set<String>> removeLabelsFromNode) throws IOException {
        Set knownLabels = this.labelCollections.keySet();
        for (Map.Entry<NodeId, Set<String>> entry : removeLabelsFromNode.entrySet()) {
            String msg;
            NodeId nodeId = entry.getKey();
            Set<String> labels = entry.getValue();
            if (!knownLabels.containsAll(labels)) {
                String msg2 = "Not all labels being removed contained by known label collections, please check, removed labels=[" + StringUtils.join(labels, (String)",") + "]";
                LOG.error((Object)msg2);
                throw new IOException(msg2);
            }
            Set<String> originalLabels = null;
            boolean nodeExisted = false;
            if (0 != nodeId.getPort()) {
                Node nm = this.getNMInNodeSet(nodeId);
                if (nm != null) {
                    originalLabels = nm.labels;
                    nodeExisted = true;
                }
            } else {
                Host host = (Host)this.nodeCollections.get(nodeId.getHost());
                if (null != host) {
                    originalLabels = host.labels;
                    nodeExisted = true;
                }
            }
            if (!nodeExisted) {
                msg = "Try to remove labels from NM=" + nodeId + ", but the NM doesn't existed";
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
            if (labels.isEmpty() || originalLabels != null && originalLabels.containsAll(labels)) continue;
            msg = "Try to remove labels = [" + StringUtils.join(labels, (String)",") + "], but not all labels contained by NM=" + nodeId;
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    private void addNodeToLabels(NodeId node, Set<String> labels) {
        for (String l : labels) {
            ((RMNodeLabel)this.labelCollections.get(l)).addNodeId(node);
        }
    }

    protected void removeNodeFromLabels(NodeId node, Set<String> labels) {
        for (String l : labels) {
            ((RMNodeLabel)this.labelCollections.get(l)).removeNodeId(node);
        }
    }

    private void replaceNodeForLabels(NodeId node, Set<String> oldLabels, Set<String> newLabels) {
        if (oldLabels != null) {
            this.removeNodeFromLabels(node, oldLabels);
        }
        this.addNodeToLabels(node, newLabels);
    }

    protected void internalUpdateLabelsOnNodes(Map<NodeId, Set<String>> nodeToLabels, NodeLabelUpdateOperation op) throws IOException {
        HashMap<NodeId, Set<String>> newNMToLabels = new HashMap<NodeId, Set<String>>();
        for (Map.Entry<NodeId, Set<String>> entry : nodeToLabels.entrySet()) {
            Node nm;
            NodeId nodeId = entry.getKey();
            Set<String> labels = entry.getValue();
            this.createHostIfNonExisted(nodeId.getHost());
            if (nodeId.getPort() == 0) {
                Host host = (Host)this.nodeCollections.get(nodeId.getHost());
                switch (op) {
                    case REMOVE: {
                        this.removeNodeFromLabels(nodeId, labels);
                        host.labels.removeAll(labels);
                        for (Node node : host.nms.values()) {
                            if (node.labels != null) {
                                node.labels.removeAll(labels);
                            }
                            this.removeNodeFromLabels(node.nodeId, labels);
                        }
                        break;
                    }
                    case ADD: {
                        this.addNodeToLabels(nodeId, labels);
                        host.labels.addAll(labels);
                        for (Node node : host.nms.values()) {
                            if (node.labels != null) {
                                node.labels.addAll(labels);
                            }
                            this.addNodeToLabels(node.nodeId, labels);
                        }
                        break;
                    }
                    case REPLACE: {
                        this.replaceNodeForLabels(nodeId, host.labels, labels);
                        host.labels.clear();
                        host.labels.addAll(labels);
                        for (Node node : host.nms.values()) {
                            this.replaceNodeForLabels(node.nodeId, node.labels, labels);
                            node.labels = null;
                        }
                        break;
                    }
                }
                newNMToLabels.put(nodeId, host.labels);
                continue;
            }
            if (EnumSet.of(NodeLabelUpdateOperation.ADD, NodeLabelUpdateOperation.REPLACE).contains((Object)op)) {
                this.createNodeIfNonExisted(nodeId);
                nm = this.getNMInNodeSet(nodeId);
                switch (op) {
                    case ADD: {
                        this.addNodeToLabels(nodeId, labels);
                        if (nm.labels == null) {
                            nm.labels = new HashSet<String>();
                        }
                        nm.labels.addAll(labels);
                        break;
                    }
                    case REPLACE: {
                        Set<String> oldLabels = this.getLabelsByNode(nodeId);
                        this.replaceNodeForLabels(nodeId, oldLabels, labels);
                        if (nm.labels == null) {
                            nm.labels = new HashSet<String>();
                        }
                        nm.labels.clear();
                        nm.labels.addAll(labels);
                        break;
                    }
                }
                newNMToLabels.put(nodeId, nm.labels);
                continue;
            }
            this.removeNodeFromLabels(nodeId, labels);
            nm = this.getNMInNodeSet(nodeId);
            if (nm.labels == null) continue;
            nm.labels.removeAll(labels);
            newNMToLabels.put(nodeId, nm.labels);
        }
        if (null != this.dispatcher && this.isCentralizedNodeLabelConfiguration) {
            this.dispatcher.getEventHandler().handle(new UpdateNodeToLabelsMappingsEvent((Map<NodeId, Set<String>>)newNMToLabels));
        }
        LOG.info((Object)(op.name() + " labels on nodes:"));
        for (Map.Entry<Object, Set<String>> entry : newNMToLabels.entrySet()) {
            LOG.info((Object)("  NM=" + entry.getKey() + ", labels=[" + StringUtils.join(entry.getValue().iterator(), (String)",") + "]"));
        }
    }

    public void removeLabelsFromNode(Map<NodeId, Set<String>> removeLabelsFromNode) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error((Object)NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        removeLabelsFromNode = this.normalizeNodeIdToLabels(removeLabelsFromNode);
        this.checkRemoveLabelsFromNode(removeLabelsFromNode);
        this.internalUpdateLabelsOnNodes(removeLabelsFromNode, NodeLabelUpdateOperation.REMOVE);
    }

    protected void checkReplaceLabelsOnNode(Map<NodeId, Set<String>> replaceLabelsToNode) throws IOException {
        if (null == replaceLabelsToNode || replaceLabelsToNode.isEmpty()) {
            return;
        }
        Set knownLabels = this.labelCollections.keySet();
        for (Map.Entry<NodeId, Set<String>> entry : replaceLabelsToNode.entrySet()) {
            NodeId nodeId = entry.getKey();
            Set<String> labels = entry.getValue();
            if (labels.size() > 1) {
                String msg = String.format("%d labels specified on host=%s, please note that we do not support specifying multiple labels on a single host for now.", labels.size(), nodeId.getHost());
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
            if (knownLabels.containsAll(labels)) continue;
            String msg = "Not all labels being replaced contained by known label collections, please check, new labels=[" + StringUtils.join(labels, (String)",") + "]";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    public void replaceLabelsOnNode(Map<NodeId, Set<String>> replaceLabelsToNode) throws IOException {
        if (!this.nodeLabelsEnabled) {
            LOG.error((Object)NODE_LABELS_NOT_ENABLED_ERR);
            throw new IOException(NODE_LABELS_NOT_ENABLED_ERR);
        }
        replaceLabelsToNode = this.normalizeNodeIdToLabels(replaceLabelsToNode);
        this.checkReplaceLabelsOnNode(replaceLabelsToNode);
        this.internalUpdateLabelsOnNodes(replaceLabelsToNode, NodeLabelUpdateOperation.REPLACE);
    }

    public Map<NodeId, Set<String>> getNodeLabels() {
        Map<NodeId, Set<String>> nodeToLabels = this.generateNodeLabelsInfoPerNode(String.class);
        return nodeToLabels;
    }

    public Map<NodeId, Set<NodeLabel>> getNodeLabelsInfo() {
        Map<NodeId, Set<NodeLabel>> nodeToLabels = this.generateNodeLabelsInfoPerNode(NodeLabel.class);
        return nodeToLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<NodeId, Set<T>> generateNodeLabelsInfoPerNode(Class<T> type) {
        try {
            this.readLock.lock();
            HashMap<NodeId, Set<String>> nodeToLabels = new HashMap<NodeId, Set<String>>();
            for (Map.Entry entry : this.nodeCollections.entrySet()) {
                String hostName = (String)entry.getKey();
                Host host = (Host)entry.getValue();
                for (NodeId nodeId : host.nms.keySet()) {
                    Set<String> nodeLabels;
                    if (type.isAssignableFrom(String.class)) {
                        nodeLabels = this.getLabelsByNode(nodeId);
                        if (nodeLabels == null || nodeLabels.isEmpty()) continue;
                        nodeToLabels.put(nodeId, nodeLabels);
                        continue;
                    }
                    nodeLabels = this.getLabelsInfoByNode(nodeId);
                    if (nodeLabels == null || nodeLabels.isEmpty()) continue;
                    nodeToLabels.put(nodeId, nodeLabels);
                }
                if (host.labels.isEmpty()) continue;
                if (type.isAssignableFrom(String.class)) {
                    nodeToLabels.put(NodeId.newInstance((String)hostName, (int)0), host.labels);
                    continue;
                }
                nodeToLabels.put(NodeId.newInstance((String)hostName, (int)0), this.createNodeLabelFromLabelNames(host.labels));
            }
            Map map = Collections.unmodifiableMap(nodeToLabels);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NodeId> getNodesWithoutALabel() {
        try {
            this.readLock.lock();
            HashSet<NodeId> nodes = new HashSet<NodeId>();
            for (Host host : this.nodeCollections.values()) {
                for (NodeId nodeId : host.nms.keySet()) {
                    if (!this.getLabelsByNode(nodeId).isEmpty()) continue;
                    nodes.add(nodeId);
                }
            }
            Set set = Collections.unmodifiableSet(nodes);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<String, Set<NodeId>> getLabelsToNodes() {
        try {
            this.readLock.lock();
            Map<String, Set<NodeId>> map = this.getLabelsToNodes(this.labelCollections.keySet());
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<NodeId>> getLabelsToNodes(Set<String> labels) {
        try {
            this.readLock.lock();
            Map<String, Set<NodeId>> labelsToNodes = this.getLabelsToNodesMapping(labels, String.class);
            Map<String, Set<NodeId>> map = Collections.unmodifiableMap(labelsToNodes);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<NodeLabel, Set<NodeId>> getLabelsInfoToNodes() {
        try {
            this.readLock.lock();
            Map<NodeLabel, Set<NodeId>> map = this.getLabelsInfoToNodes(this.labelCollections.keySet());
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<NodeLabel, Set<NodeId>> getLabelsInfoToNodes(Set<String> labels) {
        try {
            this.readLock.lock();
            Map<NodeLabel, Set<NodeId>> labelsToNodes = this.getLabelsToNodesMapping(labels, NodeLabel.class);
            Map<NodeLabel, Set<NodeId>> map = Collections.unmodifiableMap(labelsToNodes);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private <T> Map<T, Set<NodeId>> getLabelsToNodesMapping(Set<String> labels, Class<T> type) {
        HashMap<T, Set<NodeId>> labelsToNodes = new HashMap<T, Set<NodeId>>();
        for (String label : labels) {
            if (label.equals(NO_LABEL)) continue;
            RMNodeLabel nodeLabelInfo = (RMNodeLabel)this.labelCollections.get(label);
            if (nodeLabelInfo != null) {
                Set<NodeId> nodeIds = nodeLabelInfo.getAssociatedNodeIds();
                if (nodeIds.isEmpty()) continue;
                if (type.isAssignableFrom(String.class)) {
                    labelsToNodes.put(type.cast(label), nodeIds);
                    continue;
                }
                labelsToNodes.put(type.cast(nodeLabelInfo.getNodeLabel()), nodeIds);
                continue;
            }
            LOG.warn((Object)("getLabelsToNodes : Label [" + label + "] cannot be found"));
        }
        return labelsToNodes;
    }

    public Set<String> getClusterNodeLabelNames() {
        try {
            this.readLock.lock();
            HashSet labels = new HashSet(this.labelCollections.keySet());
            labels.remove(NO_LABEL);
            Set<String> set = Collections.unmodifiableSet(labels);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeLabel> getClusterNodeLabels() {
        try {
            this.readLock.lock();
            ArrayList<NodeLabel> nodeLabels = new ArrayList<NodeLabel>();
            for (RMNodeLabel label : this.labelCollections.values()) {
                if (label.getLabelName().equals(NO_LABEL)) continue;
                nodeLabels.add(NodeLabel.newInstance((String)label.getLabelName(), (boolean)label.getIsExclusive()));
            }
            ArrayList<NodeLabel> arrayList = nodeLabels;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExclusiveNodeLabel(String nodeLabel) throws IOException {
        if (nodeLabel.equals(NO_LABEL)) {
            return this.noNodeLabel.getIsExclusive();
        }
        try {
            this.readLock.lock();
            RMNodeLabel label = (RMNodeLabel)this.labelCollections.get(nodeLabel);
            if (label == null) {
                String message = "Getting is-exclusive-node-label, node-label = " + nodeLabel + ", is not existed.";
                LOG.error((Object)message);
                throw new IOException(message);
            }
            boolean bl = label.getIsExclusive();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static void checkAndThrowLabelName(String label) throws IOException {
        if (label == null || label.isEmpty() || label.length() > 255) {
            throw new IOException("label added is empty or exceeds 255 character(s)");
        }
        boolean match = LABEL_PATTERN.matcher(label = label.trim()).matches();
        if (!match) {
            throw new IOException("label name should only contains {0-9, a-z, A-Z, -, _} and should not started with {-,_}, now it is=" + label);
        }
    }

    private void checkExclusivityMatch(Collection<NodeLabel> labels) throws IOException {
        ArrayList<NodeLabel> mismatchlabels = new ArrayList<NodeLabel>();
        for (NodeLabel label : labels) {
            RMNodeLabel rmNodeLabel = (RMNodeLabel)this.labelCollections.get(label.getName());
            if (rmNodeLabel == null || rmNodeLabel.getIsExclusive() == label.isExclusive()) continue;
            mismatchlabels.add(label);
        }
        if (mismatchlabels.size() > 0) {
            throw new IOException("Exclusivity cannot be modified for an existing label with : " + StringUtils.join(mismatchlabels.iterator(), (String)","));
        }
    }

    protected String normalizeLabel(String label) {
        if (label != null) {
            return label.trim();
        }
        return NO_LABEL;
    }

    private Set<String> normalizeLabels(Collection<String> labels) {
        HashSet<String> newLabels = new HashSet<String>();
        for (String label : labels) {
            newLabels.add(this.normalizeLabel(label));
        }
        return newLabels;
    }

    private void normalizeNodeLabels(Collection<NodeLabel> labels) {
        for (NodeLabel label : labels) {
            label.setName(this.normalizeLabel(label.getName()));
        }
    }

    protected Node getNMInNodeSet(NodeId nodeId) {
        return this.getNMInNodeSet(nodeId, this.nodeCollections);
    }

    protected Node getNMInNodeSet(NodeId nodeId, Map<String, Host> map) {
        return this.getNMInNodeSet(nodeId, map, false);
    }

    protected Node getNMInNodeSet(NodeId nodeId, Map<String, Host> map, boolean checkRunning) {
        Host host = map.get(nodeId.getHost());
        if (null == host) {
            return null;
        }
        Node nm = host.nms.get(nodeId);
        if (null == nm) {
            return null;
        }
        if (checkRunning) {
            return nm.running ? nm : null;
        }
        return nm;
    }

    protected Set<String> getLabelsByNode(NodeId nodeId) {
        return this.getLabelsByNode(nodeId, this.nodeCollections);
    }

    protected Set<String> getLabelsByNode(NodeId nodeId, Map<String, Host> map) {
        Host host = map.get(nodeId.getHost());
        if (null == host) {
            return EMPTY_STRING_SET;
        }
        Node nm = host.nms.get(nodeId);
        if (null != nm && null != nm.labels) {
            return nm.labels;
        }
        return host.labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NodeLabel> getLabelsInfoByNode(NodeId nodeId) {
        try {
            Set<NodeLabel> nodeLabels;
            this.readLock.lock();
            Set<String> labels = this.getLabelsByNode(nodeId, this.nodeCollections);
            if (labels.isEmpty()) {
                Set<NodeLabel> set = EMPTY_NODELABEL_SET;
                return set;
            }
            Set<NodeLabel> set = nodeLabels = this.createNodeLabelFromLabelNames(labels);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Set<NodeLabel> createNodeLabelFromLabelNames(Set<String> labels) {
        HashSet<NodeLabel> nodeLabels = new HashSet<NodeLabel>();
        for (String label : labels) {
            RMNodeLabel rmLabel;
            if (label.equals(NO_LABEL) || (rmLabel = (RMNodeLabel)this.labelCollections.get(label)) == null) continue;
            nodeLabels.add(rmLabel.getNodeLabel());
        }
        return nodeLabels;
    }

    protected void createNodeIfNonExisted(NodeId nodeId) throws IOException {
        Host host = (Host)this.nodeCollections.get(nodeId.getHost());
        if (null == host) {
            throw new IOException("Should create host before creating node.");
        }
        Node nm = host.nms.get(nodeId);
        if (null == nm) {
            host.nms.put(nodeId, new Node(nodeId));
        }
    }

    protected void createHostIfNonExisted(String hostName) {
        Host host = (Host)this.nodeCollections.get(hostName);
        if (null == host) {
            host = new Host();
            this.nodeCollections.put(hostName, host);
        }
    }

    protected Map<NodeId, Set<String>> normalizeNodeIdToLabels(Map<NodeId, Set<String>> nodeIdToLabels) {
        TreeMap<NodeId, Set<String>> newMap = new TreeMap<NodeId, Set<String>>();
        for (Map.Entry<NodeId, Set<String>> entry : nodeIdToLabels.entrySet()) {
            NodeId id = entry.getKey();
            Set<String> labels = entry.getValue();
            newMap.put(id, this.normalizeLabels(labels));
        }
        return newMap;
    }

    public void setInitNodeLabelStoreInProgress(boolean initNodeLabelStoreInProgress) {
        this.initNodeLabelStoreInProgress = initNodeLabelStoreInProgress;
    }

    private final class ForwardingEventHandler
    implements EventHandler<NodeLabelsStoreEvent> {
        private ForwardingEventHandler() {
        }

        @Override
        public void handle(NodeLabelsStoreEvent event) {
            CommonNodeLabelsManager.this.handleStoreEvent(event);
        }
    }

    private static enum NodeLabelUpdateOperation {
        ADD,
        REMOVE,
        REPLACE;

    }

    protected static class Node {
        public Set<String> labels = null;
        public Resource resource = Resource.newInstance((int)0, (int)0);
        public boolean running = false;
        public NodeId nodeId;

        protected Node(NodeId nodeid) {
            this.nodeId = nodeid;
        }

        public Node copy() {
            Node c = new Node(this.nodeId);
            if (this.labels != null) {
                c.labels = Collections.newSetFromMap(new ConcurrentHashMap());
                c.labels.addAll(this.labels);
            } else {
                c.labels = null;
            }
            c.resource = Resources.clone(this.resource);
            c.running = this.running;
            return c;
        }
    }

    protected static class Host {
        public Set<String> labels = Collections.newSetFromMap(new ConcurrentHashMap());
        public Map<NodeId, Node> nms = new ConcurrentHashMap<NodeId, Node>();

        protected Host() {
        }

        public Host copy() {
            Host c = new Host();
            c.labels = new HashSet<String>(this.labels);
            for (Map.Entry<NodeId, Node> entry : this.nms.entrySet()) {
                c.nms.put(entry.getKey(), entry.getValue().copy());
            }
            return c;
        }
    }
}

